/*
 * Decompiled with CFR 0.152.
 */
package com.github.elenterius.biomancy.util;

import com.github.elenterius.biomancy.util.serialization.IntegerSerializable;

public class Bit32Set
implements IntegerSerializable {
    private int bits;

    private void validateIndex(int bitIndex) {
        if (bitIndex < 0) {
            throw new IndexOutOfBoundsException("bitIndex < 0: " + bitIndex);
        }
        if (bitIndex >= 32) {
            throw new IndexOutOfBoundsException("bitIndex >= 32: " + bitIndex);
        }
    }

    public void set(int bitIndex) {
        this.validateIndex(bitIndex);
        this.bits |= 1 << bitIndex;
    }

    public void set(int bitIndex, boolean value) {
        if (value) {
            this.set(bitIndex);
        } else {
            this.clear(bitIndex);
        }
    }

    public boolean get(int bitIndex) {
        this.validateIndex(bitIndex);
        return (this.bits & 1 << bitIndex) != 0;
    }

    public void flip(int bitIndex) {
        this.validateIndex(bitIndex);
        this.bits ^= 1 << bitIndex;
    }

    public void clear(int bitIndex) {
        this.validateIndex(bitIndex);
        this.bits &= ~(1 << bitIndex);
    }

    public void clear() {
        this.bits = 0;
    }

    public int cardinality() {
        return Integer.bitCount(this.bits);
    }

    public int nextSetBit(int fromIndex) {
        this.validateIndex(fromIndex);
        if (this.bits == 0) {
            return 32;
        }
        for (int i = fromIndex; i < 32; ++i) {
            if ((this.bits & 1 << i) == 0) continue;
            return i;
        }
        return 32;
    }

    public int[] getIndices() {
        if (this.bits == 0) {
            return new int[0];
        }
        int[] indices = new int[Integer.bitCount(this.bits)];
        int n = 0;
        for (int i = 0; i < 32; ++i) {
            if ((this.bits & 1 << i) == 0) continue;
            indices[n++] = i;
        }
        return indices;
    }

    public int getBits() {
        return this.bits;
    }

    @Override
    public int serializeToInteger() {
        return this.bits;
    }

    @Override
    public void deserializeFromInteger(int serializedValue) {
        this.bits = serializedValue;
    }
}

