/*
 * Decompiled with CFR 0.152.
 */
package com.github.elenterius.biomancy.util;

import java.util.ArrayList;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class VectorUtil {
    public static final Vec3i XZ_PLANE = new Vec3i(1, 0, 1);
    public static final Vec3i XY_PLANE = new Vec3i(1, 1, 0);
    public static final Vec3i YZ_PLANE = new Vec3i(0, 1, 1);
    private static final Vec3i[] OFFSETS_CUBE_3I;

    private VectorUtil() {
    }

    public static Vec3i randomOffsetInCube3i(RandomSource random) {
        return OFFSETS_CUBE_3I[random.m_188503_(OFFSETS_CUBE_3I.length)];
    }

    public static Vec3i abs(Vec3i vec) {
        return new Vec3i(Math.abs(vec.m_123341_()), Math.abs(vec.m_123342_()), Math.abs(vec.m_123343_()));
    }

    public static Vec3i axisAlignedPlane3i(Direction direction) {
        Vec3i normal = direction.m_122436_();
        return new Vec3i(1 - Math.abs(normal.m_123341_()), 1 - Math.abs(normal.m_123342_()), 1 - Math.abs(normal.m_123343_()));
    }

    public static Vec3 axisAlignedPlane3d(Direction direction) {
        Vec3i normal = direction.m_122436_();
        return new Vec3(1.0 - (double)Math.abs(normal.m_123341_()), 1.0 - (double)Math.abs(normal.m_123342_()), 1.0 - (double)Math.abs(normal.m_123343_()));
    }

    public static double max(double a, double b, double c) {
        return Math.max(Math.max(a, b), c);
    }

    public static double boxDistanceSqr(AABB aabb, Vec3 pos) {
        double dx = VectorUtil.max(aabb.f_82288_ - pos.f_82479_, 0.0, pos.f_82479_ - aabb.f_82291_);
        double dy = VectorUtil.max(aabb.f_82289_ - pos.f_82480_, 0.0, pos.f_82480_ - aabb.f_82292_);
        double dz = VectorUtil.max(aabb.f_82290_ - pos.f_82481_, 0.0, pos.f_82481_ - aabb.f_82293_);
        return dx * dx + dy * dy + dz * dz;
    }

    static {
        ArrayList<Vec3i> offsets = new ArrayList<Vec3i>();
        for (int y = -1; y <= 1; ++y) {
            for (int x = -1; x <= 1; ++x) {
                for (int z = -1; z <= 1; ++z) {
                    if (x == 0 && y == 0 && z == 0) continue;
                    offsets.add(new Vec3i(x, y, z));
                }
            }
        }
        OFFSETS_CUBE_3I = offsets.toArray(new Vec3i[0]);
    }
}

