/*
 * Decompiled with CFR 0.152.
 */
package com.github.elenterius.biomancy.world.mound;

import com.github.elenterius.biomancy.util.ClimateUtil;
import com.github.elenterius.biomancy.world.mound.ChamberFactory;
import com.github.elenterius.biomancy.world.mound.ChamberFactoryType;
import com.github.elenterius.biomancy.world.mound.MoundChamber;
import com.github.elenterius.biomancy.world.mound.MoundShape;
import com.github.elenterius.biomancy.world.spatial.geometry.Shape;
import com.github.elenterius.biomancy.world.spatial.geometry.SphereShape;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3d;

public final class MoundGenerator {
    private MoundGenerator() {
    }

    public static MoundShape constructShape(BlockPos blockOrigin, MoundShape.ProcGenValues procGenValues) {
        return MoundGenerator.genShape(blockOrigin, procGenValues);
    }

    public static MoundShape constructShape(Level level, BlockPos blockOrigin, long seed) {
        Biome biome = (Biome)level.m_204166_(blockOrigin).get();
        MoundShape.ProcGenValues procGenValues = new MoundShape.ProcGenValues(seed, -21, 5, 2, level.m_151558_(), level.m_5736_(), ClimateUtil.getTemperature(biome, blockOrigin), ClimateUtil.getHumidity(biome));
        return MoundGenerator.genShape(blockOrigin, procGenValues);
    }

    private static MoundShape genShape(BlockPos blockOrigin, MoundShape.ProcGenValues procGenValues) {
        Context ctx = new Context();
        ctx.random = RandomSource.m_216335_((long)procGenValues.seed());
        Vec3 origin = ctx.origin = Vec3.m_82512_((Vec3i)blockOrigin);
        float radius = 8.0f * (1.0f + Mth.m_14036_((float)procGenValues.radiusMultiplier(), (float)-0.5f, (float)1.5f));
        float biomeTemperature = procGenValues.biomeTemperature();
        float biomeHumidity = procGenValues.biomeHumidity();
        float heatMultiplier = ClimateUtil.rescale(biomeTemperature) * 0.5f + biomeTemperature / 2.0f * 0.5f;
        float coldMultiplier = ClimateUtil.isFreezing(biomeTemperature) ? 0.1f : 1.0f;
        float erosionMultiplier = 0.1f + biomeHumidity * coldMultiplier;
        float erosionMultiplierInv = 1.0f - erosionMultiplier;
        ctx.spikiness = Mth.m_14036_((float)(procGenValues.heightMultiplier() + heatMultiplier), (float)0.0f, (float)1.0f);
        ctx.slantMultiplier = 0.1f + ctx.random.m_188501_() + heatMultiplier * 2.0f;
        ctx.relativeWallThickness = Mth.m_14036_((float)((1.0f - heatMultiplier) * 8.0f), (float)2.25f, (float)8.0f);
        ctx.minMoundRadius = 3.0f + erosionMultiplier * 3.0f;
        ctx.baseMoundRadius = radius + radius / 2.0f * erosionMultiplierInv;
        ctx.maxMoundRadius = ctx.minMoundRadius + ctx.baseMoundRadius;
        float subSpireRadius = ctx.maxMoundRadius / 2.0f;
        float subSpires = Mth.m_14036_((float)procGenValues.subSpires(), (float)0.0f, (float)MoundGenerator.countCirclesOnCircumference(ctx.maxMoundRadius, subSpireRadius));
        int maxBuildHeight = procGenValues.maxBuildHeight();
        int seaLevel = procGenValues.seaLevel();
        float maxMoundHeight = Mth.m_14036_((float)((float)maxBuildHeight * ctx.spikiness), (float)0.0f, (float)(maxBuildHeight - seaLevel));
        ctx.dirLean = new Vec3((double)(ctx.random.m_188501_() - ctx.random.m_188501_()), 0.0, (double)(ctx.random.m_188501_() - ctx.random.m_188501_())).m_82541_();
        ctx.maxLean = ctx.dirLean.m_82490_(2.0);
        MoundGenerator.genSpire(origin.f_82479_, origin.f_82480_, origin.f_82481_, maxMoundHeight, ctx.baseMoundRadius, ctx, true);
        float subRadius = (ctx.baseMoundRadius + ctx.relativeWallThickness) * Mth.m_14031_((float)((float)Math.PI / subSpires));
        float r = Mth.m_14179_((float)ctx.spikiness, (float)subSpireRadius, (float)ctx.baseMoundRadius) + ctx.relativeWallThickness;
        float startAngle = ctx.random.m_188501_() * ((float)Math.PI * 2);
        float angle = (float)Math.PI * 2 / subSpires;
        int n = 0;
        while ((float)n < subSpires) {
            float arc = startAngle + angle * (float)n;
            double xn = origin.f_82479_ + (double)(Mth.m_14031_((float)arc) * r);
            double zn = origin.f_82481_ + (double)(Mth.m_14089_((float)arc) * r);
            MoundGenerator.genSpire(xn, origin.f_82480_, zn, maxMoundHeight / (1.5f + ctx.random.m_188501_() * 1.5f), subRadius, ctx);
            ++n;
        }
        return new MoundShape(blockOrigin, ctx.boundingShapes, ctx.chambers, procGenValues);
    }

    private static void genSpire(double x, double y, double z, float maxHeight, float baseRadius, Context context) {
        MoundGenerator.genSpire(x, y, z, maxHeight, baseRadius, context, false);
    }

    private static void genSpire(double x, double y, double z, float maxHeight, float baseRadius, Context context, boolean isMainSpire) {
        float warmRadius;
        float t;
        float coldRadius;
        float radius;
        float height;
        Vector3d prevLean = new Vector3d(0.0, 0.0, 0.0);
        Vector3d leanOffset = new Vector3d(0.0, 0.0, 0.0);
        float prevRadius = baseRadius + context.relativeWallThickness;
        float totalHeight = 0.0f;
        if (isMainSpire) {
            prevRadius = Math.max(14.0f, prevRadius);
            float chamberRadius = Math.max(12.0f, prevRadius - context.relativeWallThickness / 2.0f);
            context.mainChamberRadius = chamberRadius * 0.9f;
            MoundGenerator.genSphereWithChambers(x, y, z, prevRadius, chamberRadius, context, ChamberFactoryType.CRADLE, true);
        } else {
            MoundGenerator.genSphereWithChambers(x, y, z, prevRadius, prevRadius - context.relativeWallThickness / 2.0f, context, ChamberFactoryType.DEFAULT, false);
        }
        while (totalHeight < maxHeight && !((height = totalHeight + (radius = Mth.m_14036_((float)Mth.m_14179_((float)context.spikiness, (float)(coldRadius = Mth.m_14179_((float)MoundGenerator.easeInQuad(t = totalHeight / maxHeight), (float)baseRadius, (float)context.minMoundRadius)), (float)(warmRadius = Mth.m_14179_((float)MoundGenerator.easeOutQuad(t), (float)baseRadius, (float)context.minMoundRadius))), (float)context.minMoundRadius, (float)context.maxMoundRadius) + context.relativeWallThickness) / 2.0f + Mth.m_14179_((float)t, (float)0.0f, (float)(radius / 2.5f))) >= maxHeight)) {
            double leanZ;
            leanOffset.set(context.dirLean.f_82479_, context.dirLean.f_82480_, context.dirLean.f_82481_);
            leanOffset.mul((double)((context.random.m_188501_() - 1.0f) * context.slantMultiplier));
            double leanX = prevLean.x + leanOffset.x;
            if (Math.abs(leanX) >= context.maxLean.f_82479_) {
                leanX = prevLean.x - leanOffset.z;
            }
            if (Math.abs(leanZ = prevLean.z + leanOffset.z) >= context.maxLean.f_82481_) {
                leanZ = prevLean.z - leanOffset.z;
            }
            MoundGenerator.genSphereWithChambers(x + leanX, y + (double)height, z + leanZ, radius, radius - context.relativeWallThickness / 2.0f, context, ChamberFactoryType.DEFAULT, isMainSpire);
            prevLean.set(leanX, 0.0, leanZ);
            prevRadius = radius;
            totalHeight = height;
        }
        ChamberFactoryType chamberType = isMainSpire ? ChamberFactoryType.END_CAP_MAIN_SPIRE : ChamberFactoryType.END_CAP_SUB_SPIRE;
        MoundGenerator.genSphereWithChambers(x + prevLean.x, y + (double)totalHeight + (double)(prevRadius / 2.0f * 1.5f), z + prevLean.z, prevRadius / 2.0f, prevRadius / 2.0f, context, chamberType, isMainSpire);
    }

    private static void genSphereWithChambers(double x, double y, double z, float radius, float chamberRadius, Context context, ChamberFactoryType type, boolean isMainSpire) {
        Vec3 pos = new Vec3(x, y, z);
        context.boundingShapes.add(new SphereShape(pos, radius));
        if (type == ChamberFactoryType.CRADLE) {
            Consumer<MoundChamber> consumer = chamber -> {
                context.cradleChambers.add((MoundChamber)chamber);
                context.chambers.add((MoundChamber)chamber);
            };
            ChamberFactory.SPECIAL_CRADLE.create(x, y, z, chamberRadius, context.random, consumer);
            return;
        }
        Consumer<MoundChamber> filteredConsumer = chamber -> {
            if (isMainSpire) {
                context.chambers.add((MoundChamber)chamber);
            } else {
                boolean intersectingWithCradleChamber = false;
                for (MoundChamber cradleChamber : context.cradleChambers) {
                    if (!cradleChamber.intersectsCuboid(chamber.getAABB())) continue;
                    intersectingWithCradleChamber = true;
                    break;
                }
                if (!intersectingWithCradleChamber) {
                    context.chambers.add((MoundChamber)chamber);
                }
            }
        };
        if (chamberRadius < 8.0f) {
            filteredConsumer.accept(new MoundChamber(new SphereShape(pos, chamberRadius)));
            return;
        }
        switch (type) {
            case DEFAULT: {
                ChamberFactory.RANDOM_DEFAULT.create(x, y, z, chamberRadius, context.random, filteredConsumer);
                break;
            }
            case END_CAP_MAIN_SPIRE: {
                ChamberFactory generator = context.random.m_188501_() < 0.8f ? ChamberFactory.ONE_SPHERE : ChamberFactory.ONE_BIG_FOUR_SMALL_ELLIPSOIDS;
                generator.create(x, y, z, chamberRadius, context.random, filteredConsumer);
                break;
            }
            case END_CAP_SUB_SPIRE: {
                ChamberFactory generator = context.random.m_188501_() < 0.8f ? ChamberFactory.ONE_BIG_FOUR_SMALL_ELLIPSOIDS : ChamberFactory.ONE_SPHERE;
                generator.create(x, y, z, chamberRadius, context.random, filteredConsumer);
                break;
            }
        }
    }

    private static float countCirclesOnCircumference(float radius, float subCircleRadius) {
        if (subCircleRadius > radius) {
            return 0.0f;
        }
        return (float)Math.PI / (float)Math.asin(subCircleRadius / radius);
    }

    private static float easeInQuad(float x) {
        return x * x;
    }

    private static float easeOutQuad(float x) {
        return 1.0f - (1.0f - x) * (1.0f - x);
    }

    private static class Context {
        List<Shape> boundingShapes = new ArrayList<Shape>();
        List<MoundChamber> chambers = new ArrayList<MoundChamber>();
        List<MoundChamber> cradleChambers = new ArrayList<MoundChamber>();
        RandomSource random;
        Vec3 origin;
        float spikiness;
        float slantMultiplier;
        float minMoundRadius;
        float baseMoundRadius;
        float maxMoundRadius;
        float mainChamberRadius;
        float relativeWallThickness;
        Vec3 dirLean;
        Vec3 maxLean;

        private Context() {
        }
    }
}

