/*
 * Decompiled with CFR 0.152.
 */
package com.github.elenterius.biomancy.world.mound.decorator;

import com.github.elenterius.biomancy.block.FleshBlock;
import com.github.elenterius.biomancy.block.orifice.OrificeBlock;
import com.github.elenterius.biomancy.init.ModBlocks;
import com.github.elenterius.biomancy.world.PrimordialEcosystem;
import com.github.elenterius.biomancy.world.mound.Chamber;
import com.github.elenterius.biomancy.world.mound.decorator.ChamberDecorator;
import com.github.elenterius.biomancy.world.mound.decorator.HangingCombsDecorator;
import com.github.elenterius.biomancy.world.mound.decorator.PillarsDecorator;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.SimpleWeightedRandomList;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public final class ChamberDecorators {
    public static final ChamberDecorator EMPTY = new ChamberDecorator(){

        @Override
        public ChamberDecorator.PartOfDecorationResult isBlockPartOfDecoration(Chamber chamber, Level level, BlockPos pos, BlockState state) {
            boolean materialValid = !PrimordialEcosystem.SOLID_FLESH_BLOCKS.contains(state.m_60734_());
            return ChamberDecorator.PartOfDecorationResult.of(true, materialValid);
        }

        @Override
        public boolean canPlace(Chamber chamber, Level level, BlockPos pos, Direction axisDirection) {
            return false;
        }

        @Override
        public boolean place(Chamber chamber, Level level, BlockPos pos, Direction axisDirection) {
            return false;
        }
    };
    public static final ChamberDecorator PRIMAL_FLESH_PILLARS = new PillarsDecorator(((FleshBlock)((Object)ModBlocks.PRIMAL_FLESH.get())).m_49966_(), ((FleshBlock)((Object)ModBlocks.SMOOTH_PRIMAL_FLESH.get())).m_49966_());
    public static final ChamberDecorator MALIGNANT_FLESH_PILLARS = new PillarsDecorator(((FleshBlock)((Object)ModBlocks.MALIGNANT_FLESH.get())).m_49966_(), ((FleshBlock)((Object)ModBlocks.POROUS_PRIMAL_FLESH.get())).m_49966_());
    public static final ChamberDecorator PRIMAL_ORIFICE_PILLARS = new PillarsDecorator(((OrificeBlock)((Object)ModBlocks.PRIMAL_ORIFICE.get())).m_49966_(), ((OrificeBlock)((Object)ModBlocks.PRIMAL_ORIFICE.get())).m_49966_(), ((FleshBlock)((Object)ModBlocks.PRIMAL_FLESH.get())).m_49966_());
    public static final ChamberDecorator PRIMAL_ORIFICE_COMBS = new HangingCombsDecorator(((OrificeBlock)((Object)ModBlocks.PRIMAL_ORIFICE.get())).m_49966_());
    public static final ChamberDecorator BONE_PILLARS = new PillarsDecorator(Blocks.f_50453_.m_49966_());
    public static final SimpleWeightedRandomList<ChamberDecorator> RANDOM_DEFAULTS = SimpleWeightedRandomList.m_146263_().m_146271_((Object)EMPTY, 10).m_146271_((Object)PRIMAL_FLESH_PILLARS, 25).m_146271_((Object)MALIGNANT_FLESH_PILLARS, 15).m_146271_((Object)PRIMAL_ORIFICE_PILLARS, 5).m_146271_((Object)PRIMAL_ORIFICE_COMBS, 7).m_146271_((Object)BONE_PILLARS, 17).m_146270_();

    private ChamberDecorators() {
    }

    public static ChamberDecorator getRandomDefault(RandomSource random) {
        return RANDOM_DEFAULTS.m_216820_(random).orElse(PRIMAL_FLESH_PILLARS);
    }
}

