/*
 * Decompiled with CFR 0.152.
 */
package com.github.elenterius.biomancy.world.section;

import com.github.elenterius.biomancy.world.ChunkPosConsumer;
import com.github.elenterius.biomancy.world.section.SectionPosConsumer;
import java.util.Spliterators;
import java.util.function.Consumer;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Cursor3D;
import net.minecraft.core.SectionPos;
import net.minecraft.world.phys.AABB;

public record SABB(long packedPosMin, long packedPosMax) {
    public static SABB from(SectionPos posA, SectionPos posB) {
        int minX = Math.min(posA.m_123170_(), posB.m_123170_());
        int minY = Math.min(posA.m_123206_(), posB.m_123206_());
        int minZ = Math.min(posA.m_123222_(), posB.m_123222_());
        int maxX = Math.max(posA.m_123170_(), posB.m_123170_());
        int maxY = Math.max(posA.m_123206_(), posB.m_123206_());
        int maxZ = Math.max(posA.m_123222_(), posB.m_123222_());
        long min = SectionPos.m_123209_((int)minX, (int)minY, (int)minZ);
        long max = SectionPos.m_123209_((int)maxX, (int)maxY, (int)maxZ);
        return new SABB(min, max);
    }

    public static SABB from(BlockPos posA, BlockPos posB) {
        int minX = Math.min(posA.m_123341_(), posB.m_123341_());
        int minY = Math.min(posA.m_123342_(), posB.m_123342_());
        int minZ = Math.min(posA.m_123343_(), posB.m_123343_());
        int maxX = Math.max(posA.m_123341_(), posB.m_123341_());
        int maxY = Math.max(posA.m_123342_(), posB.m_123342_());
        int maxZ = Math.max(posA.m_123343_(), posB.m_123343_());
        long min = SectionPos.m_123209_((int)SectionPos.m_123171_((int)minX), (int)SectionPos.m_123171_((int)minY), (int)SectionPos.m_123171_((int)minZ));
        long max = SectionPos.m_123209_((int)SectionPos.m_123171_((int)maxX), (int)SectionPos.m_123171_((int)maxY), (int)SectionPos.m_123171_((int)maxZ));
        return new SABB(min, max);
    }

    public static SABB from(AABB boundingBox) {
        long min = SectionPos.m_123209_((int)SectionPos.m_235865_((double)boundingBox.f_82288_), (int)SectionPos.m_235865_((double)boundingBox.f_82289_), (int)SectionPos.m_235865_((double)boundingBox.f_82290_));
        long max = SectionPos.m_123209_((int)SectionPos.m_235865_((double)boundingBox.f_82291_), (int)SectionPos.m_235865_((double)boundingBox.f_82292_), (int)SectionPos.m_235865_((double)boundingBox.f_82293_));
        return new SABB(min, max);
    }

    public int getMinX() {
        return SectionPos.m_123213_((long)this.packedPosMin);
    }

    public int getMinY() {
        return SectionPos.m_123225_((long)this.packedPosMin);
    }

    public int getMinZ() {
        return SectionPos.m_123230_((long)this.packedPosMin);
    }

    public int getMaxX() {
        return SectionPos.m_123213_((long)this.packedPosMax);
    }

    public int getMaxY() {
        return SectionPos.m_123225_((long)this.packedPosMax);
    }

    public int getMaxZ() {
        return SectionPos.m_123230_((long)this.packedPosMax);
    }

    public SectionPos getMinPos() {
        return SectionPos.m_123184_((long)this.packedPosMin);
    }

    public SectionPos getMaxPos() {
        return SectionPos.m_123184_((long)this.packedPosMax);
    }

    public long getSize() {
        long sizeX = this.getSizeX();
        long sizeY = this.getSizeY();
        long sizeZ = this.getSizeZ();
        return sizeX * sizeY * sizeZ;
    }

    public int getSizeX() {
        int minX = SectionPos.m_123213_((long)this.packedPosMin);
        int maxX = SectionPos.m_123213_((long)this.packedPosMax);
        return maxX - minX + 1;
    }

    public int getSizeY() {
        int minY = SectionPos.m_123225_((long)this.packedPosMin);
        int maxY = SectionPos.m_123225_((long)this.packedPosMax);
        return maxY - minY + 1;
    }

    public int getSizeZ() {
        int minZ = SectionPos.m_123230_((long)this.packedPosMin);
        int maxZ = SectionPos.m_123230_((long)this.packedPosMax);
        return maxZ - minZ + 1;
    }

    public boolean contains(BlockPos pos) {
        return this.containsSection(SectionPos.m_123171_((int)pos.m_123341_()), SectionPos.m_123171_((int)pos.m_123342_()), SectionPos.m_123171_((int)pos.m_123343_()));
    }

    public boolean containsSection(int x, int y, int z) {
        int minX = SectionPos.m_123213_((long)this.packedPosMin);
        int minY = SectionPos.m_123225_((long)this.packedPosMin);
        int minZ = SectionPos.m_123230_((long)this.packedPosMin);
        int maxX = SectionPos.m_123213_((long)this.packedPosMax);
        int maxY = SectionPos.m_123225_((long)this.packedPosMax);
        int maxZ = SectionPos.m_123230_((long)this.packedPosMax);
        return minX <= x && x <= maxX && minY <= y && y <= maxY && minZ <= z && z <= maxZ;
    }

    public void forEachSection(SectionPosConsumer action) {
        int minX = SectionPos.m_123213_((long)this.packedPosMin);
        int minY = SectionPos.m_123225_((long)this.packedPosMin);
        int minZ = SectionPos.m_123230_((long)this.packedPosMin);
        int maxX = SectionPos.m_123213_((long)this.packedPosMax);
        int maxY = SectionPos.m_123225_((long)this.packedPosMax);
        int maxZ = SectionPos.m_123230_((long)this.packedPosMax);
        for (int y = minY; y <= maxY; ++y) {
            for (int x = minX; x <= maxX; ++x) {
                for (int z = minZ; z <= maxZ; ++z) {
                    action.accept(x, y, z);
                }
            }
        }
    }

    public void forEachChunk(ChunkPosConsumer action) {
        int minX = SectionPos.m_123213_((long)this.packedPosMin);
        int minZ = SectionPos.m_123230_((long)this.packedPosMin);
        int maxX = SectionPos.m_123213_((long)this.packedPosMax);
        int maxZ = SectionPos.m_123230_((long)this.packedPosMax);
        for (int x = minX; x <= maxX; ++x) {
            for (int z = minZ; z <= maxZ; ++z) {
                action.accept(x, z);
            }
        }
    }

    public Stream<SectionPos> stream() {
        final int minX = SectionPos.m_123213_((long)this.packedPosMin);
        final int minY = SectionPos.m_123225_((long)this.packedPosMin);
        final int minZ = SectionPos.m_123230_((long)this.packedPosMin);
        final int maxX = SectionPos.m_123213_((long)this.packedPosMax);
        final int maxY = SectionPos.m_123225_((long)this.packedPosMax);
        final int maxZ = SectionPos.m_123230_((long)this.packedPosMax);
        long size = (long)(maxX - minX + 1) * (long)(maxY - minY + 1) * (long)(maxZ - minZ + 1);
        return StreamSupport.stream(new Spliterators.AbstractSpliterator<SectionPos>(size, 64){
            final Cursor3D cursor;
            {
                super(est, additionalCharacteristics);
                this.cursor = new Cursor3D(minX, minY, minZ, maxX, maxY, maxZ);
            }

            @Override
            public boolean tryAdvance(Consumer<? super SectionPos> action) {
                if (this.cursor.m_122304_()) {
                    action.accept((SectionPos)SectionPos.m_123173_((int)this.cursor.m_122305_(), (int)this.cursor.m_122306_(), (int)this.cursor.m_122307_()));
                    return true;
                }
                return false;
            }
        }, false);
    }

    @Override
    public String toString() {
        int minX = SectionPos.m_123213_((long)this.packedPosMin);
        int minY = SectionPos.m_123225_((long)this.packedPosMin);
        int minZ = SectionPos.m_123230_((long)this.packedPosMin);
        int maxX = SectionPos.m_123213_((long)this.packedPosMax);
        int maxY = SectionPos.m_123225_((long)this.packedPosMax);
        int maxZ = SectionPos.m_123230_((long)this.packedPosMax);
        long size = ((long)maxX - (long)minX + 1L) * (long)(maxY - minY + 1) * (long)(maxZ - minZ + 1);
        return "SectionABB{minX=" + minX + "minY=" + minY + "minZ=" + minZ + "maxX=" + maxX + "maxY=" + maxY + "maxZ=" + maxZ + ", size=" + size + "}";
    }
}

