/*
 * Decompiled with CFR 0.152.
 */
package com.github.elenterius.biomancy.world.spatial.geometry;

import com.github.elenterius.biomancy.util.serialization.NBTSerializer;
import com.github.elenterius.biomancy.world.spatial.geometry.Shape;
import com.github.elenterius.biomancy.world.spatial.type.ShapeSerializers;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class CuboidShape
implements Shape {
    private final Vec3 origin;
    private final AABB aabb;

    public CuboidShape(Vec3 min, Vec3 max) {
        this.aabb = new AABB(min, max);
        this.origin = this.aabb.m_82399_();
    }

    public CuboidShape(BlockPos min, BlockPos max) {
        this.aabb = new AABB(min, max);
        this.origin = this.aabb.m_82399_();
    }

    public CuboidShape(double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
        this.aabb = new AABB(minX, minY, minZ, maxX, maxY, maxZ);
        this.origin = this.aabb.m_82399_();
    }

    @Override
    public boolean contains(double x, double y, double z) {
        return this.aabb.m_82393_(x, y, z);
    }

    @Override
    public Vec3 center() {
        return this.origin;
    }

    @Override
    public double distanceToSqr(double x, double y, double z) {
        return this.origin.m_82531_(x, y, z);
    }

    @Override
    public AABB getAABB() {
        return this.aabb;
    }

    @Override
    public boolean intersectsCuboid(double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
        return this.aabb.m_82314_(minX, minY, minZ, maxX, maxY, maxZ);
    }

    @Override
    public NBTSerializer<Shape> getNBTSerializer() {
        return ShapeSerializers.CUBOID_SERIALIZER;
    }

    public record Serializer(String id) implements NBTSerializer<CuboidShape>
    {
        @Override
        public CompoundTag write(CuboidShape shape) {
            CompoundTag tag = new CompoundTag();
            tag.m_128388_("MinMax", new long[]{Double.doubleToLongBits(shape.aabb.f_82288_), Double.doubleToLongBits(shape.aabb.f_82289_), Double.doubleToLongBits(shape.aabb.f_82290_), Double.doubleToLongBits(shape.aabb.f_82291_), Double.doubleToLongBits(shape.aabb.f_82292_), Double.doubleToLongBits(shape.aabb.f_82293_)});
            return tag;
        }

        @Override
        public CuboidShape read(CompoundTag tag) {
            long[] minMax = tag.m_128467_("MinMax");
            double minX = Double.longBitsToDouble(minMax[0]);
            double minY = Double.longBitsToDouble(minMax[1]);
            double minZ = Double.longBitsToDouble(minMax[2]);
            double maxX = Double.longBitsToDouble(minMax[3]);
            double maxY = Double.longBitsToDouble(minMax[4]);
            double maxZ = Double.longBitsToDouble(minMax[5]);
            return new CuboidShape(minX, minY, minZ, maxX, maxY, maxZ);
        }
    }
}

