/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.modonomicon.book;

import com.google.common.base.Suppliers;
import com.google.gson.JsonObject;
import com.klikli_dev.modonomicon.api.ModonomiconConstants;
import com.klikli_dev.modonomicon.book.BookCategory;
import com.klikli_dev.modonomicon.book.BookCommand;
import com.klikli_dev.modonomicon.book.BookFrameOverlay;
import com.klikli_dev.modonomicon.book.entries.BookEntry;
import com.klikli_dev.modonomicon.book.error.BookErrorManager;
import com.klikli_dev.modonomicon.client.gui.book.markdown.BookTextRenderer;
import com.klikli_dev.modonomicon.registry.ItemRegistry;
import com.klikli_dev.modonomicon.util.ItemStackUtil;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.apache.commons.lang3.tuple.Triple;
import org.jetbrains.annotations.Nullable;

public class Book {
    protected ResourceLocation id;
    protected String name;
    protected String tooltip;
    protected String creativeTab;
    protected ResourceLocation model;
    protected ResourceLocation bookOverviewTexture;
    protected ResourceLocation frameTexture;
    protected BookFrameOverlay topFrameOverlay;
    protected BookFrameOverlay bottomFrameOverlay;
    protected BookFrameOverlay leftFrameOverlay;
    protected BookFrameOverlay rightFrameOverlay;
    protected ResourceLocation bookContentTexture;
    protected ResourceLocation craftingTexture;
    protected ResourceLocation turnPageSound;
    protected ConcurrentMap<ResourceLocation, BookCategory> categories;
    protected ConcurrentMap<ResourceLocation, BookEntry> entries;
    protected ConcurrentMap<ResourceLocation, BookCommand> commands;
    protected int defaultTitleColor;
    protected float categoryButtonIconScale;
    protected boolean autoAddReadConditions;
    protected boolean generateBookItem;
    @Nullable
    protected ResourceLocation customBookItem;
    protected ResourceLocation font;
    protected int bookTextOffsetX;
    protected int bookTextOffsetY;
    protected int bookTextOffsetWidth;
    protected int categoryButtonXOffset;
    protected int categoryButtonYOffset;
    protected int searchButtonXOffset;
    protected int searchButtonYOffset;
    protected int readAllButtonYOffset;
    protected Supplier<ItemStack> bookItem = Suppliers.memoize(() -> {
        if (this.customBookItem != null) {
            Triple<ResourceLocation, Integer, CompoundTag> parsed = ItemStackUtil.parseItemStackString(this.customBookItem.toString());
            return ItemStackUtil.loadFromParsed(parsed);
        }
        ItemStack stack = new ItemStack((ItemLike)ItemRegistry.MODONOMICON.get());
        CompoundTag tag = new CompoundTag();
        tag.m_128359_("modonomicon:book_id", this.id.toString());
        stack.m_41751_(tag);
        return stack;
    });

    public Book(ResourceLocation id, String name, String tooltip, ResourceLocation model, boolean generateBookItem, ResourceLocation customBookItem, String creativeTab, ResourceLocation font, ResourceLocation bookOverviewTexture, ResourceLocation frameTexture, BookFrameOverlay topFrameOverlay, BookFrameOverlay bottomFrameOverlay, BookFrameOverlay leftFrameOverlay, BookFrameOverlay rightFrameOverlay, ResourceLocation bookContentTexture, ResourceLocation craftingTexture, ResourceLocation turnPageSound, int defaultTitleColor, float categoryButtonIconScale, boolean autoAddReadConditions, int bookTextOffsetX, int bookTextOffsetY, int bookTextOffsetWidth, int categoryButtonXOffset, int categoryButtonYOffset, int searchButtonXOffset, int searchButtonYOffset, int readAllButtonYOffset) {
        this.id = id;
        this.name = name;
        this.tooltip = tooltip;
        this.model = model;
        this.generateBookItem = generateBookItem;
        this.customBookItem = customBookItem;
        this.creativeTab = creativeTab;
        this.bookOverviewTexture = bookOverviewTexture;
        this.font = font;
        this.frameTexture = frameTexture;
        this.topFrameOverlay = topFrameOverlay;
        this.bottomFrameOverlay = bottomFrameOverlay;
        this.leftFrameOverlay = leftFrameOverlay;
        this.rightFrameOverlay = rightFrameOverlay;
        this.bookContentTexture = bookContentTexture;
        this.craftingTexture = craftingTexture;
        this.turnPageSound = turnPageSound;
        this.defaultTitleColor = defaultTitleColor;
        this.categoryButtonIconScale = categoryButtonIconScale;
        this.autoAddReadConditions = autoAddReadConditions;
        this.categories = new ConcurrentHashMap<ResourceLocation, BookCategory>();
        this.entries = new ConcurrentHashMap<ResourceLocation, BookEntry>();
        this.commands = new ConcurrentHashMap<ResourceLocation, BookCommand>();
        this.bookTextOffsetX = bookTextOffsetX;
        this.bookTextOffsetY = bookTextOffsetY;
        this.bookTextOffsetWidth = bookTextOffsetWidth;
        this.categoryButtonXOffset = categoryButtonXOffset;
        this.categoryButtonYOffset = categoryButtonYOffset;
        this.searchButtonXOffset = searchButtonXOffset;
        this.searchButtonYOffset = searchButtonYOffset;
        this.readAllButtonYOffset = readAllButtonYOffset;
    }

    public static Book fromJson(ResourceLocation id, JsonObject json) {
        String name = GsonHelper.m_13906_((JsonObject)json, (String)"name");
        String tooltip = GsonHelper.m_13851_((JsonObject)json, (String)"tooltip", (String)"");
        ResourceLocation model = new ResourceLocation(GsonHelper.m_13851_((JsonObject)json, (String)"model", (String)ModonomiconConstants.Data.Book.DEFAULT_MODEL));
        boolean generateBookItem = GsonHelper.m_13855_((JsonObject)json, (String)"generate_book_item", (boolean)true);
        ResourceLocation customBookItem = json.has("custom_book_item") ? new ResourceLocation(GsonHelper.m_13906_((JsonObject)json, (String)"custom_book_item")) : null;
        String creativeTab = GsonHelper.m_13851_((JsonObject)json, (String)"creative_tab", (String)"misc");
        ResourceLocation bookOverviewTexture = new ResourceLocation(GsonHelper.m_13851_((JsonObject)json, (String)"book_overview_texture", (String)ModonomiconConstants.Data.Book.DEFAULT_OVERVIEW_TEXTURE));
        ResourceLocation frameTexture = new ResourceLocation(GsonHelper.m_13851_((JsonObject)json, (String)"frame_texture", (String)ModonomiconConstants.Data.Book.DEFAULT_FRAME_TEXTURE));
        BookFrameOverlay topFrameOverlay = json.has("top_frame_overlay") ? BookFrameOverlay.fromJson(json.get("top_frame_overlay").getAsJsonObject()) : ModonomiconConstants.Data.Book.DEFAULT_TOP_FRAME_OVERLAY;
        BookFrameOverlay bottomFrameOverlay = json.has("bottom_frame_overlay") ? BookFrameOverlay.fromJson(json.get("bottom_frame_overlay").getAsJsonObject()) : ModonomiconConstants.Data.Book.DEFAULT_BOTTOM_FRAME_OVERLAY;
        BookFrameOverlay leftFrameOverlay = json.has("left_frame_overlay") ? BookFrameOverlay.fromJson(json.get("left_frame_overlay").getAsJsonObject()) : ModonomiconConstants.Data.Book.DEFAULT_LEFT_FRAME_OVERLAY;
        BookFrameOverlay rightFrameOverlay = json.has("right_frame_overlay") ? BookFrameOverlay.fromJson(json.get("right_frame_overlay").getAsJsonObject()) : ModonomiconConstants.Data.Book.DEFAULT_RIGHT_FRAME_OVERLAY;
        ResourceLocation font = new ResourceLocation(GsonHelper.m_13851_((JsonObject)json, (String)"font", (String)ModonomiconConstants.Data.Book.DEFAULT_FONT));
        ResourceLocation bookContentTexture = new ResourceLocation(GsonHelper.m_13851_((JsonObject)json, (String)"book_content_texture", (String)ModonomiconConstants.Data.Book.DEFAULT_CONTENT_TEXTURE));
        ResourceLocation craftingTexture = new ResourceLocation(GsonHelper.m_13851_((JsonObject)json, (String)"crafting_texture", (String)ModonomiconConstants.Data.Book.DEFAULT_CRAFTING_TEXTURE));
        ResourceLocation turnPageSound = new ResourceLocation(GsonHelper.m_13851_((JsonObject)json, (String)"turn_page_sound", (String)ModonomiconConstants.Data.Book.DEFAULT_PAGE_TURN_SOUND));
        int defaultTitleColor = GsonHelper.m_13824_((JsonObject)json, (String)"default_title_color", (int)0);
        float categoryButtonIconScale = GsonHelper.m_13820_((JsonObject)json, (String)"category_button_icon_scale", (float)1.0f);
        boolean autoAddReadConditions = GsonHelper.m_13855_((JsonObject)json, (String)"auto_add_read_conditions", (boolean)false);
        int bookTextOffsetX = GsonHelper.m_13824_((JsonObject)json, (String)"book_text_offset_x", (int)0);
        int bookTextOffsetY = GsonHelper.m_13824_((JsonObject)json, (String)"book_text_offset_y", (int)0);
        int bookTextOffsetWidth = GsonHelper.m_13824_((JsonObject)json, (String)"book_text_offset_width", (int)0);
        int categoryButtonXOffset = GsonHelper.m_13824_((JsonObject)json, (String)"category_button_x_offset", (int)0);
        int categoryButtonYOffset = GsonHelper.m_13824_((JsonObject)json, (String)"category_button_y_offset", (int)0);
        int searchButtonXOffset = GsonHelper.m_13824_((JsonObject)json, (String)"search_button_x_offset", (int)0);
        int searchButtonYOffset = GsonHelper.m_13824_((JsonObject)json, (String)"search_button_y_offset", (int)0);
        int readAllButtonYOffset = GsonHelper.m_13824_((JsonObject)json, (String)"read_all_button_y_offset", (int)0);
        return new Book(id, name, tooltip, model, generateBookItem, customBookItem, creativeTab, font, bookOverviewTexture, frameTexture, topFrameOverlay, bottomFrameOverlay, leftFrameOverlay, rightFrameOverlay, bookContentTexture, craftingTexture, turnPageSound, defaultTitleColor, categoryButtonIconScale, autoAddReadConditions, bookTextOffsetX, bookTextOffsetY, bookTextOffsetWidth, categoryButtonXOffset, categoryButtonYOffset, searchButtonXOffset, searchButtonYOffset, readAllButtonYOffset);
    }

    public static Book fromNetwork(ResourceLocation id, FriendlyByteBuf buffer) {
        String name = buffer.m_130277_();
        String tooltip = buffer.m_130277_();
        ResourceLocation model = buffer.m_130281_();
        boolean generateBookItem = buffer.readBoolean();
        ResourceLocation customBookItem = buffer.readBoolean() ? buffer.m_130281_() : null;
        String creativeTab = buffer.m_130277_();
        ResourceLocation font = buffer.m_130281_();
        ResourceLocation bookOverviewTexture = buffer.m_130281_();
        ResourceLocation frameTexture = buffer.m_130281_();
        BookFrameOverlay topFrameOverlay = BookFrameOverlay.fromNetwork(buffer);
        BookFrameOverlay bottomFrameOverlay = BookFrameOverlay.fromNetwork(buffer);
        BookFrameOverlay leftFrameOverlay = BookFrameOverlay.fromNetwork(buffer);
        BookFrameOverlay rightFrameOverlay = BookFrameOverlay.fromNetwork(buffer);
        ResourceLocation bookContentTexture = buffer.m_130281_();
        ResourceLocation craftingTexture = buffer.m_130281_();
        ResourceLocation turnPageSound = buffer.m_130281_();
        int defaultTitleColor = buffer.readInt();
        float categoryButtonIconScale = buffer.readFloat();
        boolean autoAddReadConditions = buffer.readBoolean();
        short bookTextOffsetX = buffer.readShort();
        short bookTextOffsetY = buffer.readShort();
        short bookTextOffsetWidth = buffer.readShort();
        short categoryButtonXOffset = buffer.readShort();
        short categoryButtonYOffset = buffer.readShort();
        short searchButtonXOffset = buffer.readShort();
        short searchButtonYOffset = buffer.readShort();
        short readAllButtonYOffset = buffer.readShort();
        return new Book(id, name, tooltip, model, generateBookItem, customBookItem, creativeTab, font, bookOverviewTexture, frameTexture, topFrameOverlay, bottomFrameOverlay, leftFrameOverlay, rightFrameOverlay, bookContentTexture, craftingTexture, turnPageSound, defaultTitleColor, categoryButtonIconScale, autoAddReadConditions, bookTextOffsetX, bookTextOffsetY, bookTextOffsetWidth, categoryButtonXOffset, categoryButtonYOffset, searchButtonXOffset, searchButtonYOffset, readAllButtonYOffset);
    }

    public void build(Level level) {
        for (BookCategory category : this.categories.values()) {
            for (BookEntry entry : category.getEntries().values()) {
                this.addEntry(entry);
            }
        }
        for (BookCategory category : this.categories.values()) {
            BookErrorManager.get().getContextHelper().categoryId = category.getId();
            category.build(level, this);
            BookErrorManager.get().getContextHelper().categoryId = null;
        }
        for (BookCommand command : this.commands.values()) {
            command.build(this);
        }
    }

    public void prerenderMarkdown(BookTextRenderer textRenderer) {
        for (BookCategory category : this.categories.values()) {
            BookErrorManager.get().getContextHelper().categoryId = category.getId();
            category.prerenderMarkdown(textRenderer);
            BookErrorManager.get().getContextHelper().categoryId = null;
        }
    }

    public void toNetwork(FriendlyByteBuf buffer) {
        buffer.m_130070_(this.name);
        buffer.m_130070_(this.tooltip);
        buffer.m_130085_(this.model);
        buffer.writeBoolean(this.generateBookItem);
        buffer.writeBoolean(this.customBookItem != null);
        if (this.customBookItem != null) {
            buffer.m_130085_(this.customBookItem);
        }
        buffer.m_130070_(this.creativeTab);
        buffer.m_130085_(this.font);
        buffer.m_130085_(this.bookOverviewTexture);
        buffer.m_130085_(this.frameTexture);
        this.topFrameOverlay.toNetwork(buffer);
        this.bottomFrameOverlay.toNetwork(buffer);
        this.leftFrameOverlay.toNetwork(buffer);
        this.rightFrameOverlay.toNetwork(buffer);
        buffer.m_130085_(this.bookContentTexture);
        buffer.m_130085_(this.craftingTexture);
        buffer.m_130085_(this.turnPageSound);
        buffer.writeInt(this.defaultTitleColor);
        buffer.writeFloat(this.categoryButtonIconScale);
        buffer.writeBoolean(this.autoAddReadConditions);
        buffer.writeShort(this.bookTextOffsetX);
        buffer.writeShort(this.bookTextOffsetY);
        buffer.writeShort(this.bookTextOffsetWidth);
        buffer.writeShort(this.categoryButtonXOffset);
        buffer.writeShort(this.categoryButtonYOffset);
        buffer.writeShort(this.searchButtonXOffset);
        buffer.writeShort(this.searchButtonYOffset);
        buffer.writeShort(this.readAllButtonYOffset);
    }

    public ItemStack getBookItem() {
        return this.bookItem.get();
    }

    public boolean autoAddReadConditions() {
        return this.autoAddReadConditions;
    }

    public ResourceLocation getTurnPageSound() {
        return this.turnPageSound;
    }

    public int getDefaultTitleColor() {
        return this.defaultTitleColor;
    }

    public float getCategoryButtonIconScale() {
        return this.categoryButtonIconScale;
    }

    public ResourceLocation getId() {
        return this.id;
    }

    public void addCategory(BookCategory category) {
        this.categories.putIfAbsent(category.id, category);
    }

    public BookCategory getCategory(ResourceLocation id) {
        return (BookCategory)this.categories.get(id);
    }

    public Map<ResourceLocation, BookCategory> getCategories() {
        return this.categories;
    }

    public List<BookCategory> getCategoriesSorted() {
        return this.categories.values().stream().sorted(Comparator.comparingInt(BookCategory::getSortNumber)).toList();
    }

    public void addEntry(BookEntry entry) {
        this.entries.putIfAbsent(entry.getId(), entry);
    }

    public BookEntry getEntry(ResourceLocation id) {
        return (BookEntry)this.entries.get(id);
    }

    public Map<ResourceLocation, BookEntry> getEntries() {
        return this.entries;
    }

    public void addCommand(BookCommand command) {
        this.commands.putIfAbsent(command.id, command);
    }

    public ConcurrentMap<ResourceLocation, BookCommand> getCommands() {
        return this.commands;
    }

    public BookCommand getCommand(ResourceLocation id) {
        return (BookCommand)this.commands.get(id);
    }

    public String getName() {
        return this.name;
    }

    public String getTooltip() {
        return this.tooltip;
    }

    public String getCreativeTab() {
        return this.creativeTab;
    }

    public ResourceLocation getBookOverviewTexture() {
        return this.bookOverviewTexture;
    }

    public ResourceLocation getFont() {
        return this.font;
    }

    public ResourceLocation getFrameTexture() {
        return this.frameTexture;
    }

    public BookFrameOverlay getTopFrameOverlay() {
        return this.topFrameOverlay;
    }

    public BookFrameOverlay getBottomFrameOverlay() {
        return this.bottomFrameOverlay;
    }

    public BookFrameOverlay getLeftFrameOverlay() {
        return this.leftFrameOverlay;
    }

    public BookFrameOverlay getRightFrameOverlay() {
        return this.rightFrameOverlay;
    }

    @Nullable
    public ResourceLocation getCustomBookItem() {
        return this.customBookItem;
    }

    public ResourceLocation getCraftingTexture() {
        return this.craftingTexture;
    }

    public ResourceLocation getBookContentTexture() {
        return this.bookContentTexture;
    }

    public ResourceLocation getModel() {
        return this.model;
    }

    public boolean generateBookItem() {
        return this.generateBookItem;
    }

    public int getBookTextOffsetX() {
        return this.bookTextOffsetX;
    }

    public int getBookTextOffsetY() {
        return this.bookTextOffsetY;
    }

    public int getBookTextOffsetWidth() {
        return this.bookTextOffsetWidth;
    }

    public int getCategoryButtonXOffset() {
        return this.categoryButtonXOffset;
    }

    public int getCategoryButtonYOffset() {
        return this.categoryButtonYOffset;
    }

    public int getSearchButtonXOffset() {
        return this.searchButtonXOffset;
    }

    public int getSearchButtonYOffset() {
        return this.searchButtonYOffset;
    }

    public int getReadAllButtonYOffset() {
        return this.readAllButtonYOffset;
    }
}

