/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.api.lua;

import dan200.computercraft.api.lua.ILuaCallback;
import dan200.computercraft.api.lua.LuaException;
import java.util.Objects;
import javax.annotation.Nullable;

public final class MethodResult {
    private static final MethodResult empty = new MethodResult(null, null);
    @Nullable
    private final Object[] result;
    @Nullable
    private final ILuaCallback callback;
    private final int adjust;

    private MethodResult(@Nullable Object[] arguments, @Nullable ILuaCallback callback) {
        this.result = arguments;
        this.callback = callback;
        this.adjust = 0;
    }

    private MethodResult(@Nullable Object[] arguments, @Nullable ILuaCallback callback, int adjust) {
        this.result = arguments;
        this.callback = callback;
        this.adjust = adjust;
    }

    public static MethodResult of() {
        return empty;
    }

    public static MethodResult of(@Nullable Object value) {
        return new MethodResult(new Object[]{value}, null);
    }

    public static MethodResult of(Object ... values) {
        return values == null || values.length == 0 ? empty : new MethodResult(values, null);
    }

    public static MethodResult pullEvent(@Nullable String filter, ILuaCallback callback) {
        Objects.requireNonNull(callback, "callback cannot be null");
        return new MethodResult(new Object[]{filter}, results -> {
            if (results.length >= 1 && Objects.equals(results[0], "terminate")) {
                throw new LuaException("Terminated", 0);
            }
            return callback.resume(results);
        });
    }

    public static MethodResult pullEventRaw(@Nullable String filter, ILuaCallback callback) {
        Objects.requireNonNull(callback, "callback cannot be null");
        return new MethodResult(new Object[]{filter}, callback);
    }

    public static MethodResult yield(@Nullable Object[] arguments, ILuaCallback callback) {
        Objects.requireNonNull(callback, "callback cannot be null");
        return new MethodResult(arguments, callback);
    }

    @Nullable
    public Object[] getResult() {
        return this.result;
    }

    @Nullable
    public ILuaCallback getCallback() {
        return this.callback;
    }

    public int getErrorAdjust() {
        return this.adjust;
    }

    public MethodResult adjustError(int adjust) {
        if (adjust < 0) {
            throw new IllegalArgumentException("cannot adjust by a negative amount");
        }
        if (adjust == 0 || this.callback == null) {
            return this;
        }
        return new MethodResult(this.result, this.callback, this.adjust + adjust);
    }
}

