/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.data;

import com.google.gson.JsonObject;
import dan200.computercraft.shared.ModRegistry;
import dan200.computercraft.shared.computer.blocks.ComputerBlock;
import dan200.computercraft.shared.computer.core.ComputerState;
import dan200.computercraft.shared.peripheral.diskdrive.DiskDriveBlock;
import dan200.computercraft.shared.peripheral.diskdrive.DiskDriveState;
import dan200.computercraft.shared.peripheral.modem.wired.CableBlock;
import dan200.computercraft.shared.peripheral.modem.wired.CableModemVariant;
import dan200.computercraft.shared.peripheral.modem.wired.WiredModemFullBlock;
import dan200.computercraft.shared.peripheral.modem.wireless.WirelessModemBlock;
import dan200.computercraft.shared.peripheral.monitor.MonitorBlock;
import dan200.computercraft.shared.peripheral.monitor.MonitorEdgeState;
import dan200.computercraft.shared.peripheral.printer.PrinterBlock;
import dan200.computercraft.shared.turtle.blocks.TurtleBlock;
import dan200.computercraft.shared.util.DirectionUtil;
import java.util.ArrayList;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.minecraft.core.Direction;
import net.minecraft.data.models.BlockModelGenerators;
import net.minecraft.data.models.blockstates.Condition;
import net.minecraft.data.models.blockstates.MultiPartGenerator;
import net.minecraft.data.models.blockstates.MultiVariantGenerator;
import net.minecraft.data.models.blockstates.PropertyDispatch;
import net.minecraft.data.models.blockstates.Variant;
import net.minecraft.data.models.blockstates.VariantProperties;
import net.minecraft.data.models.model.ModelLocationUtils;
import net.minecraft.data.models.model.ModelTemplate;
import net.minecraft.data.models.model.ModelTemplates;
import net.minecraft.data.models.model.TextureMapping;
import net.minecraft.data.models.model.TextureSlot;
import net.minecraft.data.models.model.TexturedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;

class BlockModelProvider {
    private static final TextureSlot CURSOR = TextureSlot.m_125898_((String)"cursor");
    private static final TextureSlot LEFT = TextureSlot.m_125898_((String)"left");
    private static final TextureSlot RIGHT = TextureSlot.m_125898_((String)"right");
    private static final TextureSlot BACKPACK = TextureSlot.m_125898_((String)"backpack");
    private static final ModelTemplate COMPUTER_ON = new ModelTemplate(Optional.of(new ResourceLocation("computercraft", "block/computer_on")), Optional.empty(), new TextureSlot[]{TextureSlot.f_125873_, TextureSlot.f_125875_, TextureSlot.f_125872_, CURSOR});
    private static final ModelTemplate MONITOR_BASE = new ModelTemplate(Optional.of(new ResourceLocation("computercraft", "block/monitor_base")), Optional.empty(), new TextureSlot[]{TextureSlot.f_125873_, TextureSlot.f_125875_, TextureSlot.f_125872_, TextureSlot.f_125874_});
    private static final ModelTemplate MODEM = new ModelTemplate(Optional.of(new ResourceLocation("computercraft", "block/modem")), Optional.empty(), new TextureSlot[]{TextureSlot.f_125873_, TextureSlot.f_125874_});
    private static final ModelTemplate TURTLE = new ModelTemplate(Optional.of(new ResourceLocation("computercraft", "block/turtle_base")), Optional.empty(), new TextureSlot[]{TextureSlot.f_125873_, TextureSlot.f_125874_, TextureSlot.f_125872_, TextureSlot.f_125871_, LEFT, RIGHT, BACKPACK});
    private static final ModelTemplate TURTLE_UPGRADE_LEFT = new ModelTemplate(Optional.of(new ResourceLocation("computercraft", "block/turtle_upgrade_base_left")), Optional.of("_left"), new TextureSlot[]{TextureSlot.f_125868_});
    private static final ModelTemplate TURTLE_UPGRADE_RIGHT = new ModelTemplate(Optional.of(new ResourceLocation("computercraft", "block/turtle_upgrade_base_right")), Optional.of("_left"), new TextureSlot[]{TextureSlot.f_125868_});
    private static final BooleanProperty[] CABLE_DIRECTIONS = new BooleanProperty[]{CableBlock.DOWN, CableBlock.UP, CableBlock.NORTH, CableBlock.SOUTH, CableBlock.WEST, CableBlock.EAST};
    private static final boolean[] BOOLEANS = new boolean[]{false, true};

    BlockModelProvider() {
    }

    public static void addBlockModels(BlockModelGenerators generators) {
        BlockModelProvider.registerComputer(generators, (ComputerBlock)ModRegistry.Blocks.COMPUTER_NORMAL.get());
        BlockModelProvider.registerComputer(generators, (ComputerBlock)ModRegistry.Blocks.COMPUTER_ADVANCED.get());
        BlockModelProvider.registerComputer(generators, (ComputerBlock)ModRegistry.Blocks.COMPUTER_COMMAND.get());
        BlockModelProvider.registerTurtle(generators, (TurtleBlock)ModRegistry.Blocks.TURTLE_NORMAL.get());
        BlockModelProvider.registerTurtle(generators, (TurtleBlock)ModRegistry.Blocks.TURTLE_ADVANCED.get());
        BlockModelProvider.registerWirelessModem(generators, (WirelessModemBlock)((Object)ModRegistry.Blocks.WIRELESS_MODEM_NORMAL.get()));
        BlockModelProvider.registerWirelessModem(generators, (WirelessModemBlock)((Object)ModRegistry.Blocks.WIRELESS_MODEM_ADVANCED.get()));
        BlockModelProvider.registerWiredModems(generators);
        BlockModelProvider.registerMonitor(generators, (MonitorBlock)((Object)ModRegistry.Blocks.MONITOR_NORMAL.get()));
        BlockModelProvider.registerMonitor(generators, (MonitorBlock)((Object)ModRegistry.Blocks.MONITOR_ADVANCED.get()));
        generators.m_124744_((Block)ModRegistry.Blocks.SPEAKER.get(), TexturedModel.f_125911_);
        BlockModelProvider.registerDiskDrive(generators);
        BlockModelProvider.registerPrinter(generators);
        BlockModelProvider.registerCable(generators);
        BlockModelProvider.registerTurtleUpgrade(generators, "block/turtle_crafting_table", "block/turtle_crafty_face");
        BlockModelProvider.registerTurtleUpgrade(generators, "block/turtle_speaker", "block/turtle_speaker_face");
        BlockModelProvider.registerTurtleModem(generators, "block/turtle_modem_normal", "block/wireless_modem_normal_face");
        BlockModelProvider.registerTurtleModem(generators, "block/turtle_modem_advanced", "block/wireless_modem_advanced_face");
        generators.f_124477_.accept(MultiVariantGenerator.m_125256_((Block)((Block)ModRegistry.Blocks.LECTERN.get()), (Variant)Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)ModelLocationUtils.m_125576_((Block)Blocks.f_50624_))).m_125271_(BlockModelProvider.createHorizontalFacingDispatch()));
    }

    private static void registerDiskDrive(BlockModelGenerators generators) {
        DiskDriveBlock diskDrive = (DiskDriveBlock)((Object)ModRegistry.Blocks.DISK_DRIVE.get());
        generators.f_124477_.accept(MultiVariantGenerator.m_125254_((Block)diskDrive).m_125271_(BlockModelProvider.createHorizontalFacingDispatch()).m_125271_(BlockModelProvider.createModelDispatch(DiskDriveBlock.STATE, value -> {
            String textureSuffix = switch (value) {
                default -> throw new IncompatibleClassChangeError();
                case DiskDriveState.EMPTY -> "_front";
                case DiskDriveState.INVALID -> "_front_rejected";
                case DiskDriveState.FULL -> "_front_accepted";
            };
            return ModelTemplates.f_125698_.m_125596_((Block)diskDrive, "_" + value.m_7912_(), TextureMapping.m_125846_((Block)diskDrive).m_125758_(TextureSlot.f_125873_, TextureMapping.m_125753_((Block)diskDrive, (String)textureSuffix)), generators.f_124478_);
        })));
        generators.m_124797_((Block)diskDrive, ModelLocationUtils.m_125578_((Block)diskDrive, (String)"_empty"));
    }

    private static void registerPrinter(BlockModelGenerators generators) {
        PrinterBlock printer = (PrinterBlock)((Object)ModRegistry.Blocks.PRINTER.get());
        generators.f_124477_.accept(MultiVariantGenerator.m_125254_((Block)printer).m_125271_(BlockModelProvider.createHorizontalFacingDispatch()).m_125271_(BlockModelProvider.createModelDispatch(PrinterBlock.TOP, PrinterBlock.BOTTOM, (top, bottom) -> {
            String texture;
            String model;
            if (top.booleanValue() && bottom.booleanValue()) {
                model = "_both_full";
                texture = "_both_trays";
            } else if (top.booleanValue()) {
                model = "_top_full";
                texture = "_top_tray";
            } else if (bottom.booleanValue()) {
                model = "_bottom_full";
                texture = "_bottom_tray";
            } else {
                model = "_empty";
                texture = "_empty";
            }
            return ModelTemplates.f_125698_.m_125596_((Block)printer, model, TextureMapping.m_125846_((Block)printer).m_125758_(TextureSlot.f_125873_, TextureMapping.m_125753_((Block)printer, (String)("_front" + texture))), generators.f_124478_);
        })));
        generators.m_124797_((Block)printer, ModelLocationUtils.m_125578_((Block)printer, (String)"_empty"));
    }

    private static void registerComputer(BlockModelGenerators generators, ComputerBlock<?> block) {
        generators.f_124477_.accept(MultiVariantGenerator.m_125254_(block).m_125271_(BlockModelProvider.createHorizontalFacingDispatch()).m_125271_(BlockModelProvider.createModelDispatch(ComputerBlock.STATE, state -> switch (state) {
            default -> throw new IncompatibleClassChangeError();
            case ComputerState.OFF -> ModelTemplates.f_125698_.m_125596_((Block)block, "_" + state.m_7912_(), TextureMapping.m_125846_((Block)block), generators.f_124478_);
            case ComputerState.ON, ComputerState.BLINKING -> COMPUTER_ON.m_125596_((Block)block, "_" + state.m_7912_(), TextureMapping.m_125846_((Block)block).m_125758_(CURSOR, new ResourceLocation("computercraft", "block/computer" + state.getTexture())), generators.f_124478_);
        })));
        generators.m_124797_(block, ModelLocationUtils.m_125578_(block, (String)"_blinking"));
    }

    private static void registerTurtle(BlockModelGenerators generators, TurtleBlock block) {
        ResourceLocation model = TURTLE.m_125592_((Block)block, new TextureMapping().m_125758_(TextureSlot.f_125873_, TextureMapping.m_125753_((Block)block, (String)"_front")).m_125758_(TextureSlot.f_125874_, TextureMapping.m_125753_((Block)block, (String)"_back")).m_125758_(TextureSlot.f_125872_, TextureMapping.m_125753_((Block)block, (String)"_top")).m_125758_(TextureSlot.f_125871_, TextureMapping.m_125753_((Block)block, (String)"_bottom")).m_125758_(LEFT, TextureMapping.m_125753_((Block)block, (String)"_left")).m_125758_(RIGHT, TextureMapping.m_125753_((Block)block, (String)"_right")).m_125758_(BACKPACK, TextureMapping.m_125753_((Block)block, (String)"_backpack")), generators.f_124478_);
        generators.f_124477_.accept(MultiVariantGenerator.m_125256_((Block)block, (Variant)Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)model)).m_125271_(BlockModelProvider.createHorizontalFacingDispatch()));
        generators.f_124478_.accept(ModelLocationUtils.m_125571_((Item)block.m_5456_()), () -> {
            JsonObject out = new JsonObject();
            out.addProperty("loader", "computercraft:turtle");
            out.addProperty("model", model.toString());
            return out;
        });
    }

    private static void registerWirelessModem(BlockModelGenerators generators, WirelessModemBlock block) {
        generators.f_124477_.accept(MultiVariantGenerator.m_125254_((Block)block).m_125271_(BlockModelProvider.createFacingDispatch()).m_125271_(BlockModelProvider.createModelDispatch(WirelessModemBlock.ON, on -> BlockModelProvider.modemModel(generators, ModelLocationUtils.m_125578_((Block)block, (String)(on != false ? "_on" : "_off")), TextureMapping.m_125753_((Block)block, (String)("_face" + (on != false ? "_on" : "")))))));
        generators.m_124797_((Block)block, ModelLocationUtils.m_125578_((Block)block, (String)"_off"));
    }

    private static void registerWiredModems(BlockModelGenerators generators) {
        WiredModemFullBlock fullBlock = (WiredModemFullBlock)((Object)ModRegistry.Blocks.WIRED_MODEM_FULL.get());
        generators.f_124477_.accept(MultiVariantGenerator.m_125254_((Block)fullBlock).m_125271_(BlockModelProvider.createModelDispatch(WiredModemFullBlock.MODEM_ON, WiredModemFullBlock.PERIPHERAL_ON, (on, peripheral) -> {
            String suffix = (on != false ? "_on" : "_off") + (peripheral != false ? "_peripheral" : "");
            ResourceLocation faceTexture = new ResourceLocation("computercraft", "block/wired_modem_face" + (peripheral != false ? "_peripheral" : "") + (on != false ? "_on" : ""));
            BlockModelProvider.modemModel(generators, new ResourceLocation("computercraft", "block/wired_modem" + suffix), faceTexture);
            return ModelTemplates.f_125692_.m_125612_(ModelLocationUtils.m_125578_((Block)fullBlock, (String)suffix), new TextureMapping().m_125758_(TextureSlot.f_125867_, faceTexture), generators.f_124478_);
        })));
        generators.m_124797_((Block)fullBlock, ModelLocationUtils.m_125578_((Block)fullBlock, (String)"_off"));
        generators.m_124519_((Item)ModRegistry.Items.WIRED_MODEM.get(), new ResourceLocation("computercraft", "block/wired_modem_off"));
    }

    private static ResourceLocation modemModel(BlockModelGenerators generators, ResourceLocation name, ResourceLocation texture) {
        return MODEM.m_125612_(name, new TextureMapping().m_125758_(TextureSlot.f_125873_, texture).m_125758_(TextureSlot.f_125874_, new ResourceLocation("computercraft", "block/modem_back")), generators.f_124478_);
    }

    private static void registerMonitor(BlockModelGenerators generators, MonitorBlock block) {
        BlockModelProvider.monitorModel(generators, block, "", 16, 4, 0, 32);
        BlockModelProvider.monitorModel(generators, block, "_d", 20, 7, 0, 36);
        BlockModelProvider.monitorModel(generators, block, "_l", 19, 4, 1, 33);
        BlockModelProvider.monitorModel(generators, block, "_ld", 31, 7, 1, 45);
        BlockModelProvider.monitorModel(generators, block, "_lr", 18, 4, 2, 34);
        BlockModelProvider.monitorModel(generators, block, "_lrd", 30, 7, 2, 46);
        BlockModelProvider.monitorModel(generators, block, "_lru", 24, 5, 2, 40);
        BlockModelProvider.monitorModel(generators, block, "_lrud", 27, 6, 2, 43);
        BlockModelProvider.monitorModel(generators, block, "_lu", 25, 5, 1, 39);
        BlockModelProvider.monitorModel(generators, block, "_lud", 28, 6, 1, 42);
        BlockModelProvider.monitorModel(generators, block, "_r", 17, 4, 3, 35);
        BlockModelProvider.monitorModel(generators, block, "_rd", 29, 7, 3, 47);
        BlockModelProvider.monitorModel(generators, block, "_ru", 23, 5, 3, 41);
        BlockModelProvider.monitorModel(generators, block, "_rud", 26, 6, 3, 44);
        BlockModelProvider.monitorModel(generators, block, "_u", 22, 5, 0, 38);
        BlockModelProvider.monitorModel(generators, block, "_ud", 21, 6, 0, 37);
        generators.f_124477_.accept(MultiVariantGenerator.m_125254_((Block)block).m_125271_(BlockModelProvider.createHorizontalFacingDispatch()).m_125271_(BlockModelProvider.createVerticalFacingDispatch((Property<Direction>)MonitorBlock.ORIENTATION)).m_125271_(BlockModelProvider.createModelDispatch(MonitorBlock.STATE, edge -> ModelLocationUtils.m_125578_((Block)block, (String)(edge == MonitorEdgeState.NONE ? "" : "_" + edge.m_7912_())))));
        generators.m_124797_((Block)block, BlockModelProvider.monitorModel(generators, block, "_item", 15, 4, 0, 32));
    }

    private static ResourceLocation monitorModel(BlockModelGenerators generators, MonitorBlock block, String corners, int front, int side, int top, int back) {
        return MONITOR_BASE.m_125612_(ModelLocationUtils.m_125578_((Block)block, (String)corners), new TextureMapping().m_125758_(TextureSlot.f_125873_, TextureMapping.m_125753_((Block)block, (String)("_" + front))).m_125758_(TextureSlot.f_125875_, TextureMapping.m_125753_((Block)block, (String)("_" + side))).m_125758_(TextureSlot.f_125872_, TextureMapping.m_125753_((Block)block, (String)("_" + top))).m_125758_(TextureSlot.f_125874_, TextureMapping.m_125753_((Block)block, (String)("_" + back))), generators.f_124478_);
    }

    private static void registerCable(BlockModelGenerators generators) {
        MultiPartGenerator generator = MultiPartGenerator.m_125204_((Block)((Block)ModRegistry.Blocks.CABLE.get()));
        ResourceLocation coreFacing = new ResourceLocation("computercraft", "block/cable_core_facing");
        generator.m_125209_(Condition.m_125137_((Condition[])new Condition[]{BlockModelProvider.cableNoNeighbour(Direction.NORTH, Direction.SOUTH, Direction.EAST, Direction.WEST).m_125176_((Property)CableBlock.UP, (Comparable)Boolean.valueOf(true)), BlockModelProvider.cableNoNeighbour(Direction.NORTH, Direction.SOUTH, Direction.EAST, Direction.WEST).m_125176_((Property)CableBlock.DOWN, (Comparable)Boolean.valueOf(true))}), Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)coreFacing).m_125511_(VariantProperties.f_125518_, (Object)VariantProperties.Rotation.R90));
        generator.m_125209_(Condition.m_125137_((Condition[])new Condition[]{BlockModelProvider.cableNoNeighbour(Direction.UP, Direction.DOWN, Direction.NORTH, Direction.SOUTH, Direction.EAST, Direction.WEST), BlockModelProvider.cableNoNeighbour(Direction.UP, Direction.DOWN, Direction.EAST, Direction.WEST).m_125176_((Property)CableBlock.NORTH, (Comparable)Boolean.valueOf(true)), BlockModelProvider.cableNoNeighbour(Direction.UP, Direction.DOWN, Direction.EAST, Direction.WEST).m_125176_((Property)CableBlock.SOUTH, (Comparable)Boolean.valueOf(true))}), Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)coreFacing).m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.R0));
        generator.m_125209_(Condition.m_125137_((Condition[])new Condition[]{BlockModelProvider.cableNoNeighbour(Direction.NORTH, Direction.SOUTH, Direction.UP, Direction.DOWN).m_125176_((Property)CableBlock.EAST, (Comparable)Boolean.valueOf(true)), BlockModelProvider.cableNoNeighbour(Direction.NORTH, Direction.SOUTH, Direction.UP, Direction.DOWN).m_125176_((Property)CableBlock.WEST, (Comparable)Boolean.valueOf(true))}), Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)coreFacing).m_125511_(VariantProperties.f_125519_, (Object)VariantProperties.Rotation.R90));
        ResourceLocation core = new ResourceLocation("computercraft", "block/cable_core_any");
        ArrayList<Condition.TerminalCondition> rightAngles = new ArrayList<Condition.TerminalCondition>();
        for (int i = 0; i < DirectionUtil.FACINGS.length; ++i) {
            for (int j = i; j < DirectionUtil.FACINGS.length; ++j) {
                if (DirectionUtil.FACINGS[i].m_122434_() == DirectionUtil.FACINGS[j].m_122434_()) continue;
                rightAngles.add(new Condition.TerminalCondition().m_125176_((Property)CableBlock.CABLE, (Comparable)Boolean.valueOf(true)).m_125176_((Property)CABLE_DIRECTIONS[i], (Comparable)Boolean.valueOf(true)).m_125176_((Property)CABLE_DIRECTIONS[j], (Comparable)Boolean.valueOf(true)));
            }
        }
        generator.m_125209_(Condition.m_125137_((Condition[])rightAngles.toArray(new Condition[0])), Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)core));
        ResourceLocation arm = new ResourceLocation("computercraft", "block/cable_arm");
        for (Direction direction : DirectionUtil.FACINGS) {
            generator.m_125209_((Condition)new Condition.TerminalCondition().m_125176_((Property)CABLE_DIRECTIONS[direction.ordinal()], (Comparable)Boolean.valueOf(true)), Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)arm).m_125511_(VariantProperties.f_125518_, (Object)BlockModelProvider.toXAngle(direction.m_122424_())).m_125511_(VariantProperties.f_125519_, (Object)BlockModelProvider.toYAngle(direction.m_122424_())));
        }
        for (Direction direction : DirectionUtil.FACINGS) {
            for (boolean on : BOOLEANS) {
                for (boolean peripheral : BOOLEANS) {
                    String suffix = (on ? "_on" : "_off") + (peripheral ? "_peripheral" : "");
                    generator.m_125209_((Condition)new Condition.TerminalCondition().m_125176_(CableBlock.MODEM, (Comparable)((Object)CableModemVariant.from(direction, on, peripheral))), Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)new ResourceLocation("computercraft", "block/wired_modem" + suffix)).m_125511_(VariantProperties.f_125518_, (Object)BlockModelProvider.toXAngle(direction)).m_125511_(VariantProperties.f_125519_, (Object)BlockModelProvider.toYAngle(direction)));
                }
            }
        }
        generators.f_124477_.accept(generator);
    }

    private static Condition.TerminalCondition cableNoNeighbour(Direction ... directions) {
        Condition.TerminalCondition condition = new Condition.TerminalCondition().m_125176_((Property)CableBlock.CABLE, (Comparable)Boolean.valueOf(true));
        for (Direction direction : directions) {
            condition.m_125176_((Property)CABLE_DIRECTIONS[direction.ordinal()], (Comparable)Boolean.valueOf(false));
        }
        return condition;
    }

    private static void registerTurtleUpgrade(BlockModelGenerators generators, String name, String texture) {
        TURTLE_UPGRADE_LEFT.m_125612_(new ResourceLocation("computercraft", name + "_left"), TextureMapping.m_125761_((ResourceLocation)new ResourceLocation("computercraft", texture)), generators.f_124478_);
        TURTLE_UPGRADE_RIGHT.m_125612_(new ResourceLocation("computercraft", name + "_right"), TextureMapping.m_125761_((ResourceLocation)new ResourceLocation("computercraft", texture)), generators.f_124478_);
    }

    private static void registerTurtleModem(BlockModelGenerators generators, String name, String texture) {
        BlockModelProvider.registerTurtleUpgrade(generators, name + "_off", texture);
        BlockModelProvider.registerTurtleUpgrade(generators, name + "_on", texture + "_on");
    }

    private static VariantProperties.Rotation toXAngle(Direction direction) {
        return switch (direction) {
            default -> VariantProperties.Rotation.R0;
            case Direction.UP -> VariantProperties.Rotation.R270;
            case Direction.DOWN -> VariantProperties.Rotation.R90;
        };
    }

    private static VariantProperties.Rotation toYAngle(Direction direction) {
        return switch (direction) {
            default -> VariantProperties.Rotation.R0;
            case Direction.NORTH -> VariantProperties.Rotation.R0;
            case Direction.SOUTH -> VariantProperties.Rotation.R180;
            case Direction.EAST -> VariantProperties.Rotation.R90;
            case Direction.WEST -> VariantProperties.Rotation.R270;
        };
    }

    private static PropertyDispatch createHorizontalFacingDispatch() {
        PropertyDispatch.C1 dispatch = PropertyDispatch.m_125294_((Property)BlockStateProperties.f_61374_);
        for (Direction direction : BlockStateProperties.f_61374_.m_6908_()) {
            dispatch.m_125329_((Comparable)direction, Variant.m_125501_().m_125511_(VariantProperties.f_125519_, (Object)BlockModelProvider.toYAngle(direction)));
        }
        return dispatch;
    }

    private static PropertyDispatch createVerticalFacingDispatch(Property<Direction> property) {
        PropertyDispatch.C1 dispatch = PropertyDispatch.m_125294_(property);
        for (Direction direction : property.m_6908_()) {
            dispatch.m_125329_((Comparable)direction, Variant.m_125501_().m_125511_(VariantProperties.f_125518_, (Object)BlockModelProvider.toXAngle(direction)));
        }
        return dispatch;
    }

    private static PropertyDispatch createFacingDispatch() {
        PropertyDispatch.C1 dispatch = PropertyDispatch.m_125294_((Property)BlockStateProperties.f_61372_);
        for (Direction direction : BlockStateProperties.f_61372_.m_6908_()) {
            dispatch.m_125329_((Comparable)direction, Variant.m_125501_().m_125511_(VariantProperties.f_125519_, (Object)BlockModelProvider.toYAngle(direction)).m_125511_(VariantProperties.f_125518_, (Object)BlockModelProvider.toXAngle(direction)));
        }
        return dispatch;
    }

    private static <T extends Comparable<T>> PropertyDispatch createModelDispatch(Property<T> property, Function<T, ResourceLocation> makeModel) {
        PropertyDispatch.C1 variant = PropertyDispatch.m_125294_(property);
        for (Comparable value : property.m_6908_()) {
            variant.m_125329_(value, Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)makeModel.apply(value)));
        }
        return variant;
    }

    private static <T extends Comparable<T>, U extends Comparable<U>> PropertyDispatch createModelDispatch(Property<T> propertyT, Property<U> propertyU, BiFunction<T, U, ResourceLocation> makeModel) {
        PropertyDispatch.C2 variant = PropertyDispatch.m_125296_(propertyT, propertyU);
        for (Comparable valueT : propertyT.m_6908_()) {
            for (Comparable valueU : propertyU.m_6908_()) {
                variant.m_125350_(valueT, valueU, Variant.m_125501_().m_125511_(VariantProperties.f_125520_, (Object)makeModel.apply(valueT, valueU)));
            }
        }
        return variant;
    }
}

