/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.impl;

import com.google.auto.service.AutoService;
import dan200.computercraft.api.detail.DetailRegistry;
import dan200.computercraft.api.network.wired.WiredElement;
import dan200.computercraft.api.peripheral.IPeripheralProvider;
import dan200.computercraft.impl.AbstractComputerCraftAPI;
import dan200.computercraft.impl.ComputerCraftAPIForgeService;
import dan200.computercraft.impl.ComputerCraftAPIService;
import dan200.computercraft.impl.Peripherals;
import dan200.computercraft.impl.detail.DetailRegistryImpl;
import dan200.computercraft.shared.Capabilities;
import dan200.computercraft.shared.details.FluidData;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.ModList;

@AutoService(value={ComputerCraftAPIService.class})
public final class ComputerCraftAPIImpl
extends AbstractComputerCraftAPI
implements ComputerCraftAPIForgeService {
    private final DetailRegistry<FluidStack> fluidStackDetails = new DetailRegistryImpl<FluidStack>(FluidData::fillBasic);
    @Nullable
    private String version;

    @Override
    public String getInstalledVersion() {
        if (this.version != null) {
            return this.version;
        }
        this.version = ModList.get().getModContainerById("computercraft").map(x -> x.getModInfo().getVersion().toString()).orElse("unknown");
        return this.version;
    }

    @Override
    public void registerPeripheralProvider(IPeripheralProvider provider) {
        Peripherals.register(provider);
    }

    @Override
    public void registerGenericCapability(Capability<?> capability) {
        Peripherals.registerGenericCapability(capability);
    }

    @Override
    public LazyOptional<WiredElement> getWiredElementAt(BlockGetter world, BlockPos pos, Direction side) {
        BlockEntity tile = world.m_7702_(pos);
        return tile == null ? LazyOptional.empty() : tile.getCapability(Capabilities.CAPABILITY_WIRED_ELEMENT, side);
    }

    @Override
    public DetailRegistry<FluidStack> getFluidStackDetailRegistry() {
        return this.fluidStackDetails;
    }
}

