/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.impl;

import dan200.computercraft.api.media.IMedia;
import dan200.computercraft.api.media.MediaProvider;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.world.item.ItemStack;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MediaProviders {
    private static final Logger LOG = LoggerFactory.getLogger(MediaProviders.class);
    private static final Set<MediaProvider> providers = new LinkedHashSet<MediaProvider>();

    private MediaProviders() {
    }

    public static synchronized void register(MediaProvider provider) {
        Objects.requireNonNull(provider, "provider cannot be null");
        providers.add(provider);
    }

    @Nullable
    public static IMedia get(ItemStack stack) {
        if (stack.m_41619_()) {
            return null;
        }
        for (MediaProvider mediaProvider : providers) {
            try {
                IMedia media = mediaProvider.getMedia(stack);
                if (media == null) continue;
                return media;
            }
            catch (Exception e) {
                LOG.error("Media provider " + mediaProvider + " errored.", (Throwable)e);
            }
        }
        return null;
    }
}

