/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.computer.apis;

import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import com.mojang.brigadier.tree.RootCommandNode;
import dan200.computercraft.api.component.AdminComputer;
import dan200.computercraft.api.detail.BlockReference;
import dan200.computercraft.api.detail.VanillaDetailRegistries;
import dan200.computercraft.api.lua.IArguments;
import dan200.computercraft.api.lua.IComputerSystem;
import dan200.computercraft.api.lua.ILuaAPI;
import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.core.Logging;
import dan200.computercraft.shared.util.NBTUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.commands.CommandSource;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommandAPI
implements ILuaAPI {
    private static final Logger LOG = LoggerFactory.getLogger(CommandAPI.class);
    private final IComputerSystem computer;
    private final AdminComputer admin;
    private final OutputReceiver receiver = new OutputReceiver();

    public CommandAPI(IComputerSystem computer, AdminComputer admin) {
        this.computer = computer;
        this.admin = admin;
    }

    @Override
    public String[] getNames() {
        return new String[]{"commands"};
    }

    private static Object createOutput(String output) {
        return new Object[]{output};
    }

    private Object[] doCommand(String command) {
        MinecraftServer server = this.computer.getLevel().m_7654_();
        if (!server.m_6993_()) {
            return new Object[]{false, CommandAPI.createOutput("Command blocks disabled by server")};
        }
        Commands commandManager = server.m_129892_();
        try {
            this.receiver.clearOutput();
            int result = commandManager.m_230957_(this.getSource(), command);
            return new Object[]{result > 0, this.receiver.copyOutput(), result};
        }
        catch (Throwable t) {
            LOG.error(Logging.JAVA_ERROR, "Error running command.", t);
            return new Object[]{false, CommandAPI.createOutput("Java Exception Thrown: " + t)};
        }
    }

    private static Map<?, ?> getBlockInfo(Level world, BlockPos pos) {
        BlockReference block = new BlockReference(world, pos);
        Map<String, Object> table = VanillaDetailRegistries.BLOCK_IN_WORLD.getDetails(block);
        BlockEntity tile = block.blockEntity();
        if (tile != null) {
            table.put("nbt", NBTUtil.toLua((Tag)tile.m_187480_()));
        }
        return table;
    }

    @LuaFunction(mainThread=true)
    public final Object[] exec(String command) {
        return this.doCommand(command);
    }

    @LuaFunction
    public final long execAsync(ILuaContext context, String command) throws LuaException {
        return context.issueMainThreadTask(() -> this.doCommand(command));
    }

    @LuaFunction(mainThread=true)
    public final List<String> list(IArguments args) throws LuaException {
        MinecraftServer server = this.computer.getLevel().m_7654_();
        RootCommandNode node = server.m_129892_().m_82094_().getRoot();
        for (int j = 0; j < args.count(); ++j) {
            String name = args.getString(j);
            if ((node = node.getChild(name)) instanceof LiteralCommandNode) continue;
            return List.of();
        }
        ArrayList<String> result = new ArrayList<String>();
        for (CommandNode child : node.getChildren()) {
            if (!(child instanceof LiteralCommandNode)) continue;
            result.add(child.getName());
        }
        return Collections.unmodifiableList(result);
    }

    @LuaFunction
    public final Object[] getBlockPosition() {
        BlockPos pos = this.computer.getPosition();
        return new Object[]{pos.m_123341_(), pos.m_123342_(), pos.m_123343_()};
    }

    @LuaFunction(mainThread=true)
    public final List<Map<?, ?>> getBlockInfos(int minX, int minY, int minZ, int maxX, int maxY, int maxZ, Optional<String> dimension) throws LuaException {
        Level world = this.getLevel(dimension);
        BlockPos min = new BlockPos(Math.min(minX, maxX), Math.min(minY, maxY), Math.min(minZ, maxZ));
        BlockPos max = new BlockPos(Math.max(minX, maxX), Math.max(minY, maxY), Math.max(minZ, maxZ));
        if (!world.m_46739_(min) || !world.m_46739_(max)) {
            throw new LuaException("Co-ordinates out of range");
        }
        int blocks = (max.m_123341_() - min.m_123341_() + 1) * (max.m_123342_() - min.m_123342_() + 1) * (max.m_123343_() - min.m_123343_() + 1);
        if (blocks > 4096) {
            throw new LuaException("Too many blocks");
        }
        ArrayList results = new ArrayList(blocks);
        for (int y = min.m_123342_(); y <= max.m_123342_(); ++y) {
            for (int z = min.m_123343_(); z <= max.m_123343_(); ++z) {
                for (int x = min.m_123341_(); x <= max.m_123341_(); ++x) {
                    BlockPos pos = new BlockPos(x, y, z);
                    results.add(CommandAPI.getBlockInfo(world, pos));
                }
            }
        }
        return results;
    }

    @LuaFunction(mainThread=true)
    public final Map<?, ?> getBlockInfo(int x, int y, int z, Optional<String> dimension) throws LuaException {
        BlockPos position;
        Level level = this.getLevel(dimension);
        if (!level.m_46739_(position = new BlockPos(x, y, z))) {
            throw new LuaException("Co-ordinates out of range");
        }
        return CommandAPI.getBlockInfo(level, position);
    }

    private Level getLevel(Optional<String> id) throws LuaException {
        ServerLevel currentLevel = this.computer.getLevel();
        if (id.isEmpty()) {
            return currentLevel;
        }
        ResourceLocation dimensionId = ResourceLocation.m_135820_((String)id.get());
        if (dimensionId == null) {
            throw new LuaException("Invalid dimension name");
        }
        ServerLevel level = currentLevel.m_7654_().m_129880_(ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)dimensionId));
        if (level == null) {
            throw new LuaException("Unknown dimension");
        }
        return level;
    }

    private CommandSourceStack getSource() {
        String name = "@";
        String label = this.computer.getLabel();
        if (label != null) {
            name = label;
        }
        return new CommandSourceStack((CommandSource)this.receiver, Vec3.m_82512_((Vec3i)this.computer.getPosition()), Vec2.f_82462_, this.computer.getLevel(), this.admin.permissionLevel(), name, (Component)Component.m_237113_((String)name), this.computer.getLevel().m_7654_(), null);
    }

    private final class OutputReceiver
    implements CommandSource {
        private final List<String> output = new ArrayList<String>();

        private OutputReceiver() {
        }

        void clearOutput() {
            this.output.clear();
        }

        List<String> copyOutput() {
            return List.copyOf(this.output);
        }

        public void m_213846_(Component textComponent) {
            this.output.add(textComponent.getString());
        }

        public boolean m_6999_() {
            return true;
        }

        public boolean m_7028_() {
            return true;
        }

        public boolean m_6102_() {
            return CommandAPI.this.computer.getLevel().m_46469_().m_46207_(GameRules.f_46138_);
        }
    }
}

