/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.network.client;

import dan200.computercraft.api.pocket.IPocketUpgrade;
import dan200.computercraft.api.pocket.PocketUpgradeSerialiser;
import dan200.computercraft.api.turtle.ITurtleUpgrade;
import dan200.computercraft.api.turtle.TurtleUpgradeSerialiser;
import dan200.computercraft.api.upgrades.UpgradeBase;
import dan200.computercraft.api.upgrades.UpgradeSerialiser;
import dan200.computercraft.impl.PocketUpgrades;
import dan200.computercraft.impl.TurtleUpgrades;
import dan200.computercraft.impl.UpgradeManager;
import dan200.computercraft.shared.network.MessageType;
import dan200.computercraft.shared.network.NetworkMessage;
import dan200.computercraft.shared.network.NetworkMessages;
import dan200.computercraft.shared.network.client.ClientNetworkContext;
import dan200.computercraft.shared.platform.PlatformHelper;
import dan200.computercraft.shared.platform.RegistryWrappers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.core.Registry;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;

public final class UpgradesLoadedMessage
implements NetworkMessage<ClientNetworkContext> {
    private final Map<String, UpgradeManager.UpgradeWrapper<TurtleUpgradeSerialiser<?>, ITurtleUpgrade>> turtleUpgrades;
    private final Map<String, UpgradeManager.UpgradeWrapper<PocketUpgradeSerialiser<?>, IPocketUpgrade>> pocketUpgrades;

    public UpgradesLoadedMessage() {
        this.turtleUpgrades = TurtleUpgrades.instance().getUpgradeWrappers();
        this.pocketUpgrades = PocketUpgrades.instance().getUpgradeWrappers();
    }

    public UpgradesLoadedMessage(FriendlyByteBuf buf) {
        this.turtleUpgrades = this.fromBytes(buf, TurtleUpgradeSerialiser.registryId());
        this.pocketUpgrades = this.fromBytes(buf, PocketUpgradeSerialiser.registryId());
    }

    private <R extends UpgradeSerialiser<? extends T>, T extends UpgradeBase> Map<String, UpgradeManager.UpgradeWrapper<R, T>> fromBytes(FriendlyByteBuf buf, ResourceKey<Registry<R>> registryKey) {
        RegistryWrappers.RegistryWrapper<R> registry = PlatformHelper.get().wrap(registryKey);
        int size = buf.m_130242_();
        HashMap<String, UpgradeManager.UpgradeWrapper<R, T>> upgrades = new HashMap<String, UpgradeManager.UpgradeWrapper<R, T>>(size);
        for (int i = 0; i < size; ++i) {
            String id = buf.m_130277_();
            ResourceLocation serialiserId = buf.m_130281_();
            UpgradeSerialiser serialiser = (UpgradeSerialiser)registry.tryGet(serialiserId);
            if (serialiser == null) {
                throw new IllegalStateException("Unknown serialiser " + serialiserId);
            }
            Object upgrade = serialiser.fromNetwork(new ResourceLocation(id), buf);
            String modId = buf.m_130277_();
            upgrades.put(id, new UpgradeManager.UpgradeWrapper(id, upgrade, serialiser, modId));
        }
        return upgrades;
    }

    @Override
    public void write(FriendlyByteBuf buf) {
        this.toBytes(buf, TurtleUpgradeSerialiser.registryId(), this.turtleUpgrades);
        this.toBytes(buf, PocketUpgradeSerialiser.registryId(), this.pocketUpgrades);
    }

    private <R extends UpgradeSerialiser<? extends T>, T extends UpgradeBase> void toBytes(FriendlyByteBuf buf, ResourceKey<Registry<R>> registryKey, Map<String, UpgradeManager.UpgradeWrapper<R, T>> upgrades) {
        RegistryWrappers.RegistryWrapper<R> registry = PlatformHelper.get().wrap(registryKey);
        buf.m_130130_(upgrades.size());
        for (Map.Entry<String, UpgradeManager.UpgradeWrapper<R, T>> entry : upgrades.entrySet()) {
            R serialiser;
            buf.m_130070_(entry.getKey());
            R unwrappedSerialiser = serialiser = entry.getValue().serialiser();
            buf.m_130085_(Objects.requireNonNull(registry.getKey(serialiser), "Serialiser is not registered!"));
            unwrappedSerialiser.toNetwork(buf, entry.getValue().upgrade());
            buf.m_130070_(entry.getValue().modId());
        }
    }

    @Override
    public void handle(ClientNetworkContext context) {
        TurtleUpgrades.instance().loadFromNetwork(this.turtleUpgrades);
        PocketUpgrades.instance().loadFromNetwork(this.pocketUpgrades);
    }

    @Override
    public MessageType<UpgradesLoadedMessage> type() {
        return NetworkMessages.UPGRADES_LOADED;
    }
}

