/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.turtle.upgrades;

import dan200.computercraft.api.ComputerCraftTags;
import dan200.computercraft.api.turtle.AbstractTurtleUpgrade;
import dan200.computercraft.api.turtle.ITurtleAccess;
import dan200.computercraft.api.turtle.TurtleCommandResult;
import dan200.computercraft.api.turtle.TurtleSide;
import dan200.computercraft.api.turtle.TurtleToolDurability;
import dan200.computercraft.api.turtle.TurtleUpgradeType;
import dan200.computercraft.api.turtle.TurtleVerb;
import dan200.computercraft.shared.platform.PlatformHelper;
import dan200.computercraft.shared.turtle.TurtleUtil;
import dan200.computercraft.shared.turtle.core.TurtlePlaceCommand;
import dan200.computercraft.shared.turtle.core.TurtlePlayer;
import dan200.computercraft.shared.util.DropConsumer;
import dan200.computercraft.shared.util.WorldUtil;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.GameMasterBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class TurtleTool
extends AbstractTurtleUpgrade {
    private static final TurtleCommandResult UNBREAKABLE = TurtleCommandResult.failure("Cannot break unbreakable block");
    private static final TurtleCommandResult INEFFECTIVE = TurtleCommandResult.failure("Cannot break block with this tool");
    private static final String TAG_ITEM_TAG = "Tag";
    final ItemStack item;
    final float damageMulitiplier;
    final boolean allowEnchantments;
    final TurtleToolDurability consumeDurability;
    @Nullable
    final TagKey<Block> breakable;

    public TurtleTool(ResourceLocation id, String adjective, Item craftItem, ItemStack toolItem, float damageMulitiplier, boolean allowEnchantments, TurtleToolDurability consumeDurability, @Nullable TagKey<Block> breakable) {
        super(id, TurtleUpgradeType.TOOL, adjective, new ItemStack((ItemLike)craftItem));
        this.item = toolItem;
        this.damageMulitiplier = damageMulitiplier;
        this.allowEnchantments = allowEnchantments;
        this.consumeDurability = consumeDurability;
        this.breakable = breakable;
    }

    @Override
    public boolean isItemSuitable(ItemStack stack) {
        if (this.consumeDurability == TurtleToolDurability.NEVER && stack.m_41768_()) {
            return false;
        }
        return this.allowEnchantments || !TurtleTool.isEnchanted(stack);
    }

    private static boolean isEnchanted(ItemStack stack) {
        return !stack.m_41619_() && TurtleTool.isEnchanted(stack.m_41783_());
    }

    private static boolean isEnchanted(@Nullable CompoundTag tag) {
        if (tag == null || tag.m_128456_()) {
            return false;
        }
        return tag.m_128425_("Enchantments", 9) && !tag.m_128437_("Enchantments", 10).isEmpty() || tag.m_128425_("AttributeModifiers", 9) && !tag.m_128437_("AttributeModifiers", 10).isEmpty();
    }

    @Override
    public CompoundTag getUpgradeData(ItemStack stack) {
        CompoundTag upgradeData = super.getUpgradeData(stack);
        CompoundTag itemTag = stack.m_41783_();
        if (itemTag != null) {
            upgradeData.m_128365_(TAG_ITEM_TAG, (Tag)itemTag);
        }
        return upgradeData;
    }

    @Override
    public ItemStack getUpgradeItem(CompoundTag upgradeData) {
        ItemStack item = super.getUpgradeItem(upgradeData).m_41777_();
        item.m_41751_(upgradeData.m_128425_(TAG_ITEM_TAG, 10) ? upgradeData.m_128469_(TAG_ITEM_TAG) : null);
        return item;
    }

    private ItemStack getToolStack(ITurtleAccess turtle, TurtleSide side) {
        return this.getUpgradeItem(turtle.getUpgradeNBTData(side)).m_41777_();
    }

    private void setToolStack(ITurtleAccess turtle, TurtleSide side, ItemStack stack) {
        boolean useDurability;
        CompoundTag upgradeData = turtle.getUpgradeNBTData(side);
        switch (this.consumeDurability) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case NEVER: {
                boolean bl = false;
                break;
            }
            case WHEN_ENCHANTED: {
                boolean bl;
                if (upgradeData.m_128425_(TAG_ITEM_TAG, 10) && TurtleTool.isEnchanted(upgradeData.m_128469_(TAG_ITEM_TAG))) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case ALWAYS: {
                boolean bl = useDurability = true;
            }
        }
        if (!useDurability) {
            return;
        }
        if (stack.m_41619_()) {
            turtle.setUpgradeWithData(side, null);
            return;
        }
        if (stack.m_41720_() != this.item.m_41720_()) {
            return;
        }
        CompoundTag itemTag = stack.m_41783_();
        if (Objects.equals(itemTag, upgradeData.m_128423_(TAG_ITEM_TAG))) {
            return;
        }
        if (itemTag == null) {
            upgradeData.m_128473_(TAG_ITEM_TAG);
        } else {
            upgradeData.m_128365_(TAG_ITEM_TAG, (Tag)itemTag);
        }
        turtle.updateUpgradeNBTData(side);
    }

    private <T> T withEquippedItem(ITurtleAccess turtle, TurtleSide side, Direction direction, Function<TurtlePlayer, T> action) {
        TurtlePlayer turtlePlayer = TurtlePlayer.getWithPosition(turtle, turtle.getPosition(), direction);
        turtlePlayer.loadInventory(this.getToolStack(turtle, side));
        T result = action.apply(turtlePlayer);
        this.setToolStack(turtle, side, turtlePlayer.player().m_21120_(InteractionHand.MAIN_HAND));
        turtlePlayer.player().m_150109_().m_6211_();
        return result;
    }

    @Override
    public TurtleCommandResult useTool(ITurtleAccess turtle, TurtleSide side, TurtleVerb verb, Direction direction) {
        return switch (verb) {
            default -> throw new IncompatibleClassChangeError();
            case TurtleVerb.ATTACK -> this.attack(turtle, side, direction);
            case TurtleVerb.DIG -> this.dig(turtle, side, direction);
        };
    }

    protected TurtleCommandResult checkBlockBreakable(Level world, BlockPos pos, TurtlePlayer player) {
        BlockState state = world.m_8055_(pos);
        if (state.m_60795_() || state.m_60734_() instanceof GameMasterBlock || state.m_60625_((Player)player.player(), (BlockGetter)world, pos) <= 0.0f) {
            return UNBREAKABLE;
        }
        return this.breakable == null || state.m_204336_(this.breakable) || TurtleTool.isTriviallyBreakable((BlockGetter)world, pos, state) ? TurtleCommandResult.success() : INEFFECTIVE;
    }

    private TurtleCommandResult attack(ITurtleAccess turtle, TurtleSide side, Direction direction) {
        Level world = turtle.getLevel();
        BlockPos position = turtle.getPosition();
        TurtlePlayer turtlePlayer = TurtlePlayer.getWithPosition(turtle, position, direction);
        ServerPlayer player = turtlePlayer.player();
        Vec3 turtlePos = player.m_20182_();
        Vec3 rayDir = player.m_20252_(1.0f);
        HitResult hit = WorldUtil.clip(world, turtlePos, rayDir, 1.5, null);
        boolean attacked = false;
        if (hit instanceof EntityHitResult) {
            EntityHitResult entityHit = (EntityHitResult)hit;
            ItemStack stack = this.getToolStack(turtle, side);
            turtlePlayer.loadInventory(stack);
            Entity hitEntity = entityHit.m_82443_();
            DropConsumer.set(hitEntity, TurtleUtil.dropConsumer(turtle));
            InteractionResult result = PlatformHelper.get().canAttackEntity(player, hitEntity);
            if (result.m_19077_()) {
                attacked = true;
            } else if (result == InteractionResult.PASS && hitEntity.m_6097_() && !hitEntity.m_7313_((Entity)player)) {
                attacked = this.attack(player, direction, hitEntity);
            }
            TurtleUtil.stopConsuming(turtle);
            this.setToolStack(turtle, side, player.m_21120_(InteractionHand.MAIN_HAND));
            player.m_150109_().m_6211_();
        }
        return attacked ? TurtleCommandResult.success() : TurtleCommandResult.failure("Nothing to attack here");
    }

    private boolean attack(ServerPlayer player, Direction direction, Entity entity) {
        LivingEntity target;
        DamageSource source;
        MobType mobType;
        float baseDamage = (float)player.m_21133_(Attributes.f_22281_) * this.damageMulitiplier;
        ItemStack itemStack = player.m_21120_(InteractionHand.MAIN_HAND);
        if (entity instanceof LivingEntity) {
            LivingEntity target2 = (LivingEntity)entity;
            mobType = target2.m_6336_();
        } else {
            mobType = MobType.f_21640_;
        }
        float bonusDamage = EnchantmentHelper.m_44833_((ItemStack)itemStack, (MobType)mobType);
        float damage = baseDamage + bonusDamage;
        if (damage <= 0.0f) {
            return false;
        }
        int knockBack = EnchantmentHelper.m_44894_((LivingEntity)player);
        int fireAspect = EnchantmentHelper.m_44914_((LivingEntity)player);
        boolean onFire = false;
        if (entity instanceof LivingEntity) {
            LivingEntity target3 = (LivingEntity)entity;
            if (fireAspect > 0 && !target3.m_6060_()) {
                onFire = true;
                target3.m_20254_(1);
            }
        }
        if (!entity.m_6469_(source = player.m_269291_().m_269075_((Player)player), damage)) {
            if (onFire) {
                entity.m_20095_();
            }
            return false;
        }
        if (entity.m_6084_() && entity instanceof ArmorStand) {
            entity.m_6469_(source, damage);
        }
        if (knockBack > 0) {
            if (entity instanceof LivingEntity) {
                target = (LivingEntity)entity;
                target.m_147240_((double)knockBack * 0.5, (double)(-direction.m_122429_()), (double)(-direction.m_122431_()));
            } else {
                entity.m_5997_((double)(direction.m_122429_() * knockBack) * 0.5, 0.1, (double)(direction.m_122431_() * knockBack) * 0.5);
            }
        }
        if (entity instanceof LivingEntity) {
            target = (LivingEntity)entity;
            EnchantmentHelper.m_44823_((LivingEntity)target, (Entity)player);
        }
        EnchantmentHelper.m_44896_((LivingEntity)player, (Entity)entity);
        if (entity instanceof LivingEntity) {
            target = (LivingEntity)entity;
            player.m_21120_(InteractionHand.MAIN_HAND).m_41640_(target, (Player)player);
        }
        if (entity instanceof LivingEntity) {
            target = (LivingEntity)entity;
            if (fireAspect > 0 && !target.m_6060_()) {
                target.m_20254_(4 * fireAspect);
            }
        }
        return true;
    }

    private TurtleCommandResult dig(ITurtleAccess turtle, TurtleSide side, Direction direction) {
        ServerLevel level = (ServerLevel)turtle.getLevel();
        return this.withEquippedItem(turtle, side, direction, turtlePlayer -> {
            ItemStack stack = turtlePlayer.player().m_21120_(InteractionHand.MAIN_HAND);
            if (PlatformHelper.get().hasToolUsage(stack) && this.useTool(level, turtle, (TurtlePlayer)turtlePlayer, stack, direction)) {
                return TurtleCommandResult.success();
            }
            BlockPos blockPosition = turtle.getPosition().m_121945_(direction);
            if (level.m_46859_(blockPosition) || WorldUtil.isLiquidBlock((Level)level, blockPosition)) {
                return TurtleCommandResult.failure("Nothing to dig here");
            }
            TurtleCommandResult breakable = this.checkBlockBreakable((Level)level, blockPosition, (TurtlePlayer)turtlePlayer);
            if (!breakable.isSuccess()) {
                return breakable;
            }
            DropConsumer.set((Level)level, blockPosition, TurtleUtil.dropConsumer(turtle));
            boolean broken = !turtlePlayer.isBlockProtected(level, blockPosition) && turtlePlayer.player().f_8941_.m_9280_(blockPosition);
            TurtleUtil.stopConsuming(turtle);
            return broken ? TurtleCommandResult.success() : TurtleCommandResult.failure("Cannot break protected block");
        });
    }

    private boolean useTool(ServerLevel level, ITurtleAccess turtle, TurtlePlayer turtlePlayer, ItemStack stack, Direction direction) {
        BlockPos position = turtle.getPosition().m_121945_(direction);
        if (direction == Direction.DOWN && level.m_46859_(position)) {
            position = position.m_121945_(direction);
        }
        if (!level.m_46739_(position) || level.m_46859_(position) || turtlePlayer.isBlockProtected(level, position)) {
            return false;
        }
        BlockHitResult hit = TurtlePlaceCommand.getHitResult(position, direction.m_122424_());
        InteractionResult result = PlatformHelper.get().useOn(turtlePlayer.player(), stack, hit, x -> false);
        return result.m_19077_();
    }

    private static boolean isTriviallyBreakable(BlockGetter reader, BlockPos pos, BlockState state) {
        return state.m_204336_(ComputerCraftTags.Blocks.TURTLE_ALWAYS_BREAKABLE) || state.m_60800_(reader, pos) == 0.0f;
    }
}

