/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.util;

import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;
import javax.annotation.Nullable;

public class Trie<K, V> {
    @Nullable
    private V current;
    @Nullable
    private Map<K, Trie<K, V>> children;

    public Trie<K, V> getChild(Iterable<K> key) {
        Trie self = this;
        for (K keyElement : key) {
            if (self.children == null) {
                self.children = new HashMap<K, Trie<K, V>>(1);
            }
            self = self.children.computeIfAbsent(keyElement, x -> new Trie());
        }
        return self;
    }

    @Nullable
    public V getValue(Iterable<K> key) {
        return this.getChild(key).current;
    }

    public void setValue(Iterable<K> key, V value) {
        this.getChild(key).current = value;
    }

    public Stream<V> stream() {
        return Stream.concat(this.current == null ? Stream.empty() : Stream.of(this.current), this.children == null ? Stream.empty() : this.children.values().stream().flatMap(Trie::stream));
    }
}

