/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.misc;

import java.util.Map;
import java.util.function.Supplier;
import net.mehvahdjukaar.moonlight.api.misc.WeakHashSet;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DataObjectReference<T>
implements Supplier<T> {
    private static final WeakHashSet<DataObjectReference<?>> REFERENCES = new WeakHashSet();
    private final ResourceKey<Registry<T>> registryKey;
    private final ResourceKey<T> key;
    @Nullable
    private Holder<T> cache;

    public DataObjectReference(String id, ResourceKey<Registry<T>> registry) {
        this(new ResourceLocation(id), registry);
    }

    public DataObjectReference(ResourceLocation location, ResourceKey<Registry<T>> registry) {
        this.registryKey = registry;
        this.key = ResourceKey.m_135785_(this.registryKey, (ResourceLocation)location);
        REFERENCES.add(this);
    }

    public DataObjectReference(ResourceKey<T> key) {
        this.key = key;
        this.registryKey = ResourceKey.m_135788_((ResourceLocation)key.m_211136_());
        REFERENCES.add(this);
    }

    public Holder<T> getHolder() {
        if (this.cache == null) {
            RegistryAccess r = Utils.hackyGetRegistryAccess();
            Registry reg = r.m_175515_(this.registryKey);
            try {
                this.cache = reg.m_246971_(this.key);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to get object from registry: " + String.valueOf(this.key) + ".\nCalled from " + String.valueOf(Thread.currentThread()) + ".\nRegistry content was: " + String.valueOf(reg.m_6579_().stream().map(Map.Entry::getValue).toList()), e);
            }
        }
        return this.cache;
    }

    @Override
    @NotNull
    public T get() {
        return (T)this.getHolder().m_203334_();
    }

    @Deprecated(forRemoval=true)
    @Nullable
    public T getUnchecked() {
        return this.get();
    }

    public void clearCache() {
        this.cache = null;
    }

    public ResourceLocation getID() {
        return this.key.m_135782_();
    }

    @ApiStatus.Internal
    public static void onDataReload() {
        REFERENCES.forEach(DataObjectReference::clearCache);
    }
}

