/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.misc;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public class PathTrie<T> {
    private final TrieNode<T> root = new TrieNode();

    public void insert(ResourceLocation resourceLocation, T object) {
        this.insert(resourceLocation.m_135827_() + "/" + resourceLocation.m_135815_(), object);
    }

    public void insert(String path, T object) {
        String[] folders = path.split("/");
        TrieNode<T> current = this.root;
        for (int i = 0; i < folders.length - 1; ++i) {
            String folder = folders[i];
            current.children.putIfAbsent(folder, new TrieNode());
            current = current.children.get(folder);
        }
        current.objects.add(object);
    }

    public Collection<T> search(ResourceLocation id) {
        return this.search(id.m_135827_() + "/" + id.m_135815_());
    }

    public Collection<T> search(String path) {
        TrieNode<T> current = this.getNode(path);
        if (current == null) {
            return Collections.emptyList();
        }
        return current.collectObjects();
    }

    public boolean remove(ResourceLocation resourceLocation) {
        return this.remove(resourceLocation.m_135827_() + "/" + resourceLocation.m_135815_());
    }

    public boolean remove(String path) {
        TrieNode<T> current = this.getNode(path);
        if (current == null) {
            return false;
        }
        current.children.clear();
        current.objects.clear();
        return true;
    }

    @Nullable
    private TrieNode<T> getNode(String path) {
        String[] folders = path.split("/");
        TrieNode<T> current = this.root;
        for (String folder : folders) {
            current = current.children.get(folder);
            if (current != null) continue;
            return null;
        }
        return current;
    }

    public void clear() {
        this.root.children.clear();
        this.root.objects.clear();
    }

    public Collection<String> listFolders(String path) {
        TrieNode<T> startNode = this.getNode(path);
        if (startNode != null) {
            return startNode.children.keySet();
        }
        return Collections.emptyList();
    }

    private static class TrieNode<T> {
        Map<String, TrieNode<T>> children = new HashMap<String, TrieNode<T>>();
        List<T> objects = new ArrayList<T>();

        public List<T> collectObjects() {
            ArrayList<T> result = new ArrayList<T>(this.objects);
            for (TrieNode<T> child : this.children.values()) {
                result.addAll(child.collectObjects());
            }
            return result;
        }
    }
}

