/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.core.databuddy;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.Config;
import com.electronwill.nightconfig.core.NullObject;
import com.electronwill.nightconfig.core.UnmodifiableConfig;
import com.electronwill.nightconfig.toml.TomlFormat;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import java.time.temporal.Temporal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Stream;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConfigHelper {
    static final Logger LOGGER = LogManager.getLogger();

    private ConfigHelper() {
    }

    public static <T> T register(ModConfig.Type configType, Function<ForgeConfigSpec.Builder, T> configFactory) {
        return ConfigHelper.register(configType, configFactory, null);
    }

    public static <T> T register(ModConfig.Type configType, Function<ForgeConfigSpec.Builder, T> configFactory, @Nullable String configName) {
        ModLoadingContext modContext = ModLoadingContext.get();
        org.apache.commons.lang3.tuple.Pair entry = new ForgeConfigSpec.Builder().configure(configFactory);
        Object config = entry.getLeft();
        ForgeConfigSpec spec = (ForgeConfigSpec)entry.getRight();
        if (configName == null) {
            modContext.registerConfig(configType, (IConfigSpec)spec);
        } else {
            modContext.registerConfig(configType, (IConfigSpec)spec, configName + ".toml");
        }
        return (T)config;
    }

    public static <T> ConfigObject<T> defineObject(ForgeConfigSpec.Builder builder, String name, Codec<T> codec, Supplier<T> defaultSupplier) {
        Supplier lazyDefaultValue = Suppliers.memoize(() -> {
            Object defaultValue = defaultSupplier.get();
            DataResult encodeResult = codec.encodeStart((DynamicOps)TomlConfigOps.INSTANCE, defaultValue);
            return encodeResult.getOrThrow(false, s -> LOGGER.error("Unable to encode default value: {}", s));
        });
        ForgeConfigSpec.ConfigValue value = builder.define(name, (java.util.function.Supplier)lazyDefaultValue, o -> o != null && lazyDefaultValue.get().getClass().isAssignableFrom(o.getClass()));
        return new ConfigObject<T>((ForgeConfigSpec.ConfigValue<Object>)value, codec, defaultSupplier);
    }

    public static class ConfigObject<T>
    implements java.util.function.Supplier<T> {
        @NotNull
        private final ForgeConfigSpec.ConfigValue<Object> value;
        @NotNull
        private final Codec<T> codec;
        @Nullable
        private Object cachedObject;
        @NotNull
        private T parsedObject;
        @NotNull
        private final java.util.function.Supplier<T> defaultObject;

        private ConfigObject(ForgeConfigSpec.ConfigValue<Object> value, Codec<T> codec, Supplier<T> defaultSupplier) {
            this.value = value;
            this.codec = codec;
            this.defaultObject = Suppliers.memoize(defaultSupplier);
        }

        @Override
        @NotNull
        public T get() {
            Object freshObject = this.value.get();
            if (!Objects.equals(this.cachedObject, freshObject)) {
                this.cachedObject = freshObject;
                this.parsedObject = this.getReparsedObject(freshObject);
            }
            return this.parsedObject;
        }

        private T getReparsedObject(Object obj) {
            DataResult parseResult = this.codec.parse((DynamicOps)TomlConfigOps.INSTANCE, obj);
            return (T)parseResult.get().map(result -> result, failure -> {
                LOGGER.error("Config failure: Using default config value due to parsing error: {}", (Object)failure.message());
                return this.defaultObject.get();
            });
        }
    }

    public static class TomlConfigOps
    implements DynamicOps<Object> {
        public static final TomlConfigOps INSTANCE = new TomlConfigOps();

        public Object empty() {
            return NullObject.NULL_OBJECT;
        }

        public <U> U convertTo(DynamicOps<U> outOps, Object input) {
            if (input instanceof Config) {
                return (U)this.convertMap(outOps, input);
            }
            if (input instanceof Collection) {
                return (U)this.convertList(outOps, input);
            }
            if (input == null || input instanceof NullObject) {
                return (U)outOps.empty();
            }
            if (input instanceof Enum) {
                return (U)outOps.createString(((Enum)input).name());
            }
            if (input instanceof Temporal) {
                return (U)outOps.createString(input.toString());
            }
            if (input instanceof String) {
                String s = (String)input;
                return (U)outOps.createString(s);
            }
            if (input instanceof Boolean) {
                Boolean b = (Boolean)input;
                return (U)outOps.createBoolean(b.booleanValue());
            }
            if (input instanceof Number) {
                Number n = (Number)input;
                return (U)outOps.createNumeric(n);
            }
            throw new UnsupportedOperationException("TomlConfigOps was unable to convert toml value: " + String.valueOf(input));
        }

        public DataResult<Number> getNumberValue(Object input) {
            DataResult dataResult;
            if (input instanceof Number) {
                Number n = (Number)input;
                dataResult = DataResult.success((Object)n);
            } else {
                dataResult = DataResult.error(() -> "Not a number: " + String.valueOf(input));
            }
            return dataResult;
        }

        public DataResult<Boolean> getBooleanValue(Object input) {
            if (input instanceof Boolean) {
                Boolean b = (Boolean)input;
                return DataResult.success((Object)b);
            }
            if (input instanceof Number) {
                Number n = (Number)input;
                return DataResult.success((Object)(n.intValue() > 0 ? 1 : 0));
            }
            return DataResult.error(() -> "Not a boolean: " + String.valueOf(input));
        }

        public Object createBoolean(boolean value) {
            return value;
        }

        public boolean compressMaps() {
            return false;
        }

        public Object createNumeric(Number i) {
            return i;
        }

        public DataResult<String> getStringValue(Object input) {
            if (input instanceof Config || input instanceof Collection) {
                return DataResult.error(() -> "Not a string: " + String.valueOf(input));
            }
            return DataResult.success((Object)String.valueOf(input));
        }

        public Object createString(String value) {
            return value;
        }

        public DataResult<Object> mergeToList(Object list, List<Object> values) {
            return super.mergeToList(list, values).map(obj -> obj == this.empty() ? new ArrayList() : obj);
        }

        public DataResult<Object> mergeToList(Object list, Object value) {
            if (!(list instanceof Collection) && list != this.empty()) {
                return DataResult.error(() -> "mergeToList called with not a list: " + String.valueOf(list), (Object)list);
            }
            ArrayList<Object> result = new ArrayList<Object>();
            if (list != this.empty()) {
                Collection listAsCollection = (Collection)list;
                result.addAll(listAsCollection);
            }
            result.add(value);
            return DataResult.success(result);
        }

        public DataResult<Object> mergeToMap(Object map, Object key, Object value) {
            if (!(map instanceof Config) && map != this.empty()) {
                return DataResult.error(() -> "mergeToMap called with not a map: " + String.valueOf(map), (Object)map);
            }
            DataResult<String> stringResult = this.getStringValue(key);
            Optional badResult = stringResult.error();
            if (badResult.isPresent()) {
                return DataResult.error(() -> "key is not a string: " + String.valueOf(key), (Object)map);
            }
            return stringResult.flatMap(s -> {
                CommentedConfig output = TomlFormat.newConfig();
                if (map != this.empty()) {
                    Config oldConfig = (Config)map;
                    output.addAll((UnmodifiableConfig)oldConfig);
                }
                output.add(s, value);
                return DataResult.success((Object)output);
            });
        }

        public DataResult<Stream<Pair<Object, Object>>> getMapValues(Object input) {
            if (!(input instanceof Config)) {
                return DataResult.error(() -> "Not a Config: " + String.valueOf(input));
            }
            Config config = (Config)input;
            return DataResult.success(config.entrySet().stream().map(entry -> Pair.of((Object)entry.getKey(), (Object)entry.getValue())));
        }

        public Object createMap(Stream<Pair<Object, Object>> map) {
            CommentedConfig result = TomlFormat.newConfig();
            map.forEach(arg_0 -> this.lambda$createMap$11((Config)result, arg_0));
            return result;
        }

        public DataResult<Stream<Object>> getStream(Object input) {
            if (input instanceof Collection) {
                Collection collection = (Collection)input;
                return DataResult.success(collection.stream());
            }
            return DataResult.error(() -> "Not a collection: " + String.valueOf(input));
        }

        public Object createList(Stream<Object> input) {
            return input.toList();
        }

        public Object remove(Object input, String key) {
            if (input instanceof Config) {
                Config oldConfig = (Config)input;
                CommentedConfig result = TomlFormat.newConfig();
                oldConfig.entrySet().stream().filter(entry -> !Objects.equals(entry.getKey(), key)).forEach(arg_0 -> TomlConfigOps.lambda$remove$14((Config)result, arg_0));
                return result;
            }
            return input;
        }

        public String toString() {
            return "TOML";
        }

        private static /* synthetic */ void lambda$remove$14(Config result, Config.Entry entry) {
            result.add(entry.getKey(), entry.getValue());
        }

        private /* synthetic */ void lambda$createMap$11(Config result, Pair p) {
            result.add((String)this.getStringValue(p.getFirst()).getOrThrow(false, s -> {}), p.getSecond());
        }
    }
}

