/*
 * Decompiled with CFR 0.152.
 */
package plus.dragons.visuality.registry;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraftforge.client.event.RegisterParticleProvidersEvent;
import net.minecraftforge.registries.RegistryObject;
import plus.dragons.visuality.particle.ChargeParticle;
import plus.dragons.visuality.particle.FeatherParticle;
import plus.dragons.visuality.particle.SlimeParticle;
import plus.dragons.visuality.particle.SolidFallingParticle;
import plus.dragons.visuality.particle.SoulParticle;
import plus.dragons.visuality.particle.SparkleParticle;
import plus.dragons.visuality.particle.VisualityParticleEngine;
import plus.dragons.visuality.particle.WaterCircleParticle;
import plus.dragons.visuality.particle.type.ColorParticleType;
import plus.dragons.visuality.particle.type.ColorScaleParticleType;
import plus.dragons.visuality.registry.VisualityRegistries;

public class VisualityParticles {
    public static final RegistryObject<ColorParticleType> SPARKLE = VisualityParticles.register("sparkle", ColorParticleType::new);
    public static final RegistryObject<SimpleParticleType> BONE = VisualityParticles.register("bone");
    public static final RegistryObject<SimpleParticleType> WITHER_BONE = VisualityParticles.register("wither_bone");
    public static final RegistryObject<SimpleParticleType> FEATHER = VisualityParticles.register("feather");
    public static final RegistryObject<ColorScaleParticleType> SMALL_SLIME_BLOB = VisualityParticles.register("small_slime_blob", ColorScaleParticleType::new);
    public static final RegistryObject<ColorScaleParticleType> MEDIUM_SLIME_BLOB = VisualityParticles.register("medium_slime_blob", ColorScaleParticleType::new);
    public static final RegistryObject<ColorScaleParticleType> BIG_SLIME_BLOB = VisualityParticles.register("big_slime_blob", ColorScaleParticleType::new);
    public static final RegistryObject<SimpleParticleType> CHARGE = VisualityParticles.register("charge");
    public static final RegistryObject<ColorParticleType> WATER_CIRCLE = VisualityParticles.register("water_circle", ColorParticleType::new);
    public static final RegistryObject<SimpleParticleType> EMERALD = VisualityParticles.register("emerald");
    public static final RegistryObject<SimpleParticleType> SOUL = VisualityParticles.register("soul");

    private static RegistryObject<SimpleParticleType> register(String name) {
        return VisualityRegistries.Registers.PARTICLE_TYPES.register(name, () -> new SimpleParticleType(false));
    }

    private static <O extends ParticleOptions, T extends ParticleType<O>> RegistryObject<T> register(String name, Supplier<T> factory) {
        return VisualityRegistries.Registers.PARTICLE_TYPES.register(name, factory);
    }

    public static void register() {
    }

    public static void registerProviders(RegisterParticleProvidersEvent event) {
        VisualityParticleEngine engine = (VisualityParticleEngine)Minecraft.m_91087_().f_91061_;
        engine.registerVisuality(SPARKLE, SparkleParticle.Provider::new);
        engine.registerVisuality(BONE, SolidFallingParticle.Provider::new);
        engine.registerVisuality(WITHER_BONE, SolidFallingParticle.Provider::new);
        engine.registerVisuality(FEATHER, FeatherParticle.Provider::new);
        engine.registerVisuality(SMALL_SLIME_BLOB, SlimeParticle.Provider::new);
        engine.registerVisuality(MEDIUM_SLIME_BLOB, SlimeParticle.Provider::new);
        engine.registerVisuality(BIG_SLIME_BLOB, SlimeParticle.Provider::new);
        engine.registerVisuality(CHARGE, ChargeParticle.Provider::new);
        engine.registerVisuality(WATER_CIRCLE, WaterCircleParticle.Provider::new);
        engine.registerVisuality(EMERALD, SolidFallingParticle.Provider::new);
        engine.registerVisuality(SOUL, SoulParticle.Provider::new);
    }
}

