/*
 * Decompiled with CFR 0.152.
 */
package com.github.nyuppo.mixin;

import com.github.nyuppo.MoreMobVariants;
import com.github.nyuppo.config.Variants;
import com.github.nyuppo.variant.MobVariant;
import net.minecraft.client.renderer.entity.SheepRenderer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.animal.Sheep;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={SheepRenderer.class})
public class SheepRendererMixin {
    private static final ResourceLocation DEFAULT = new ResourceLocation("textures/entity/sheep/sheep.png");

    @Inject(method={"getTextureLocation(Lnet/minecraft/world/entity/animal/Sheep;)Lnet/minecraft/resources/ResourceLocation;"}, at={@At(value="HEAD")}, cancellable=true)
    private void onGetTextureLocation(Sheep sheepEntity, CallbackInfoReturnable<ResourceLocation> ci) {
        Object variant;
        CompoundTag nbt = new CompoundTag();
        sheepEntity.m_20240_(nbt);
        if (nbt.m_128441_("VariantID")) {
            variant = nbt.m_128461_("VariantID");
            if (((String)variant).equals(MoreMobVariants.id("default").toString()) || ((String)variant).isEmpty()) {
                ci.setReturnValue((Object)DEFAULT);
            } else {
                String[] split = Variants.splitVariant((String)variant);
                ci.setReturnValue((Object)new ResourceLocation(split[0], "textures/entity/sheep/" + split[1] + ".png"));
            }
        }
        if (sheepEntity.m_8077_() && (variant = Variants.getVariantFromNametag(EntityType.f_20520_, sheepEntity.m_7755_().getString())) != null) {
            ResourceLocation identifier = ((MobVariant)variant).getIdentifier();
            ci.setReturnValue((Object)new ResourceLocation(identifier.m_135827_(), "textures/entity/sheep/" + identifier.m_135815_() + ".png"));
        }
    }
}

