/*
 * Decompiled with CFR 0.152.
 */
package com.misterpemodder.shulkerboxtooltip.impl.network.channel;

import com.misterpemodder.shulkerboxtooltip.ShulkerBoxTooltip;
import com.misterpemodder.shulkerboxtooltip.impl.network.ClientNetworking;
import com.misterpemodder.shulkerboxtooltip.impl.network.ServerNetworking;
import com.misterpemodder.shulkerboxtooltip.impl.network.channel.Channel;
import com.misterpemodder.shulkerboxtooltip.impl.network.context.C2SMessageContext;
import com.misterpemodder.shulkerboxtooltip.impl.network.context.MessageContext;
import com.misterpemodder.shulkerboxtooltip.impl.network.message.MessageType;
import io.netty.buffer.Unpooled;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public final class C2SChannel<MSG>
extends Channel<MSG> {
    @OnlyIn(value=Dist.CLIENT)
    private boolean serverRegistered;

    public C2SChannel(ResourceLocation id, MessageType<MSG> messageType) {
        super(id, messageType);
        if (ShulkerBoxTooltip.isClient()) {
            this.serverRegistered = false;
        }
    }

    public void registerFor(ServerPlayer player) {
        ServerNetworking.registerC2SReceiver(this.id, player, (sender, buf) -> {
            Object message = this.messageType.decode(buf);
            C2SMessageContext context = new C2SMessageContext(sender, this);
            this.messageType.onReceive(message, context);
        });
    }

    public void unregisterFor(ServerPlayer player) {
        ServerNetworking.unregisterC2SReceiver(this.id, player);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void sendToServer(MSG message) {
        ClientPacketListener handler = Minecraft.m_91087_().m_91403_();
        if (handler == null) {
            ShulkerBoxTooltip.LOGGER.error("Cannot send message to the " + this.id + " channel while not in-game");
            return;
        }
        FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
        this.messageType.encode(message, buf);
        handler.m_104955_(ClientNetworking.createC2SPacket(this.id, buf));
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean canSendToServer() {
        return this.serverRegistered && Minecraft.m_91087_().m_91403_() != null;
    }

    @Override
    protected void onRegister(MessageContext<MSG> context) {
        if (context.getReceivingSide() == MessageContext.Side.CLIENT) {
            this.serverRegistered = true;
        }
        super.onRegister(context);
    }

    @Override
    protected void onUnregister(MessageContext<MSG> context) {
        if (context.getReceivingSide() == MessageContext.Side.CLIENT) {
            this.serverRegistered = false;
        }
        super.onUnregister(context);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void onDisconnect() {
        this.serverRegistered = false;
    }
}

