/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.api.component;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import mcp.mobius.waila.api.ITooltipComponent;
import mcp.mobius.waila.api.WailaConstants;
import mcp.mobius.waila.api.WailaHelper;
import mcp.mobius.waila.api.__internal__.ApiSide;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;

@ApiSide.ClientOnly
public class BarComponent
implements ITooltipComponent {
    static final int WIDTH = 100;
    static final int HEIGHT = 11;
    private static final float U0 = 0.0859375f;
    static final float U1 = 0.4765625f;
    static final float V0_BG = 0.0f;
    static final float V1_BG = 0.04296875f;
    private static final float V0_FG = 0.04296875f;
    private static final float V1_FG = 0.0859375f;
    private static final float UV_W = 0.390625f;
    private final float ratio;
    private final int color;
    private final Component text;

    public BarComponent(float ratio, int color) {
        this(ratio, color, CommonComponents.f_237098_);
    }

    public BarComponent(float ratio, int color, String text) {
        this(ratio, color, (Component)Component.m_237113_((String)text));
    }

    public BarComponent(float ratio, int color, Component text) {
        this.ratio = ratio;
        this.color = color;
        this.text = text;
    }

    @Override
    public int getWidth() {
        return Math.max(Minecraft.m_91087_().f_91062_.m_92852_((FormattedText)this.text), 100);
    }

    @Override
    public int getHeight() {
        return 11;
    }

    @Override
    public void render(GuiGraphics ctx, int x, int y, float delta) {
        BarComponent.renderBar(ctx.m_280168_(), x, y, 100.0f, 0.0f, 0.4765625f, 0.04296875f, this.color);
        BarComponent.renderBar(ctx.m_280168_(), x, y, 100.0f * this.ratio, 0.04296875f, 0.0859375f + 0.390625f * this.ratio, 0.0859375f, this.color);
        BarComponent.renderText(ctx.m_280168_(), this.text, x, y);
    }

    static void renderBar(PoseStack matrices, int x, int y, float w, float v0, float u1, float v1, int tint) {
        matrices.m_85836_();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(GameRenderer::m_172814_);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)WailaConstants.COMPONENT_TEXTURE);
        int a = WailaHelper.getAlpha(tint);
        int r = WailaHelper.getRed(tint);
        int g = WailaHelper.getGreen(tint);
        int b = WailaHelper.getBlue(tint);
        Tesselator tessellator = Tesselator.m_85913_();
        BufferBuilder buffer = tessellator.m_85915_();
        buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85818_);
        buffer.m_252986_(matrices.m_85850_().m_252922_(), (float)x, (float)(y + 11), 0.0f).m_6122_(r, g, b, a).m_7421_(0.0859375f, v1).m_5752_();
        buffer.m_252986_(matrices.m_85850_().m_252922_(), (float)x + w, (float)(y + 11), 0.0f).m_6122_(r, g, b, a).m_7421_(u1, v1).m_5752_();
        buffer.m_252986_(matrices.m_85850_().m_252922_(), (float)x + w, (float)y, 0.0f).m_6122_(r, g, b, a).m_7421_(u1, v0).m_5752_();
        buffer.m_252986_(matrices.m_85850_().m_252922_(), (float)x, (float)y, 0.0f).m_6122_(r, g, b, a).m_7421_(0.0859375f, v0).m_5752_();
        tessellator.m_85914_();
        RenderSystem.disableBlend();
        matrices.m_85849_();
    }

    static void renderText(PoseStack matrices, Component text, int x, int y) {
        Font font = Minecraft.m_91087_().f_91062_;
        int textWidth = font.m_92852_((FormattedText)text);
        float textX = (float)x + Math.max((float)(100 - textWidth) / 2.0f, 0.0f);
        float textY = y + 2;
        MultiBufferSource.BufferSource textBuf = MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_());
        font.m_168645_(text.m_7532_(), textX, textY, 0xAAAAAA, 0x292929, matrices.m_85850_().m_252922_(), (MultiBufferSource)textBuf, 0xF000F0);
        textBuf.m_109911_();
    }
}

