/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.forge;

import mcp.mobius.waila.Waila;
import mcp.mobius.waila.command.ServerCommand;
import mcp.mobius.waila.config.PluginConfig;
import mcp.mobius.waila.debug.DumpGenerator;
import mcp.mobius.waila.network.Packets;
import mcp.mobius.waila.plugin.PluginLoader;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.TagsUpdatedEvent;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.event.server.ServerStoppedEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;

@Mod(value="waila")
@Mod.EventBusSubscriber(modid="waila", bus=Mod.EventBusSubscriber.Bus.MOD)
public class ForgeWaila
extends Waila {
    @SubscribeEvent
    static void setup(FMLCommonSetupEvent event) {
        String[] mods;
        Packets.initServer();
        for (String mod : mods = new String[]{"minecraft", "forge", "wthit", "jei"}) {
            ModList.get().getModContainerById(mod).map(ModContainer::getModInfo).ifPresent(m -> DumpGenerator.VERSIONS.put(m.getDisplayName(), m.getVersion().toString()));
        }
    }

    @SubscribeEvent
    static void loadComplete(FMLLoadCompleteEvent event) {
        PluginLoader.INSTANCE.loadPlugins();
    }

    @Mod.EventBusSubscriber(modid="waila")
    static class Subscriber {
        Subscriber() {
        }

        @SubscribeEvent
        static void serverStarting(ServerStartingEvent event) {
            PluginConfig.reload();
        }

        @SubscribeEvent
        static void serverStopped(ServerStoppedEvent event) {
            ForgeWaila.onServerStopped();
        }

        @SubscribeEvent
        static void tagReload(TagsUpdatedEvent event) {
            ForgeWaila.onTagReload();
        }

        @SubscribeEvent
        static void registerCommands(RegisterCommandsEvent event) {
            new ServerCommand().register(event.getDispatcher());
        }
    }
}

