/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.plugin;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import io.netty.buffer.Unpooled;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import lol.bai.badpackets.api.PacketSender;
import mcp.mobius.waila.Waila;
import mcp.mobius.waila.api.IPluginInfo;
import mcp.mobius.waila.api.__internal__.Internals;
import mcp.mobius.waila.config.JsonConfig;
import mcp.mobius.waila.config.PluginConfig;
import mcp.mobius.waila.mcless.version.VersionRanges;
import mcp.mobius.waila.network.Packets;
import mcp.mobius.waila.plugin.PluginInfo;
import mcp.mobius.waila.registry.Registrar;
import mcp.mobius.waila.service.ICommonService;
import mcp.mobius.waila.util.Log;
import mcp.mobius.waila.util.ModInfo;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;

public abstract class PluginLoader {
    public static final PluginLoader INSTANCE = Internals.loadService(PluginLoader.class);
    private static final Log LOG = Log.create();
    protected static final String[] PLUGIN_JSON_FILES = new String[]{"waila_plugins.json", "wthit_plugins.json"};
    protected static final String KEY_INITIALIZER = "initializer";
    protected static final String KEY_SIDE = "side";
    protected static final String KEY_REQUIRED = "required";
    protected static final String KEY_DEFAULT_ENABLED = "defaultEnabled";
    protected static final Map<String, IPluginInfo.Side> SIDES = Map.of("client", IPluginInfo.Side.CLIENT, "server", IPluginInfo.Side.SERVER, "both", IPluginInfo.Side.BOTH, "*", IPluginInfo.Side.BOTH);
    private boolean gathered = false;

    public static void reloadServerPlugins(MinecraftServer server) {
        PluginInfo.saveToggleConfig();
        PluginInfo.refresh();
        INSTANCE.loadPlugins();
        server.m_6846_().m_11314_().forEach(player -> {
            PacketSender sender = PacketSender.s2c((ServerPlayer)player);
            if (!sender.canSend(Packets.PLUGIN)) {
                return;
            }
            if (!server.m_7779_(player.m_36316_())) {
                FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
                buf.m_236828_(PluginInfo.getAll().stream().filter(it -> !it.isEnabled()).map(IPluginInfo::getPluginId).toList(), FriendlyByteBuf::m_130085_);
                sender.send(Packets.PLUGIN, buf);
            }
            Packets.sendConfig(sender);
        });
    }

    public static void reloadClientPlugins() {
        INSTANCE.loadPlugins();
        if (Minecraft.m_91087_().m_91403_() != null && PacketSender.c2s().canSend(Packets.CONFIG_SYNC_REQ)) {
            PacketSender.c2s().send(Packets.CONFIG_SYNC_REQ, new FriendlyByteBuf(Unpooled.buffer()));
        }
    }

    protected abstract void gatherPlugins();

    protected void readPluginsJson(String modId, Path path) {
        try (BufferedReader reader = Files.newBufferedReader(path);){
            JsonObject object = JsonParser.parseReader((Reader)reader).getAsJsonObject();
            block7: for (String pluginId : object.keySet()) {
                IPluginInfo.Side side;
                JsonObject plugin = object.getAsJsonObject(pluginId);
                String initializer = plugin.getAsJsonPrimitive(KEY_INITIALIZER).getAsString();
                IPluginInfo.Side side2 = side = plugin.has(KEY_SIDE) ? Objects.requireNonNull(SIDES.get(plugin.get(KEY_SIDE).getAsString()), () -> PluginLoader.readError(path) + ", invalid side, available: " + SIDES.keySet().stream().collect(Collectors.joining(", ", "[", "]"))) : IPluginInfo.Side.BOTH;
                if (!side.matches(ICommonService.INSTANCE.getSide())) continue;
                ArrayList<String> required = new ArrayList<String>();
                if (plugin.has(KEY_REQUIRED)) {
                    JsonElement requiredElement = plugin.get(KEY_REQUIRED);
                    if (requiredElement.isJsonArray()) {
                        JsonArray array = requiredElement.getAsJsonArray();
                        for (JsonElement element : array) {
                            String requiredModId = element.getAsString();
                            if (!ModInfo.get(requiredModId).isPresent()) continue block7;
                            required.add(requiredModId);
                        }
                    } else if (requiredElement.isJsonObject()) {
                        JsonObject requiredObj = requiredElement.getAsJsonObject();
                        for (String requiredModId : requiredObj.keySet()) {
                            ModInfo requiredMod = ModInfo.get(requiredModId);
                            String versionSpec = requiredObj.getAsJsonPrimitive(requiredModId).getAsString();
                            if (!requiredMod.isPresent() || !VersionRanges.parse(versionSpec).match(requiredMod.getVersion())) continue block7;
                            required.add(requiredModId);
                        }
                    }
                }
                boolean defaultEnabled = !plugin.has(KEY_DEFAULT_ENABLED) || plugin.get(KEY_DEFAULT_ENABLED).getAsBoolean();
                PluginInfo.register(modId, pluginId, side, initializer, required, defaultEnabled, false);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(PluginLoader.readError(path), e);
        }
    }

    public final void loadPlugins() {
        Registrar.destroy();
        if (!this.gathered) {
            this.gathered = true;
            this.gatherPlugins();
            if (Waila.DEBUG_CONFIG.get().showTestPluginToggle) {
                PluginInfo.register("wthit", Waila.id("test").toString(), IPluginInfo.Side.BOTH, "mcp.mobius.waila.plugin.test.WailaPluginTest", List.of(), false, false);
            }
        }
        PluginInfo.saveToggleConfig();
        IPluginInfo extraPlugin = null;
        ArrayList<String> legacyPlugins = new ArrayList<String>();
        for (IPluginInfo info : PluginInfo.getAll()) {
            if (info.getPluginId().equals((Object)Waila.id("extra"))) {
                extraPlugin = info;
            } else {
                this.initialize(info);
            }
            if (!((PluginInfo)info).isLegacy()) continue;
            legacyPlugins.add(info.getPluginId().toString());
        }
        if (extraPlugin != null) {
            this.initialize(extraPlugin);
        }
        if (!legacyPlugins.isEmpty()) {
            LOG.warn("Found plugins registered via legacy platform-dependant method:");
            LOG.warn(legacyPlugins.stream().collect(Collectors.joining(", ", "[", "]")));
            LOG.warn("The method will be removed on Minecraft 1.21");
        }
        Registrar.get().lock();
        PluginConfig.reload();
        JsonConfig.INSTANCES.forEach(it -> it.write(it.get(), true));
    }

    private void initialize(IPluginInfo info) {
        Registrar.get().attach(info);
        if (info.isEnabled()) {
            LOG.info("Initializing plugin {} at {}", info.getPluginId(), info.getInitializer().getClass().getCanonicalName());
        } else {
            LOG.info("Skipping disabled plugin {}", info.getPluginId());
        }
        info.getInitializer().register(Registrar.get());
        Registrar.get().attach(null);
    }

    private static String readError(Path path) {
        return "Failed to read [" + path + "]";
    }
}

