/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.plugin.extra.provider;

import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import mcp.mobius.waila.api.IDataReader;
import mcp.mobius.waila.api.IPluginConfig;
import mcp.mobius.waila.api.IRegistrar;
import mcp.mobius.waila.api.ITooltip;
import mcp.mobius.waila.api.ITooltipComponent;
import mcp.mobius.waila.api.component.ItemListComponent;
import mcp.mobius.waila.api.component.NamedItemListComponent;
import mcp.mobius.waila.api.data.ItemData;
import mcp.mobius.waila.api.data.ProgressData;
import mcp.mobius.waila.plugin.extra.data.ItemDataImpl;
import mcp.mobius.waila.plugin.extra.data.ProgressDataImpl;
import mcp.mobius.waila.plugin.extra.provider.DataProvider;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class ItemProvider
extends DataProvider<ItemData, ItemDataImpl> {
    public static final ItemProvider INSTANCE = new ItemProvider();
    private static final CompoundTag EMPTY = new CompoundTag();
    @Nullable
    private ItemData lastData = null;
    @Nullable
    private ITooltipComponent lastItemsComponent = null;

    protected ItemProvider() {
        super(ItemData.ID, ItemData.class, ItemDataImpl.class, ItemDataImpl::new);
    }

    @Override
    protected void registerAdditions(IRegistrar registrar, int priority) {
        registrar.addSyncedConfig(ItemData.CONFIG_SYNC_NBT, true, false);
        registrar.addConfig(ItemData.CONFIG_DISPLAY_MODE, ItemData.ItemDisplayMode.DYNAMIC);
        registrar.addConfig(ItemData.CONFIG_MAX_HEIGHT, 3);
        registrar.addConfig(ItemData.CONFIG_SORT_BY_COUNT, true);
    }

    @Override
    protected void appendBody(ITooltip tooltip, IDataReader reader, IPluginConfig config, ResourceLocation objectId) {
        ProgressDataImpl progress = (ProgressDataImpl)reader.get(ProgressData.class);
        if (progress == null || progress.ratio() == 0.0f) {
            super.appendBody(tooltip, reader, config, objectId);
        }
    }

    @Override
    protected void appendBody(ITooltip tooltip, ItemDataImpl data, IPluginConfig config, ResourceLocation objectId) {
        if (data == this.lastData) {
            if (this.lastItemsComponent != null) {
                tooltip.setLine(ItemData.ID, this.lastItemsComponent);
            }
            return;
        }
        this.lastData = data;
        this.lastItemsComponent = null;
        LinkedHashMap<Object, ItemStack> merged = new LinkedHashMap<Object, ItemStack>();
        HashMap<Item, Set> unique = new HashMap<Item, Set>();
        for (ItemStack stack : data.items()) {
            Item item = stack.m_41720_();
            int count = stack.m_41613_();
            if (!data.syncNbt()) {
                if (unique.put(item, Set.of()) != null) {
                    ((ItemStack)merged.get(item)).m_41769_(count);
                    continue;
                }
                merged.put(item, stack.m_41777_());
                continue;
            }
            CompoundTag nbt = stack.m_41783_();
            if (nbt == null) {
                nbt = EMPTY;
            }
            if (unique.computeIfAbsent(item, i -> new HashSet()).add(nbt)) {
                merged.put(new ItemWithNbt(item, nbt), stack.m_41777_());
                continue;
            }
            ((ItemStack)merged.get(new ItemWithNbt(item, nbt))).m_41769_(count);
        }
        if (merged.isEmpty()) {
            return;
        }
        Stream<Object> stream = merged.values().stream();
        if (config.getBoolean(ItemData.CONFIG_SORT_BY_COUNT)) {
            stream = stream.sorted(Comparator.comparingInt(ItemStack::m_41613_).reversed());
        }
        List<ItemStack> list = stream.toList();
        int maxHeight = config.getInt(ItemData.CONFIG_MAX_HEIGHT);
        this.lastItemsComponent = switch ((ItemData.ItemDisplayMode)((Object)config.getEnum(ItemData.CONFIG_DISPLAY_MODE))) {
            default -> throw new IncompatibleClassChangeError();
            case ItemData.ItemDisplayMode.DYNAMIC -> {
                if (list.size() <= maxHeight) {
                    yield new NamedItemListComponent(list, maxHeight);
                }
                yield new ItemListComponent(list, maxHeight);
            }
            case ItemData.ItemDisplayMode.GRID -> new ItemListComponent(list, maxHeight);
            case ItemData.ItemDisplayMode.LIST -> new NamedItemListComponent(list, maxHeight);
        };
        tooltip.setLine(ItemData.ID, this.lastItemsComponent);
    }

    private record ItemWithNbt(Item item, CompoundTag tag) {
    }
}

