/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.plugin.harvest.tool;

import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Supplier;
import mcp.mobius.waila.api.__internal__.IApiService;
import mcp.mobius.waila.api.__internal__.Internals;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.Nullable;

public final class ToolTier {
    public static final ToolTier NONE = Internals.unsafeAlloc(ToolTier.class);
    private static final Supplier<Map<Tier, ToolTier>> TIERS = Suppliers.memoize(() -> {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        List<Tier> tiers = IApiService.INSTANCE.getTiers();
        for (int i = 0; i < tiers.size(); ++i) {
            Tier tier = tiers.get(i);
            builder.put((Object)tier, (Object)new ToolTier(tier, i));
        }
        return builder.build();
    });
    private static final Supplier<Map<ResourceLocation, String>> VANILLA_TIER_TL_KEYS = Suppliers.memoize(() -> {
        HashMap<ResourceLocation, String> map = new HashMap<ResourceLocation, String>();
        for (Tiers tier : Tiers.values()) {
            TagKey<Block> tag = IApiService.INSTANCE.getTierTag((Tier)tier);
            if (tag == null) continue;
            map.put(tag.f_203868_(), tier.name().toLowerCase(Locale.ROOT));
        }
        return map;
    });
    public final Tier tier;
    public final int index;
    @Nullable
    public final TagKey<Block> tag;
    private final Supplier<String> tlKey;

    public ToolTier(Tier tier, int index) {
        this.tier = tier;
        this.index = index;
        this.tag = IApiService.INSTANCE.getTierTag(tier);
        this.tlKey = Suppliers.memoize(() -> {
            String vanilla;
            String key = this.tag != null ? ((vanilla = VANILLA_TIER_TL_KEYS.get().get(this.tag.f_203868_())) != null ? vanilla : this.tag.f_203868_().m_214298_()) : String.valueOf(tier.m_6604_());
            return "tooltip.waila.harvest.tier." + key;
        });
    }

    public static Collection<ToolTier> all() {
        return TIERS.get().values();
    }

    @Nullable
    public static ToolTier get(Tier tier) {
        return TIERS.get().get(tier);
    }

    public String tlKey() {
        return this.tlKey.get();
    }

    public boolean isEqualTo(ToolTier other) {
        if (this == other) {
            return true;
        }
        if (this.tier == other.tier) {
            return true;
        }
        if (this.tag != null && other.tag != null) {
            return this.tag.f_203868_().equals((Object)other.tag.f_203868_());
        }
        return false;
    }

    public boolean isBetterThanOrEqualTo(ToolTier other) {
        return this.isEqualTo(other) || this.index >= other.index;
    }
}

