/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.plugin.vanilla.provider;

import it.unimi.dsi.fastutil.objects.Object2IntLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import mcp.mobius.waila.api.IBlockAccessor;
import mcp.mobius.waila.api.IBlockComponentProvider;
import mcp.mobius.waila.api.IData;
import mcp.mobius.waila.api.IDataProvider;
import mcp.mobius.waila.api.IDataWriter;
import mcp.mobius.waila.api.IPluginConfig;
import mcp.mobius.waila.api.IServerAccessor;
import mcp.mobius.waila.api.ITooltip;
import mcp.mobius.waila.api.component.PairComponent;
import mcp.mobius.waila.mixin.BeehiveBlockEntity$BeeDataAccess;
import mcp.mobius.waila.mixin.BeehiveBlockEntityAccess;
import mcp.mobius.waila.plugin.vanilla.config.Options;
import net.minecraft.core.IdMap;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.block.BeehiveBlock;
import net.minecraft.world.level.block.entity.BeehiveBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

public enum BeehiveProvider implements IBlockComponentProvider,
IDataProvider<BeehiveBlockEntity>
{
    INSTANCE;

    public static final ResourceLocation OCCUPANTS_DATA;

    @Override
    public void appendBody(ITooltip tooltip, IBlockAccessor accessor, IPluginConfig config) {
        OccupantsData occupants = accessor.getData().get(OccupantsData.class);
        if (occupants != null && config.getBoolean(Options.BEE_HIVE_OCCUPANTS)) {
            Object2IntLinkedOpenHashMap names = new Object2IntLinkedOpenHashMap(occupants.occupants.size());
            for (OccupantsData.Occupant occupant : occupants.occupants) {
                MutableComponent component = null;
                if (occupant.customName != null) {
                    component = Component.Serializer.m_130701_((String)occupant.customName);
                }
                if (component == null) {
                    component = occupant.entityType.m_20676_();
                }
                String name = component.getString();
                names.put((Object)name, names.getOrDefault((Object)name, 0) + 1);
            }
            for (Object2IntMap.Entry entry : names.object2IntEntrySet()) {
                String name = (String)entry.getKey();
                int count = entry.getIntValue();
                if (count > 1) {
                    tooltip.addLine((Component)Component.m_237113_((String)(count + " " + name)));
                    continue;
                }
                tooltip.addLine((Component)Component.m_237113_((String)name));
            }
        }
        if (config.getBoolean(Options.BEE_HIVE_HONEY_LEVEL)) {
            BlockState state = accessor.getBlockState();
            tooltip.addLine(new PairComponent((Component)Component.m_237115_((String)"tooltip.waila.honey_level"), (Component)Component.m_237113_((String)((Integer)state.m_61143_((Property)BeehiveBlock.f_49564_)).toString())));
        }
    }

    @Override
    public void appendData(IDataWriter data, IServerAccessor<BeehiveBlockEntity> accessor, IPluginConfig config) {
        List<BeehiveBlockEntity$BeeDataAccess> stored;
        if (config.getBoolean(Options.BEE_HIVE_OCCUPANTS) && !(stored = ((BeehiveBlockEntityAccess)accessor.getTarget()).wthit_stored()).isEmpty()) {
            ArrayList<OccupantsData.Occupant> occupants = new ArrayList<OccupantsData.Occupant>(stored.size());
            for (BeehiveBlockEntity$BeeDataAccess beeData : stored) {
                CompoundTag beeNbt = beeData.wthit_entityData();
                Optional entityType = EntityType.m_20637_((CompoundTag)beeNbt);
                if (entityType.isEmpty()) continue;
                String customName = beeNbt.m_128425_("CustomName", 8) ? beeNbt.m_128461_("CustomName") : null;
                occupants.add(new OccupantsData.Occupant((EntityType)entityType.get(), customName));
            }
            if (!occupants.isEmpty()) {
                data.addImmediate(new OccupantsData(occupants));
            }
        }
    }

    static {
        OCCUPANTS_DATA = new ResourceLocation("bee.occupants");
    }

    public record OccupantsData(List<Occupant> occupants) implements IData
    {
        public OccupantsData(FriendlyByteBuf buf) {
            this(buf.m_236845_(b -> new Occupant((EntityType)b.m_236816_((IdMap)BuiltInRegistries.f_256780_), (String)b.m_236868_(FriendlyByteBuf::m_130277_))));
        }

        @Override
        public void write(FriendlyByteBuf buf) {
            buf.m_236828_(this.occupants, (b, occupant) -> {
                b.m_236818_((IdMap)BuiltInRegistries.f_256780_, occupant.entityType);
                b.m_236821_((Object)occupant.customName, FriendlyByteBuf::m_130070_);
            });
        }

        public record Occupant(EntityType<?> entityType, @Nullable String customName) {
        }
    }
}

