/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.plugin.vanilla.provider;

import java.text.DecimalFormat;
import mcp.mobius.waila.api.IEntityAccessor;
import mcp.mobius.waila.api.IEntityComponentProvider;
import mcp.mobius.waila.api.IPluginConfig;
import mcp.mobius.waila.api.ITooltip;
import mcp.mobius.waila.api.component.PairComponent;
import mcp.mobius.waila.plugin.vanilla.config.Options;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.horse.AbstractHorse;

public enum HorseProvider implements IEntityComponentProvider
{
    INSTANCE;

    private static final DecimalFormat FORMAT;
    private static final Component JUMP_KEY;
    private static final Component SPEED_KEY;

    @Override
    public void appendBody(ITooltip tooltip, IEntityAccessor accessor, IPluginConfig config) {
        AbstractHorse horse;
        if (config.getBoolean(Options.HORSE_JUMP_HEIGHT)) {
            horse = (AbstractHorse)accessor.getEntity();
            double jumpStrength = horse.m_30626_();
            double jumpHeight = (double)-0.1817585f * Math.pow(jumpStrength, 3.0) + 3.689713954925537 * Math.pow(jumpStrength, 2.0) + 2.128599166870117 * jumpStrength - 0.34393036365509033;
            ChatFormatting format = jumpHeight < 2.0 ? ChatFormatting.DARK_GRAY : (jumpHeight > 4.0 ? ChatFormatting.GOLD : ChatFormatting.RESET);
            tooltip.addLine(new PairComponent(JUMP_KEY, (Component)Component.m_237110_((String)"tooltip.waila.horse.jump.value", (Object[])new Object[]{FORMAT.format(jumpHeight)}).m_130940_(format)));
        }
        if (config.getBoolean(Options.HORSE_SPEED)) {
            horse = (AbstractHorse)accessor.getEntity();
            double speed = horse.m_21172_(Attributes.f_22279_) * 42.15778732299805;
            ChatFormatting format = speed < 7.0 ? ChatFormatting.DARK_GRAY : (speed > 11.0 ? ChatFormatting.GOLD : ChatFormatting.RESET);
            tooltip.addLine(new PairComponent(SPEED_KEY, (Component)Component.m_237110_((String)"tooltip.waila.horse.speed.value", (Object[])new Object[]{FORMAT.format(speed)}).m_130940_(format)));
        }
    }

    static {
        FORMAT = new DecimalFormat("#.##");
        JUMP_KEY = Component.m_237115_((String)"tooltip.waila.horse.jump.key");
        SPEED_KEY = Component.m_237115_((String)"tooltip.waila.horse.speed.key");
    }
}

