/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.registry;

import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import mcp.mobius.waila.api.IRegistryFilter;
import mcp.mobius.waila.util.Log;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import org.jetbrains.annotations.Nullable;

public class RegistryFilter<T>
implements IRegistryFilter<T> {
    public static final ThreadLocal<@Nullable RegistryAccess> REGISTRY = ThreadLocal.withInitial(() -> null);
    public static final Set<RegistryFilter<?>> INSTANCES = Collections.newSetFromMap(Collections.synchronizedMap(new WeakHashMap()));
    private static final Log LOG = Log.create();
    private final ResourceKey<? extends Registry<T>> registryKey;
    private final Set<Rule<T>> rules;
    private final ThreadLocal<@Nullable Registry<T>> registry = ThreadLocal.withInitial(() -> null);
    private final ThreadLocal<Set<T>> entries = ThreadLocal.withInitial(Set::of);
    private final ThreadLocal<Boolean> loaded = ThreadLocal.withInitial(() -> true);

    private RegistryFilter(ResourceKey<? extends Registry<T>> registry, Set<Rule<T>> rules) {
        this.registryKey = registry;
        this.rules = rules;
        INSTANCES.add(this);
        this.attach();
    }

    public static void attach(@Nullable RegistryAccess registryAccess) {
        REGISTRY.set(registryAccess);
        INSTANCES.forEach(RegistryFilter::attach);
    }

    public void attach() {
        RegistryAccess access = REGISTRY.get();
        this.registry.set(access == null ? null : access.m_175515_(this.registryKey));
        this.entries.set(Set.of());
        this.loaded.set(false);
    }

    private void load() {
        if (this.loaded.get().booleanValue()) {
            return;
        }
        Registry registry = this.registry.get();
        if (registry == null) {
            return;
        }
        Stopwatch stopwatch = null;
        if (LOG.isDebugEnabled()) {
            stopwatch = Stopwatch.createStarted();
            LOG.debug("Attaching registry to filter, id: {}", this.hashCode());
        }
        HashSet entries = new HashSet(this.entries.get().size());
        this.rules.forEach(rule -> registry.m_203611_().forEach(holder -> {
            if (rule.predicate.test((Holder.Reference<Holder.Reference>)holder)) {
                if (rule.negate) {
                    entries.remove(holder.m_203334_());
                } else {
                    entries.add(holder.m_203334_());
                }
            }
        }));
        this.entries.set(Collections.unmodifiableSet(entries));
        if (stopwatch != null) {
            LOG.debug("Finished in {}ms, {} entries matched", stopwatch.elapsed(TimeUnit.MILLISECONDS), entries.size());
            entries.stream().map(it -> Objects.requireNonNull(registry.m_7981_(it)).toString()).sorted().forEach(it -> LOG.debug("\t{}", it));
        }
        this.loaded.set(true);
    }

    @Override
    public Collection<T> getMatches() {
        this.load();
        return this.entries.get();
    }

    @Override
    public boolean matches(T object) {
        this.load();
        return this.entries.get().contains(object);
    }

    private record Rule<T>(boolean negate, Predicate<Holder.Reference<T>> predicate) {
    }

    public static class Builder<T>
    implements IRegistryFilter.Builder<T> {
        private final ResourceKey<? extends Registry<T>> registryKey;
        private final Set<Rule<T>> rules;
        @Nullable
        private final Stopwatch stopwatch;

        public Builder(ResourceKey<? extends Registry<T>> registryKey) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Start filter for {}", registryKey.m_135782_());
                this.stopwatch = Stopwatch.createStarted();
            } else {
                this.stopwatch = null;
            }
            this.registryKey = registryKey;
            this.rules = new LinkedHashSet<Rule<T>>();
        }

        @Override
        public IRegistryFilter.Builder<T> parse(String rule) {
            if (rule.charAt(0) == '!') {
                this.parse0(rule.substring(1), true);
            } else {
                this.parse0(rule, false);
            }
            return this;
        }

        private void parse0(String rule, boolean negate) {
            switch (rule.charAt(0)) {
                case '@': {
                    LOG.debug("\tNegate: {}, Namespace: {}", negate, rule);
                    String namespace = rule.substring(1);
                    this.rules.add(new Rule(negate, it -> it.m_205785_().m_135782_().m_135827_().equals(namespace)));
                    break;
                }
                case '#': {
                    LOG.debug("\tNegate: {}, Tag      : {}", negate, rule);
                    ResourceLocation tagId = new ResourceLocation(rule.substring(1));
                    TagKey tag = TagKey.m_203882_(this.registryKey, (ResourceLocation)tagId);
                    this.rules.add(new Rule(negate, it -> it.m_203656_(tag)));
                    break;
                }
                case '/': {
                    LOG.debug("\tNegate: {}, Regex    : {}", negate, rule);
                    Preconditions.checkArgument((boolean)rule.endsWith("/"), (Object)"Regex filter must also ends with /");
                    Pattern pattern = Pattern.compile(rule.substring(1, rule.length() - 1));
                    this.rules.add(new Rule(negate, it -> pattern.matcher(it.m_205785_().m_135782_().toString()).matches()));
                    break;
                }
                default: {
                    LOG.debug("\tNegate: {}, ID       : {}", negate, rule);
                    this.rules.add(new Rule(negate, it -> it.m_203373_(new ResourceLocation(rule))));
                }
            }
        }

        @Override
        public IRegistryFilter.Builder<T> parse(Iterable<String> rules) {
            rules.forEach(this::parse);
            return this;
        }

        @Override
        public IRegistryFilter.Builder<T> parse(String ... rules) {
            for (String filter : rules) {
                this.parse(filter);
            }
            return this;
        }

        @Override
        public IRegistryFilter<T> build() {
            RegistryFilter<T> res = new RegistryFilter<T>(this.registryKey, this.rules);
            if (this.stopwatch != null) {
                LOG.debug("Finished in {}ms, id: {}", this.stopwatch.elapsed(TimeUnit.MILLISECONDS), res.hashCode());
            }
            return res;
        }
    }
}

