/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.util;

import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.IllegalFormatException;
import java.util.Random;
import mcp.mobius.waila.WailaClient;
import mcp.mobius.waila.api.ITooltipComponent;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;
import org.joml.Matrix4f;

public final class DisplayUtil {
    private static final Random RANDOM = new Random();
    private static final Minecraft CLIENT = Minecraft.m_91087_();

    public static void enable3DRender() {
        Lighting.m_84931_();
        RenderSystem.enableDepthTest();
    }

    public static void enable2DRender() {
        Lighting.m_84930_();
        RenderSystem.disableDepthTest();
    }

    public static void renderRectBorder(Matrix4f matrix, BufferBuilder buf, int x, int y, int w, int h, int s, int gradStart, int gradEnd) {
        if (s <= 0) {
            return;
        }
        DisplayUtil.fillGradient(matrix, buf, x, y, w, s, gradStart, gradStart);
        DisplayUtil.fillGradient(matrix, buf, x, y + h - s, w, s, gradEnd, gradEnd);
        DisplayUtil.fillGradient(matrix, buf, x, y + s, s, h - s * 2, gradStart, gradEnd);
        DisplayUtil.fillGradient(matrix, buf, x + w - s, y + s, s, h - s * 2, gradStart, gradEnd);
    }

    public static void renderComponent(GuiGraphics ctx, ITooltipComponent component, int x, int y, int cw, float delta) {
        component.render(ctx, x, y, delta);
        if (WailaClient.showComponentBounds) {
            ctx.m_280168_().m_85836_();
            float scale = (float)Minecraft.m_91087_().m_91268_().m_85449_();
            ctx.m_280168_().m_85841_(1.0f / scale, 1.0f / scale, 1.0f);
            RenderSystem.setShader(GameRenderer::m_172811_);
            Tesselator tesselator = Tesselator.m_85913_();
            BufferBuilder buf = tesselator.m_85915_();
            buf.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
            int bx = Mth.m_14107_((double)((double)((float)x * scale) + 0.5));
            int by = Mth.m_14107_((double)((double)((float)y * scale) + 0.5));
            int bw = Mth.m_14107_((double)((double)((float)(cw == 0 ? component.getWidth() : cw) * scale) + 0.5));
            int bh = Mth.m_14107_((double)((double)((float)component.getHeight() * scale) + 0.5));
            int color = -16777216 + Mth.m_14169_((float)RANDOM.nextFloat(), (float)RANDOM.nextFloat(), (float)1.0f);
            DisplayUtil.renderRectBorder(ctx.m_280168_().m_85850_().m_252922_(), buf, bx, by, bw, bh, 1, color, color);
            tesselator.m_85914_();
            ctx.m_280168_().m_85849_();
        }
    }

    public static void fillGradient(Matrix4f matrix, BufferBuilder buf, int x, int y, int w, int h, int start, int end) {
        float sa = (float)FastColor.ARGB32.m_13655_((int)start) / 255.0f;
        float sr = (float)FastColor.ARGB32.m_13665_((int)start) / 255.0f;
        float sg = (float)FastColor.ARGB32.m_13667_((int)start) / 255.0f;
        float sb = (float)FastColor.ARGB32.m_13669_((int)start) / 255.0f;
        float ea = (float)FastColor.ARGB32.m_13655_((int)end) / 255.0f;
        float er = (float)FastColor.ARGB32.m_13665_((int)end) / 255.0f;
        float eg = (float)FastColor.ARGB32.m_13667_((int)end) / 255.0f;
        float eb = (float)FastColor.ARGB32.m_13669_((int)end) / 255.0f;
        buf.m_252986_(matrix, (float)x, (float)y, 0.0f).m_85950_(sr, sg, sb, sa).m_5752_();
        buf.m_252986_(matrix, (float)x, (float)(y + h), 0.0f).m_85950_(er, eg, eb, ea).m_5752_();
        buf.m_252986_(matrix, (float)(x + w), (float)(y + h), 0.0f).m_85950_(er, eg, eb, ea).m_5752_();
        buf.m_252986_(matrix, (float)(x + w), (float)y, 0.0f).m_85950_(sr, sg, sb, sa).m_5752_();
    }

    public static int getAlphaFromPercentage(int percentage) {
        return percentage == 100 ? -16777216 : (percentage == 0 ? 0x1000000 : (int)((float)percentage / 100.0f * 256.0f) << 24);
    }

    public static String tryFormat(String format, Object ... args) {
        try {
            return format.formatted(args);
        }
        catch (IllegalFormatException e) {
            return "FORMATTING ERROR";
        }
    }

    public static Button createButton(int x, int y, int width, int height, Component label, Button.OnPress pressAction) {
        return Button.m_253074_((Component)label, (Button.OnPress)pressAction).m_252987_(x, y, width, height).m_253136_();
    }
}

