/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions;

import com.simibubi.create.AllBlockEntityTypes;
import com.simibubi.create.AllTags;
import com.simibubi.create.content.kinetics.crafter.MechanicalCrafterBlockEntity;
import com.simibubi.create.content.logistics.crate.BottomlessItemHandler;
import com.simibubi.create.content.logistics.vault.ItemVaultBlockEntity;
import com.simibubi.create.content.processing.recipe.ProcessingInventory;
import com.simibubi.create.foundation.utility.NBTHelper;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BarrelBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.entity.ShulkerBoxBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.registries.ForgeRegistries;

public class MountedStorage {
    private static final ItemStackHandler dummyHandler = new ItemStackHandler();
    ItemStackHandler handler;
    boolean noFuel;
    boolean valid;
    private BlockEntity blockEntity;

    public static boolean canUseAsStorage(BlockEntity be) {
        if (be == null) {
            return false;
        }
        if (be instanceof MechanicalCrafterBlockEntity) {
            return false;
        }
        if (AllBlockEntityTypes.CREATIVE_CRATE.is(be)) {
            return true;
        }
        if (be instanceof ShulkerBoxBlockEntity) {
            return true;
        }
        if (be instanceof ChestBlockEntity) {
            return true;
        }
        if (be instanceof BarrelBlockEntity) {
            return true;
        }
        if (be instanceof ItemVaultBlockEntity) {
            return true;
        }
        try {
            LazyOptional capability = be.getCapability(ForgeCapabilities.ITEM_HANDLER);
            IItemHandler handler = (IItemHandler)capability.orElse(null);
            if (handler instanceof ItemStackHandler) {
                return !(handler instanceof ProcessingInventory);
            }
            return MountedStorage.canUseModdedInventory(be, handler);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean canUseModdedInventory(BlockEntity be, IItemHandler handler) {
        if (!(handler instanceof IItemHandlerModifiable)) {
            return false;
        }
        IItemHandlerModifiable validItemHandler = (IItemHandlerModifiable)handler;
        BlockState blockState = be.m_58900_();
        if (AllTags.AllBlockTags.CONTRAPTION_INVENTORY_DENY.matches(blockState)) {
            return false;
        }
        String blockId = ForgeRegistries.BLOCKS.getKey((Object)blockState.m_60734_()).m_135815_();
        if (blockId.contains("ender")) {
            return false;
        }
        return blockId.endsWith("_chest") || blockId.endsWith("_barrel");
    }

    public MountedStorage(BlockEntity be) {
        this.blockEntity = be;
        this.handler = dummyHandler;
        this.noFuel = be instanceof ItemVaultBlockEntity;
    }

    public void removeStorageFromWorld() {
        this.valid = false;
        if (this.blockEntity == null) {
            return;
        }
        if (this.blockEntity instanceof ChestBlockEntity) {
            CompoundTag tag = this.blockEntity.m_187480_();
            if (tag.m_128425_("LootTable", 8)) {
                return;
            }
            this.handler = new ItemStackHandler(((ChestBlockEntity)this.blockEntity).m_6643_());
            NonNullList items = NonNullList.m_122780_((int)this.handler.getSlots(), (Object)ItemStack.f_41583_);
            ContainerHelper.m_18980_((CompoundTag)tag, (NonNullList)items);
            for (int i = 0; i < items.size(); ++i) {
                this.handler.setStackInSlot(i, (ItemStack)items.get(i));
            }
            this.valid = true;
            return;
        }
        IItemHandler beHandler = (IItemHandler)this.blockEntity.getCapability(ForgeCapabilities.ITEM_HANDLER).orElse((Object)dummyHandler);
        if (beHandler == dummyHandler) {
            return;
        }
        if (this.blockEntity instanceof ItemVaultBlockEntity) {
            this.handler = ((ItemVaultBlockEntity)this.blockEntity).getInventoryOfBlock();
            this.valid = true;
            return;
        }
        if (beHandler instanceof ItemStackHandler) {
            this.handler = (ItemStackHandler)beHandler;
            this.valid = true;
            return;
        }
        if (beHandler instanceof IItemHandlerModifiable) {
            IItemHandlerModifiable inv = (IItemHandlerModifiable)beHandler;
            this.handler = new ItemStackHandler(beHandler.getSlots());
            for (int slot = 0; slot < this.handler.getSlots(); ++slot) {
                this.handler.setStackInSlot(slot, inv.getStackInSlot(slot));
                inv.setStackInSlot(slot, ItemStack.f_41583_);
            }
            this.valid = true;
            return;
        }
    }

    public void addStorageToWorld(BlockEntity be) {
        if (this.handler instanceof BottomlessItemHandler) {
            return;
        }
        if (be instanceof ChestBlockEntity) {
            CompoundTag tag = be.m_187480_();
            tag.m_128473_("Items");
            NonNullList items = NonNullList.m_122780_((int)this.handler.getSlots(), (Object)ItemStack.f_41583_);
            for (int i = 0; i < items.size(); ++i) {
                items.set(i, (Object)this.handler.getStackInSlot(i));
            }
            ContainerHelper.m_18973_((CompoundTag)tag, (NonNullList)items);
            be.m_142466_(tag);
            return;
        }
        if (be instanceof ItemVaultBlockEntity) {
            ((ItemVaultBlockEntity)be).applyInventoryToBlock(this.handler);
            return;
        }
        LazyOptional capability = be.getCapability(ForgeCapabilities.ITEM_HANDLER);
        IItemHandler teHandler = (IItemHandler)capability.orElse(null);
        if (!(teHandler instanceof IItemHandlerModifiable)) {
            return;
        }
        IItemHandlerModifiable inv = (IItemHandlerModifiable)teHandler;
        for (int slot = 0; slot < Math.min(inv.getSlots(), this.handler.getSlots()); ++slot) {
            inv.setStackInSlot(slot, this.handler.getStackInSlot(slot));
        }
    }

    public IItemHandlerModifiable getItemHandler() {
        return this.handler;
    }

    public CompoundTag serialize() {
        if (!this.valid) {
            return null;
        }
        CompoundTag tag = this.handler.serializeNBT();
        if (this.noFuel) {
            NBTHelper.putMarker(tag, "NoFuel");
        }
        if (!(this.handler instanceof BottomlessItemHandler)) {
            return tag;
        }
        NBTHelper.putMarker(tag, "Bottomless");
        tag.m_128365_("ProvidedStack", (Tag)this.handler.getStackInSlot(0).serializeNBT());
        return tag;
    }

    public static MountedStorage deserialize(CompoundTag nbt) {
        MountedStorage storage = new MountedStorage(null);
        storage.handler = new ItemStackHandler();
        if (nbt == null) {
            return storage;
        }
        storage.valid = true;
        storage.noFuel = nbt.m_128441_("NoFuel");
        if (nbt.m_128441_("Bottomless")) {
            ItemStack providedStack = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("ProvidedStack"));
            storage.handler = new BottomlessItemHandler(() -> providedStack);
            return storage;
        }
        storage.handler.deserializeNBT(nbt);
        return storage;
    }

    public boolean isValid() {
        return this.valid;
    }

    public boolean canUseForFuel() {
        return !this.noFuel;
    }
}

