/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.content.contraptions.AbstractContraptionEntity;
import com.simibubi.create.foundation.utility.AnimationTickHolder;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import org.joml.Matrix3fc;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;

public class ContraptionMatrices {
    private final PoseStack modelViewProjection = new PoseStack();
    private final PoseStack viewProjection = new PoseStack();
    private final PoseStack model = new PoseStack();
    private final Matrix4f world = new Matrix4f();
    private final Matrix4f light = new Matrix4f();
    private boolean ready;

    public void setup(PoseStack viewProjection, AbstractContraptionEntity entity) {
        float partialTicks = AnimationTickHolder.getPartialTicks();
        this.viewProjection.m_85836_();
        ContraptionMatrices.transform(this.viewProjection, viewProjection);
        this.model.m_85836_();
        entity.applyLocalTransforms(this.model, partialTicks);
        this.modelViewProjection.m_85836_();
        ContraptionMatrices.transform(this.modelViewProjection, viewProjection);
        ContraptionMatrices.transform(this.modelViewProjection, this.model);
        ContraptionMatrices.translateToEntity(this.world, entity, partialTicks);
        this.light.set((Matrix4fc)this.world);
        this.light.mul((Matrix4fc)this.model.m_85850_().m_252922_());
        this.ready = true;
    }

    public void clear() {
        ContraptionMatrices.clearStack(this.modelViewProjection);
        ContraptionMatrices.clearStack(this.viewProjection);
        ContraptionMatrices.clearStack(this.model);
        this.world.identity();
        this.light.identity();
        this.ready = false;
    }

    public PoseStack getModelViewProjection() {
        return this.modelViewProjection;
    }

    public PoseStack getViewProjection() {
        return this.viewProjection;
    }

    public PoseStack getModel() {
        return this.model;
    }

    public Matrix4f getWorld() {
        return this.world;
    }

    public Matrix4f getLight() {
        return this.light;
    }

    public boolean isReady() {
        return this.ready;
    }

    public static void transform(PoseStack ms, PoseStack transform) {
        ms.m_85850_().m_252922_().mul((Matrix4fc)transform.m_85850_().m_252922_());
        ms.m_85850_().m_252943_().mul((Matrix3fc)transform.m_85850_().m_252943_());
    }

    public static void translateToEntity(Matrix4f matrix, Entity entity, float partialTicks) {
        double x = Mth.m_14139_((double)partialTicks, (double)entity.f_19790_, (double)entity.m_20185_());
        double y = Mth.m_14139_((double)partialTicks, (double)entity.f_19791_, (double)entity.m_20186_());
        double z = Mth.m_14139_((double)partialTicks, (double)entity.f_19792_, (double)entity.m_20189_());
        matrix.setTranslation((float)x, (float)y, (float)z);
    }

    public static void clearStack(PoseStack ms) {
        while (!ms.m_85851_()) {
            ms.m_85849_();
        }
    }
}

