/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.kinetics.deployer;

import com.jozufozu.flywheel.core.PartialModel;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllPartialModels;
import com.simibubi.create.AllRecipeTypes;
import com.simibubi.create.content.equipment.sandPaper.SandPaperItem;
import com.simibubi.create.content.equipment.sandPaper.SandPaperPolishingRecipe;
import com.simibubi.create.content.kinetics.base.DirectionalKineticBlock;
import com.simibubi.create.content.kinetics.base.IRotate;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.belt.behaviour.BeltProcessingBehaviour;
import com.simibubi.create.content.kinetics.belt.behaviour.TransportedItemStackHandlerBehaviour;
import com.simibubi.create.content.kinetics.deployer.BeltDeployerCallbacks;
import com.simibubi.create.content.kinetics.deployer.DeployerApplicationRecipe;
import com.simibubi.create.content.kinetics.deployer.DeployerFakePlayer;
import com.simibubi.create.content.kinetics.deployer.DeployerFilterSlot;
import com.simibubi.create.content.kinetics.deployer.DeployerHandler;
import com.simibubi.create.content.kinetics.deployer.DeployerItemHandler;
import com.simibubi.create.content.kinetics.deployer.DeployerRecipeSearchEvent;
import com.simibubi.create.content.processing.sequenced.SequencedAssemblyRecipe;
import com.simibubi.create.foundation.advancement.AllAdvancements;
import com.simibubi.create.foundation.blockEntity.SyncedBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.filtering.FilteringBehaviour;
import com.simibubi.create.foundation.item.TooltipHelper;
import com.simibubi.create.foundation.utility.Components;
import com.simibubi.create.foundation.utility.Lang;
import com.simibubi.create.foundation.utility.NBTHelper;
import com.simibubi.create.foundation.utility.VecHelper;
import com.simibubi.create.foundation.utility.animation.LerpedFloat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.RecipeWrapper;

public class DeployerBlockEntity
extends KineticBlockEntity {
    protected State state;
    protected Mode mode;
    protected ItemStack heldItem = ItemStack.f_41583_;
    protected DeployerFakePlayer player;
    protected int timer;
    protected float reach;
    protected boolean fistBump = false;
    protected List<ItemStack> overflowItems = new ArrayList<ItemStack>();
    protected FilteringBehaviour filtering;
    protected boolean redstoneLocked = false;
    protected UUID owner;
    private LazyOptional<IItemHandlerModifiable> invHandler;
    private ListTag deferredInventoryList;
    private LerpedFloat animatedOffset;
    public BeltProcessingBehaviour processingBehaviour;
    RecipeWrapper recipeInv = new RecipeWrapper((IItemHandlerModifiable)new ItemStackHandler(2));
    SandPaperPolishingRecipe.SandPaperInv sandpaperInv = new SandPaperPolishingRecipe.SandPaperInv(ItemStack.f_41583_);

    public DeployerBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.state = State.WAITING;
        this.mode = Mode.USE;
        this.heldItem = ItemStack.f_41583_;
        this.animatedOffset = LerpedFloat.linear().startWithValue(0.0);
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        super.addBehaviours(behaviours);
        this.filtering = new FilteringBehaviour(this, new DeployerFilterSlot());
        behaviours.add(this.filtering);
        this.processingBehaviour = new BeltProcessingBehaviour(this).whenItemEnters((s, i) -> BeltDeployerCallbacks.onItemReceived(s, i, this)).whileItemHeld((s, i) -> BeltDeployerCallbacks.whenItemHeld(s, i, this));
        behaviours.add(this.processingBehaviour);
        this.registerAwardables(behaviours, AllAdvancements.TRAIN_CASING, AllAdvancements.ANDESITE_CASING, AllAdvancements.BRASS_CASING, AllAdvancements.COPPER_CASING, AllAdvancements.FIST_BUMP, AllAdvancements.DEPLOYER, AllAdvancements.SELF_DEPLOYING);
    }

    @Override
    public void initialize() {
        super.initialize();
        this.initHandler();
    }

    private void initHandler() {
        if (this.invHandler != null) {
            return;
        }
        Level level = this.f_58857_;
        if (level instanceof ServerLevel) {
            ServerLevel sLevel = (ServerLevel)level;
            this.player = new DeployerFakePlayer(sLevel, this.owner);
            if (this.deferredInventoryList != null) {
                this.player.m_150109_().m_36035_(this.deferredInventoryList);
                this.deferredInventoryList = null;
                this.heldItem = this.player.m_21205_();
                this.sendData();
            }
            Vec3 initialPos = VecHelper.getCenterOf((Vec3i)this.f_58858_.m_121945_((Direction)this.m_58900_().m_61143_((Property)DirectionalKineticBlock.FACING)));
            this.player.m_6034_(initialPos.f_82479_, initialPos.f_82480_, initialPos.f_82481_);
        }
        this.invHandler = LazyOptional.of(this::createHandler);
    }

    protected void onExtract(ItemStack stack) {
        this.player.m_21008_(InteractionHand.MAIN_HAND, stack.m_41777_());
        this.sendData();
        this.m_6596_();
    }

    protected int getTimerSpeed() {
        return (int)(this.getSpeed() == 0.0f ? 0.0f : Mth.m_14036_((float)Math.abs(this.getSpeed() * 2.0f), (float)8.0f, (float)512.0f));
    }

    @Override
    public void tick() {
        super.tick();
        if (this.getSpeed() == 0.0f) {
            return;
        }
        if (!this.f_58857_.f_46443_ && this.player != null && this.player.blockBreakingProgress != null && this.f_58857_.m_46859_((BlockPos)this.player.blockBreakingProgress.getKey())) {
            this.f_58857_.m_6801_(this.player.m_19879_(), (BlockPos)this.player.blockBreakingProgress.getKey(), -1);
            this.player.blockBreakingProgress = null;
        }
        if (this.timer > 0) {
            this.timer -= this.getTimerSpeed();
            return;
        }
        if (this.f_58857_.f_46443_) {
            return;
        }
        ItemStack stack = this.player.m_21205_();
        if (this.state == State.WAITING) {
            if (!this.overflowItems.isEmpty()) {
                this.timer = this.getTimerSpeed() * 10;
                return;
            }
            boolean changed = false;
            Inventory inventory = this.player.m_150109_();
            for (int i = 0; i < inventory.m_6643_() && this.overflowItems.size() <= 10; ++i) {
                ItemStack item = inventory.m_8020_(i);
                if (item.m_41619_() || item == stack && this.filtering.test(item)) continue;
                this.overflowItems.add(item);
                inventory.m_6836_(i, ItemStack.f_41583_);
                changed = true;
            }
            if (changed) {
                this.sendData();
                this.timer = this.getTimerSpeed() * 10;
                return;
            }
            Direction facing = (Direction)this.m_58900_().m_61143_((Property)DirectionalKineticBlock.FACING);
            if (this.mode == Mode.USE && !DeployerHandler.shouldActivate(stack, this.f_58857_, this.f_58858_.m_5484_(facing, 2), facing)) {
                this.timer = this.getTimerSpeed() * 10;
                return;
            }
            if (this.mode == Mode.PUNCH && !this.fistBump && this.startFistBump(facing)) {
                return;
            }
            if (this.redstoneLocked) {
                return;
            }
            this.start();
            return;
        }
        if (this.state == State.EXPANDING) {
            if (this.fistBump) {
                this.triggerFistBump();
            }
            this.activate();
            this.state = State.RETRACTING;
            this.timer = 1000;
            this.sendData();
            return;
        }
        if (this.state == State.RETRACTING) {
            this.state = State.WAITING;
            this.timer = 500;
            this.sendData();
            return;
        }
    }

    protected void start() {
        this.state = State.EXPANDING;
        Vec3 movementVector = this.getMovementVector();
        Vec3 rayOrigin = VecHelper.getCenterOf((Vec3i)this.f_58858_).m_82549_(movementVector.m_82490_(1.5));
        Vec3 rayTarget = VecHelper.getCenterOf((Vec3i)this.f_58858_).m_82549_(movementVector.m_82490_(2.5));
        ClipContext rayTraceContext = new ClipContext(rayOrigin, rayTarget, ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)this.player);
        BlockHitResult result = this.f_58857_.m_45547_(rayTraceContext);
        this.reach = (float)(0.5 + Math.min(result.m_82450_().m_82546_(rayOrigin).m_82553_(), 0.75));
        this.timer = 1000;
        this.sendData();
    }

    public boolean startFistBump(Direction facing) {
        int i = 0;
        KineticBlockEntity partner = null;
        for (i = 2; i < 5; ++i) {
            BlockPos otherDeployer = this.f_58858_.m_5484_(facing, i);
            if (!this.f_58857_.m_46749_(otherDeployer)) {
                return false;
            }
            BlockEntity other = this.f_58857_.m_7702_(otherDeployer);
            if (!(other instanceof DeployerBlockEntity)) continue;
            DeployerBlockEntity dpe = (DeployerBlockEntity)other;
            partner = dpe;
            break;
        }
        if (partner == null) {
            return false;
        }
        if (((Direction)this.f_58857_.m_8055_(partner.m_58899_()).m_61143_((Property)DirectionalKineticBlock.FACING)).m_122424_() != facing || ((DeployerBlockEntity)partner).mode != Mode.PUNCH) {
            return false;
        }
        if (partner.getSpeed() == 0.0f) {
            return false;
        }
        for (DeployerBlockEntity be : Arrays.asList(this, partner)) {
            be.fistBump = true;
            be.reach = (float)(i - 2) * 0.5f;
            be.timer = 1000;
            be.state = State.EXPANDING;
            be.sendData();
        }
        return true;
    }

    public void triggerFistBump() {
        int i = 0;
        SyncedBlockEntity deployerBlockEntity = null;
        for (i = 2; i < 5; ++i) {
            BlockPos pos = this.f_58858_.m_5484_((Direction)this.m_58900_().m_61143_((Property)DirectionalKineticBlock.FACING), i);
            if (!this.f_58857_.m_46749_(pos)) {
                return;
            }
            BlockEntity blockEntity = this.f_58857_.m_7702_(pos);
            if (!(blockEntity instanceof DeployerBlockEntity)) continue;
            DeployerBlockEntity dpe = (DeployerBlockEntity)blockEntity;
            deployerBlockEntity = dpe;
            break;
        }
        if (deployerBlockEntity == null) {
            return;
        }
        if (!((DeployerBlockEntity)deployerBlockEntity).fistBump || ((DeployerBlockEntity)deployerBlockEntity).state != State.EXPANDING) {
            return;
        }
        if (((DeployerBlockEntity)deployerBlockEntity).timer > 0) {
            return;
        }
        this.fistBump = false;
        ((DeployerBlockEntity)deployerBlockEntity).fistBump = false;
        ((DeployerBlockEntity)deployerBlockEntity).state = State.RETRACTING;
        ((DeployerBlockEntity)deployerBlockEntity).timer = 1000;
        deployerBlockEntity.sendData();
        this.award(AllAdvancements.FIST_BUMP);
        BlockPos soundLocation = BlockPos.m_274446_((Position)Vec3.m_82512_((Vec3i)this.f_58858_).m_82549_(Vec3.m_82512_((Vec3i)deployerBlockEntity.m_58899_())).m_82490_(0.5));
        this.f_58857_.m_5594_(null, soundLocation, SoundEvents.f_12315_, SoundSource.BLOCKS, 0.75f, 0.75f);
    }

    protected void activate() {
        Vec3 movementVector = this.getMovementVector();
        Direction direction = (Direction)this.m_58900_().m_61143_((Property)DirectionalKineticBlock.FACING);
        Vec3 center = VecHelper.getCenterOf((Vec3i)this.f_58858_);
        BlockPos clickedPos = this.f_58858_.m_5484_(direction, 2);
        this.player.m_146926_(direction == Direction.UP ? -90.0f : (direction == Direction.DOWN ? 90.0f : 0.0f));
        this.player.m_146922_(direction.m_122435_());
        if (direction == Direction.DOWN && BlockEntityBehaviour.get((BlockGetter)this.f_58857_, clickedPos, TransportedItemStackHandlerBehaviour.TYPE) != null) {
            return;
        }
        DeployerHandler.activate(this.player, center, clickedPos, movementVector, this.mode);
        this.award(AllAdvancements.DEPLOYER);
        if (this.player != null) {
            this.heldItem = this.player.m_21205_();
        }
    }

    protected Vec3 getMovementVector() {
        if (!AllBlocks.DEPLOYER.has(this.m_58900_())) {
            return Vec3.f_82478_;
        }
        return Vec3.m_82528_((Vec3i)((Direction)this.m_58900_().m_61143_((Property)DirectionalKineticBlock.FACING)).m_122436_());
    }

    @Override
    protected void read(CompoundTag compound, boolean clientPacket) {
        this.state = NBTHelper.readEnum(compound, "State", State.class);
        this.mode = NBTHelper.readEnum(compound, "Mode", Mode.class);
        this.timer = compound.m_128451_("Timer");
        this.redstoneLocked = compound.m_128471_("Powered");
        if (compound.m_128441_("Owner")) {
            this.owner = compound.m_128342_("Owner");
        }
        this.deferredInventoryList = compound.m_128437_("Inventory", 10);
        this.overflowItems = NBTHelper.readItemList(compound.m_128437_("Overflow", 10));
        if (compound.m_128441_("HeldItem")) {
            this.heldItem = ItemStack.m_41712_((CompoundTag)compound.m_128469_("HeldItem"));
        }
        super.read(compound, clientPacket);
        if (!clientPacket) {
            return;
        }
        this.fistBump = compound.m_128471_("Fistbump");
        this.reach = compound.m_128457_("Reach");
        if (compound.m_128441_("Particle")) {
            ItemStack particleStack = ItemStack.m_41712_((CompoundTag)compound.m_128469_("Particle"));
            SandPaperItem.spawnParticles(VecHelper.getCenterOf((Vec3i)this.f_58858_).m_82549_(this.getMovementVector().m_82490_((double)(this.reach + 1.0f))), particleStack, this.f_58857_);
        }
    }

    @Override
    public void write(CompoundTag compound, boolean clientPacket) {
        NBTHelper.writeEnum(compound, "Mode", this.mode);
        NBTHelper.writeEnum(compound, "State", this.state);
        compound.m_128405_("Timer", this.timer);
        compound.m_128379_("Powered", this.redstoneLocked);
        if (this.owner != null) {
            compound.m_128362_("Owner", this.owner);
        }
        if (this.player != null) {
            ListTag invNBT = new ListTag();
            this.player.m_150109_().m_36026_(invNBT);
            compound.m_128365_("Inventory", (Tag)invNBT);
            compound.m_128365_("HeldItem", (Tag)this.player.m_21205_().serializeNBT());
            compound.m_128365_("Overflow", (Tag)NBTHelper.writeItemList(this.overflowItems));
        } else if (this.deferredInventoryList != null) {
            compound.m_128365_("Inventory", (Tag)this.deferredInventoryList);
        }
        super.write(compound, clientPacket);
        if (!clientPacket) {
            return;
        }
        compound.m_128379_("Fistbump", this.fistBump);
        compound.m_128350_("Reach", this.reach);
        if (this.player == null) {
            return;
        }
        compound.m_128365_("HeldItem", (Tag)this.player.m_21205_().serializeNBT());
        if (this.player.spawnedItemEffects != null) {
            compound.m_128365_("Particle", (Tag)this.player.spawnedItemEffects.serializeNBT());
            this.player.spawnedItemEffects = null;
        }
    }

    @Override
    public void writeSafe(CompoundTag tag) {
        NBTHelper.writeEnum(tag, "Mode", this.mode);
        super.writeSafe(tag);
    }

    private IItemHandlerModifiable createHandler() {
        return new DeployerItemHandler(this);
    }

    public void redstoneUpdate() {
        if (this.f_58857_.f_46443_) {
            return;
        }
        boolean blockPowered = this.f_58857_.m_276867_(this.f_58858_);
        if (blockPowered == this.redstoneLocked) {
            return;
        }
        this.redstoneLocked = blockPowered;
        this.sendData();
    }

    @OnlyIn(value=Dist.CLIENT)
    public PartialModel getHandPose() {
        return this.mode == Mode.PUNCH ? AllPartialModels.DEPLOYER_HAND_PUNCHING : (this.heldItem.m_41619_() ? AllPartialModels.DEPLOYER_HAND_POINTING : AllPartialModels.DEPLOYER_HAND_HOLDING);
    }

    @Override
    protected AABB createRenderBoundingBox() {
        return super.createRenderBoundingBox().m_82400_(3.0);
    }

    public void discardPlayer() {
        if (this.player == null) {
            return;
        }
        this.player.m_150109_().m_36071_();
        this.overflowItems.forEach(itemstack -> this.player.m_7197_((ItemStack)itemstack, true, false));
        this.player.m_146870_();
        this.player = null;
    }

    @Override
    public void invalidate() {
        super.invalidate();
        if (this.invHandler != null) {
            this.invHandler.invalidate();
        }
    }

    public void changeMode() {
        this.mode = this.mode == Mode.PUNCH ? Mode.USE : Mode.PUNCH;
        this.m_6596_();
        this.sendData();
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (this.isItemHandlerCap(cap)) {
            if (this.invHandler == null) {
                this.initHandler();
            }
            return this.invHandler.cast();
        }
        return super.getCapability(cap, side);
    }

    @Override
    public boolean addToTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        if (super.addToTooltip(tooltip, isPlayerSneaking)) {
            return true;
        }
        if (this.getSpeed() == 0.0f) {
            return false;
        }
        if (this.overflowItems.isEmpty()) {
            return false;
        }
        TooltipHelper.addHint(tooltip, "hint.full_deployer", new Object[0]);
        return true;
    }

    @Override
    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        Lang.translate("tooltip.deployer.header", new Object[0]).forGoggles(tooltip);
        Lang.translate("tooltip.deployer." + (this.mode == Mode.USE ? "using" : "punching"), new Object[0]).style(ChatFormatting.YELLOW).forGoggles(tooltip);
        if (!this.heldItem.m_41619_()) {
            Lang.translate("tooltip.deployer.contains", Components.translatable(this.heldItem.m_41778_()).getString(), this.heldItem.m_41613_()).style(ChatFormatting.GREEN).forGoggles(tooltip);
        }
        float stressAtBase = this.calculateStressApplied();
        if (IRotate.StressImpact.isEnabled() && !Mth.m_14033_((float)stressAtBase, (float)0.0f)) {
            tooltip.add(Components.immutableEmpty());
            this.addStressImpactStats(tooltip, stressAtBase);
        }
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getHandOffset(float partialTicks) {
        if (this.isVirtual()) {
            return this.animatedOffset.getValue(partialTicks);
        }
        float progress = 0.0f;
        int timerSpeed = this.getTimerSpeed();
        PartialModel handPose = this.getHandPose();
        if (this.state == State.EXPANDING) {
            progress = 1.0f - ((float)this.timer - partialTicks * (float)timerSpeed) / 1000.0f;
            if (this.fistBump) {
                progress *= progress;
            }
        }
        if (this.state == State.RETRACTING) {
            progress = ((float)this.timer - partialTicks * (float)timerSpeed) / 1000.0f;
        }
        float handLength = handPose == AllPartialModels.DEPLOYER_HAND_POINTING ? 0.0f : (handPose == AllPartialModels.DEPLOYER_HAND_HOLDING ? 0.25f : 0.1875f);
        float distance = Math.min(Mth.m_14036_((float)progress, (float)0.0f, (float)1.0f) * (this.reach + handLength), 1.3125f);
        return distance;
    }

    public void setAnimatedOffset(float offset) {
        this.animatedOffset.setValue(offset);
    }

    @Nullable
    public Recipe<? extends Container> getRecipe(ItemStack stack) {
        if (this.player == null || this.f_58857_ == null) {
            return null;
        }
        ItemStack heldItemMainhand = this.player.m_21205_();
        if (heldItemMainhand.m_41720_() instanceof SandPaperItem) {
            this.sandpaperInv.m_6836_(0, stack);
            return AllRecipeTypes.SANDPAPER_POLISHING.find(this.sandpaperInv, this.f_58857_).orElse(null);
        }
        this.recipeInv.m_6836_(0, stack);
        this.recipeInv.m_6836_(1, heldItemMainhand);
        DeployerRecipeSearchEvent event = new DeployerRecipeSearchEvent(this, this.recipeInv);
        event.addRecipe(() -> SequencedAssemblyRecipe.getRecipe(this.f_58857_, event.getInventory(), AllRecipeTypes.DEPLOYING.getType(), DeployerApplicationRecipe.class), 100);
        event.addRecipe(() -> AllRecipeTypes.DEPLOYING.find(event.getInventory(), this.f_58857_), 50);
        event.addRecipe(() -> AllRecipeTypes.ITEM_APPLICATION.find(event.getInventory(), this.f_58857_), 50);
        MinecraftForge.EVENT_BUS.post((Event)event);
        return event.getRecipe();
    }

    public DeployerFakePlayer getPlayer() {
        return this.player;
    }

    static enum State {
        WAITING,
        EXPANDING,
        RETRACTING,
        DUMPING;

    }

    static enum Mode {
        PUNCH,
        USE;

    }
}

