/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.kinetics.deployer;

import com.jozufozu.flywheel.backend.Backend;
import com.jozufozu.flywheel.core.PartialModel;
import com.jozufozu.flywheel.core.virtual.VirtualRenderWorld;
import com.jozufozu.flywheel.util.transform.TransformStack;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllPartialModels;
import com.simibubi.create.content.contraptions.behaviour.MovementContext;
import com.simibubi.create.content.contraptions.render.ContraptionMatrices;
import com.simibubi.create.content.contraptions.render.ContraptionRenderDispatcher;
import com.simibubi.create.content.kinetics.base.DirectionalAxisKineticBlock;
import com.simibubi.create.content.kinetics.base.DirectionalKineticBlock;
import com.simibubi.create.content.kinetics.base.IRotate;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.base.KineticBlockEntityRenderer;
import com.simibubi.create.content.kinetics.deployer.DeployerBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.filtering.FilteringRenderer;
import com.simibubi.create.foundation.blockEntity.renderer.SafeBlockEntityRenderer;
import com.simibubi.create.foundation.render.CachedBufferer;
import com.simibubi.create.foundation.render.SuperByteBuffer;
import com.simibubi.create.foundation.utility.AngleHelper;
import com.simibubi.create.foundation.utility.AnimationTickHolder;
import com.simibubi.create.foundation.utility.NBTHelper;
import com.simibubi.create.foundation.utility.VecHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;

public class DeployerRenderer
extends SafeBlockEntityRenderer<DeployerBlockEntity> {
    public DeployerRenderer(BlockEntityRendererProvider.Context context) {
    }

    @Override
    protected void renderSafe(DeployerBlockEntity be, float partialTicks, PoseStack ms, MultiBufferSource buffer, int light, int overlay) {
        this.renderItem(be, partialTicks, ms, buffer, light, overlay);
        FilteringRenderer.renderOnBlockEntity(be, partialTicks, ms, buffer, light, overlay);
        if (Backend.canUseInstancing((Level)be.m_58904_())) {
            return;
        }
        this.renderComponents(be, partialTicks, ms, buffer, light, overlay);
    }

    protected void renderItem(DeployerBlockEntity be, float partialTicks, PoseStack ms, MultiBufferSource buffer, int light, int overlay) {
        boolean isBlockItem;
        if (be.heldItem.m_41619_()) {
            return;
        }
        BlockState deployerState = be.m_58900_();
        Vec3 offset = this.getHandOffset(be, partialTicks, deployerState).m_82549_(VecHelper.getCenterOf((Vec3i)BlockPos.f_121853_));
        ms.m_85836_();
        ms.m_85837_(offset.f_82479_, offset.f_82480_, offset.f_82481_);
        Direction facing = (Direction)deployerState.m_61143_((Property)DirectionalKineticBlock.FACING);
        boolean punching = be.mode == DeployerBlockEntity.Mode.PUNCH;
        float yRot = AngleHelper.horizontalAngle(facing) + 180.0f;
        float xRot = facing == Direction.UP ? 90.0f : (facing == Direction.DOWN ? 270.0f : 0.0f);
        boolean displayMode = facing == Direction.UP && be.getSpeed() == 0.0f && !punching;
        ms.m_252781_(Axis.f_252436_.m_252977_(yRot));
        if (!displayMode) {
            ms.m_252781_(Axis.f_252529_.m_252977_(xRot));
            ms.m_252880_(0.0f, 0.0f, -0.6875f);
        }
        if (punching) {
            ms.m_252880_(0.0f, 0.125f, -0.0625f);
        }
        ItemRenderer itemRenderer = Minecraft.m_91087_().m_91291_();
        ItemDisplayContext transform = ItemDisplayContext.NONE;
        boolean bl = isBlockItem = be.heldItem.m_41720_() instanceof BlockItem && itemRenderer.m_174264_(be.heldItem, be.m_58904_(), null, 0).m_7539_();
        if (displayMode) {
            float scale = isBlockItem ? 1.25f : 1.0f;
            ms.m_252880_(0.0f, isBlockItem ? 0.5625f : 0.6875f, 0.0f);
            ms.m_85841_(scale, scale, scale);
            transform = ItemDisplayContext.GROUND;
            ms.m_252781_(Axis.f_252436_.m_252977_(AnimationTickHolder.getRenderTime((LevelAccessor)be.m_58904_())));
        } else {
            float scale = punching ? 0.75f : (isBlockItem ? 0.734375f : 0.5f);
            ms.m_85841_(scale, scale, scale);
            transform = punching ? ItemDisplayContext.THIRD_PERSON_RIGHT_HAND : ItemDisplayContext.FIXED;
        }
        itemRenderer.m_269128_(be.heldItem, transform, light, overlay, ms, buffer, be.m_58904_(), 0);
        ms.m_85849_();
    }

    protected void renderComponents(DeployerBlockEntity be, float partialTicks, PoseStack ms, MultiBufferSource buffer, int light, int overlay) {
        VertexConsumer vb = buffer.m_6299_(RenderType.m_110451_());
        if (!Backend.canUseInstancing((Level)be.m_58904_())) {
            KineticBlockEntityRenderer.renderRotatingKineticBlock(be, this.getRenderedBlockState(be), ms, vb, light);
        }
        BlockState blockState = be.m_58900_();
        Vec3 offset = this.getHandOffset(be, partialTicks, blockState);
        SuperByteBuffer pole = CachedBufferer.partial(AllPartialModels.DEPLOYER_POLE, blockState);
        SuperByteBuffer hand = CachedBufferer.partial(be.getHandPose(), blockState);
        DeployerRenderer.transform(pole.translate(offset.f_82479_, offset.f_82480_, offset.f_82481_), blockState, true).light(light).renderInto(ms, vb);
        DeployerRenderer.transform(hand.translate(offset.f_82479_, offset.f_82480_, offset.f_82481_), blockState, false).light(light).renderInto(ms, vb);
    }

    protected Vec3 getHandOffset(DeployerBlockEntity be, float partialTicks, BlockState blockState) {
        float distance = be.getHandOffset(partialTicks);
        return Vec3.m_82528_((Vec3i)((Direction)blockState.m_61143_((Property)DirectionalKineticBlock.FACING)).m_122436_()).m_82490_((double)distance);
    }

    protected BlockState getRenderedBlockState(KineticBlockEntity be) {
        return KineticBlockEntityRenderer.shaft(KineticBlockEntityRenderer.getRotationAxisOf(be));
    }

    private static SuperByteBuffer transform(SuperByteBuffer buffer, BlockState deployerState, boolean axisDirectionMatters) {
        float xRot;
        Direction facing = (Direction)deployerState.m_61143_((Property)DirectionalKineticBlock.FACING);
        float yRot = AngleHelper.horizontalAngle(facing);
        float f = facing == Direction.UP ? 270.0f : (xRot = facing == Direction.DOWN ? 90.0f : 0.0f);
        float zRot = axisDirectionMatters && (Boolean)deployerState.m_61143_((Property)DirectionalAxisKineticBlock.AXIS_ALONG_FIRST_COORDINATE) ^ facing.m_122434_() == Direction.Axis.Z ? 90.0f : 0.0f;
        buffer.rotateCentered(Direction.UP, (float)((double)(yRot / 180.0f) * Math.PI));
        buffer.rotateCentered(Direction.EAST, (float)((double)(xRot / 180.0f) * Math.PI));
        buffer.rotateCentered(Direction.SOUTH, (float)((double)(zRot / 180.0f) * Math.PI));
        return buffer;
    }

    public static void renderInContraption(MovementContext context, VirtualRenderWorld renderWorld, ContraptionMatrices matrices, MultiBufferSource buffer) {
        double factor;
        VertexConsumer builder = buffer.m_6299_(RenderType.m_110451_());
        BlockState blockState = context.state;
        DeployerBlockEntity.Mode mode = NBTHelper.readEnum(context.blockEntityData, "Mode", DeployerBlockEntity.Mode.class);
        PartialModel handPose = DeployerRenderer.getHandPose(mode);
        float speed = context.getAnimationSpeed();
        if (context.contraption.stalled) {
            speed = 0.0f;
        }
        SuperByteBuffer shaft = CachedBufferer.block(AllBlocks.SHAFT.getDefaultState());
        SuperByteBuffer pole = CachedBufferer.partial(AllPartialModels.DEPLOYER_POLE, blockState);
        SuperByteBuffer hand = CachedBufferer.partial(handPose, blockState);
        if (context.contraption.stalled || context.position == null || context.data.m_128441_("StationaryTimer")) {
            factor = Mth.m_14031_((float)(AnimationTickHolder.getRenderTime() * 0.5f)) * 0.25f + 0.25f;
        } else {
            Vec3 center = VecHelper.getCenterOf((Vec3i)BlockPos.m_274446_((Position)context.position));
            double distance = context.position.m_82554_(center);
            double nextDistance = context.position.m_82549_(context.motion).m_82554_(center);
            factor = 0.5 - Mth.m_14008_((double)Mth.m_14139_((double)AnimationTickHolder.getPartialTicks(), (double)distance, (double)nextDistance), (double)0.0, (double)1.0);
        }
        Vec3 offset = Vec3.m_82528_((Vec3i)((Direction)blockState.m_61143_((Property)DirectionalKineticBlock.FACING)).m_122436_()).m_82490_(factor);
        PoseStack m = matrices.getModel();
        m.m_85836_();
        m.m_85836_();
        Direction.Axis axis = Direction.Axis.Y;
        if (context.state.m_60734_() instanceof IRotate) {
            IRotate def = (IRotate)context.state.m_60734_();
            axis = def.getRotationAxis(context.state);
        }
        float time = AnimationTickHolder.getRenderTime((LevelAccessor)context.world) / 20.0f;
        float angle = time * speed % 360.0f;
        ((TransformStack)((TransformStack)((TransformStack)TransformStack.cast((PoseStack)m).centre()).rotateY(axis == Direction.Axis.Z ? 90.0 : 0.0)).rotateZ(axis.m_122479_() ? 90.0 : 0.0)).unCentre();
        shaft.transform(m);
        shaft.rotateCentered(Direction.m_122390_((Direction.AxisDirection)Direction.AxisDirection.POSITIVE, (Direction.Axis)Direction.Axis.Y), angle);
        m.m_85849_();
        if (!context.disabled) {
            m.m_85837_(offset.f_82479_, offset.f_82480_, offset.f_82481_);
        }
        pole.transform(m);
        hand.transform(m);
        DeployerRenderer.transform(pole, blockState, true);
        DeployerRenderer.transform(hand, blockState, false);
        shaft.light(matrices.getWorld(), ContraptionRenderDispatcher.getContraptionWorldLight(context, renderWorld)).renderInto(matrices.getViewProjection(), builder);
        pole.light(matrices.getWorld(), ContraptionRenderDispatcher.getContraptionWorldLight(context, renderWorld)).renderInto(matrices.getViewProjection(), builder);
        hand.light(matrices.getWorld(), ContraptionRenderDispatcher.getContraptionWorldLight(context, renderWorld)).renderInto(matrices.getViewProjection(), builder);
        m.m_85849_();
    }

    static PartialModel getHandPose(DeployerBlockEntity.Mode mode) {
        return mode == DeployerBlockEntity.Mode.PUNCH ? AllPartialModels.DEPLOYER_HAND_PUNCHING : AllPartialModels.DEPLOYER_HAND_POINTING;
    }
}

