/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.smartbrainlib.api.core.behaviour.custom.attack;

import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.function.Function;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.tslat.smartbrainlib.api.core.behaviour.DelayedBehaviour;
import net.tslat.smartbrainlib.util.BrainUtils;
import org.jetbrains.annotations.Nullable;

public class AnimatableMeleeAttack<E extends Mob>
extends DelayedBehaviour<E> {
    private static final List<Pair<MemoryModuleType<?>, MemoryStatus>> MEMORY_REQUIREMENTS = ObjectArrayList.of((Object[])new Pair[]{Pair.of((Object)MemoryModuleType.f_26372_, (Object)MemoryStatus.VALUE_PRESENT), Pair.of((Object)MemoryModuleType.f_26373_, (Object)MemoryStatus.VALUE_ABSENT)});
    protected Function<E, Integer> attackIntervalSupplier = entity -> 20;
    @Nullable
    protected LivingEntity target = null;

    public AnimatableMeleeAttack(int delayTicks) {
        super(delayTicks);
    }

    public AnimatableMeleeAttack<E> attackInterval(Function<E, Integer> supplier) {
        this.attackIntervalSupplier = supplier;
        return this;
    }

    @Override
    protected List<Pair<MemoryModuleType<?>, MemoryStatus>> getMemoryRequirements() {
        return MEMORY_REQUIREMENTS;
    }

    protected boolean checkExtraStartConditions(ServerLevel level, E entity) {
        this.target = BrainUtils.getTargetOfEntity(entity);
        return entity.m_21574_().m_148306_((Entity)this.target) && entity.m_217066_(this.target);
    }

    @Override
    protected void start(E entity) {
        entity.m_6674_(InteractionHand.MAIN_HAND);
        BehaviorUtils.m_22595_(entity, (LivingEntity)this.target);
    }

    @Override
    protected void stop(E entity) {
        this.target = null;
    }

    @Override
    protected void doDelayedAction(E entity) {
        BrainUtils.setForgettableMemory(entity, MemoryModuleType.f_26373_, Boolean.valueOf(true), (int)this.attackIntervalSupplier.apply(entity));
        if (this.target == null) {
            return;
        }
        if (!entity.m_21574_().m_148306_((Entity)this.target) || !entity.m_217066_(this.target)) {
            return;
        }
        entity.m_7327_((Entity)this.target);
    }
}

