/*
 * Decompiled with CFR 0.152.
 */
package com.mangomilk.design_decor.blocks.industrial_gear;

import com.jozufozu.flywheel.api.Instancer;
import com.jozufozu.flywheel.api.MaterialManager;
import com.jozufozu.flywheel.core.PartialModel;
import com.jozufozu.flywheel.core.materials.FlatLit;
import com.jozufozu.flywheel.util.transform.TransformStack;
import com.mangomilk.design_decor.registry.CDDPartialModels;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.base.KineticBlockEntityRenderer;
import com.simibubi.create.content.kinetics.base.SingleRotatingInstance;
import com.simibubi.create.content.kinetics.base.flwdata.RotatingData;
import com.simibubi.create.content.kinetics.simpleRelays.BracketedKineticBlockEntity;
import com.simibubi.create.content.kinetics.simpleRelays.BracketedKineticBlockEntityRenderer;
import com.simibubi.create.content.kinetics.simpleRelays.ICogWheel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.BlockState;

public class IndustrialGearInstance
extends SingleRotatingInstance<BracketedKineticBlockEntity> {
    protected RotatingData additionalShaft;

    public IndustrialGearInstance(MaterialManager materialManager, BracketedKineticBlockEntity blockEntity) {
        super(materialManager, (KineticBlockEntity)blockEntity);
    }

    public void init() {
        super.init();
        if (!ICogWheel.isLargeCog((BlockState)((BracketedKineticBlockEntity)this.blockEntity).m_58900_())) {
            return;
        }
        float speed = ((BracketedKineticBlockEntity)this.blockEntity).getSpeed();
        Direction.Axis axis = KineticBlockEntityRenderer.getRotationAxisOf((KineticBlockEntity)((KineticBlockEntity)this.blockEntity));
        BlockPos pos = ((BracketedKineticBlockEntity)this.blockEntity).m_58899_();
        float offset = BracketedKineticBlockEntityRenderer.getShaftAngleOffset((Direction.Axis)axis, (BlockPos)pos);
        Direction facing = Direction.m_122387_((Direction.Axis)axis, (Direction.AxisDirection)Direction.AxisDirection.POSITIVE);
        Instancer half = this.getRotatingMaterial().getModel(CDDPartialModels.EMPTY, this.blockState, facing, () -> this.rotateToAxis(axis));
        this.additionalShaft = this.setup((RotatingData)half.createInstance(), speed);
        this.additionalShaft.setRotationOffset(offset);
    }

    protected Instancer<RotatingData> getModel() {
        if (!ICogWheel.isLargeCog((BlockState)((BracketedKineticBlockEntity)this.blockEntity).m_58900_())) {
            return super.getModel();
        }
        Direction.Axis axis = KineticBlockEntityRenderer.getRotationAxisOf((KineticBlockEntity)((KineticBlockEntity)this.blockEntity));
        Direction facing = Direction.m_122387_((Direction.Axis)axis, (Direction.AxisDirection)Direction.AxisDirection.POSITIVE);
        PartialModel model = CDDPartialModels.SHAFTLESS_LARGE_COGWHEEL;
        return this.getRotatingMaterial().getModel(model, this.blockState, facing, () -> this.rotateToAxis(axis));
    }

    private PoseStack rotateToAxis(Direction.Axis axis) {
        Direction facing = Direction.m_122387_((Direction.Axis)axis, (Direction.AxisDirection)Direction.AxisDirection.POSITIVE);
        PoseStack poseStack = new PoseStack();
        ((TransformStack)((TransformStack)((TransformStack)TransformStack.cast((PoseStack)poseStack).centre()).rotateToFace(facing)).multiply(Axis.f_252495_.m_252977_(-90.0f))).unCentre();
        return poseStack;
    }

    public void update() {
        super.update();
        if (this.additionalShaft != null) {
            this.updateRotation(this.additionalShaft);
            this.additionalShaft.setRotationOffset(BracketedKineticBlockEntityRenderer.getShaftAngleOffset((Direction.Axis)this.axis, (BlockPos)this.pos));
        }
    }

    public void updateLight() {
        super.updateLight();
        if (this.additionalShaft != null) {
            this.relight(this.pos, new FlatLit[]{this.additionalShaft});
        }
    }

    public void remove() {
        super.remove();
        if (this.additionalShaft != null) {
            this.additionalShaft.delete();
        }
    }
}

