/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.api;

import com.klikli_dev.occultism.common.entity.job.SpiritJob;
import com.klikli_dev.occultism.common.entity.spirit.SpiritEntity;
import java.util.List;
import java.util.Optional;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.crafting.Ingredient;

public class OccultismAPI {
    private static final OccultismAPI instance = new OccultismAPI();

    public static OccultismAPI get() {
        return instance;
    }

    public Optional<List<Ingredient>> getItemsToPickUp(Entity entity) {
        if (entity instanceof SpiritEntity) {
            SpiritEntity spiritEntity = (SpiritEntity)entity;
            return spiritEntity.getJob().map(SpiritJob::getItemsToPickUp);
        }
        return Optional.empty();
    }

    public Optional<Boolean> canPickupItem(Entity entity, ItemEntity itemEntity) {
        if (entity instanceof SpiritEntity) {
            SpiritEntity spiritEntity = (SpiritEntity)entity;
            return spiritEntity.getJob().map(job -> job.canPickupItem(itemEntity));
        }
        return Optional.empty();
    }
}

