/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.common.entity.ai.behaviour;

import com.klikli_dev.occultism.common.entity.spirit.SpiritEntity;
import com.klikli_dev.occultism.exceptions.ItemHandlerMissingException;
import com.klikli_dev.occultism.registry.OccultismMemoryTypes;
import com.klikli_dev.occultism.util.StorageUtil;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.ai.behavior.BlockPosTracker;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;
import net.tslat.smartbrainlib.api.core.behaviour.ExtendedBehaviour;
import net.tslat.smartbrainlib.util.BrainUtils;

public class DepositItemsBehaviour<E extends SpiritEntity>
extends ExtendedBehaviour<E> {
    public static final double DEPOSIT_ITEM_RANGE_SQUARE = Math.pow(2.5, 2.0);
    private static final List<Pair<MemoryModuleType<?>, MemoryStatus>> MEMORY_REQUIREMENTS = ObjectArrayList.of((Object[])new Pair[]{Pair.of(OccultismMemoryTypes.DEPOSIT_POSITION.get(), (Object)MemoryStatus.VALUE_PRESENT), Pair.of(OccultismMemoryTypes.DEPOSIT_FACING.get(), (Object)MemoryStatus.VALUE_PRESENT)});

    public DepositItemsBehaviour() {
        this.runtimeProvider = entity -> 10;
    }

    protected boolean shouldKeepRunning(E entity) {
        return true;
    }

    protected boolean checkExtraStartConditions(ServerLevel level, E entity) {
        BlockPos depositPos = (BlockPos)BrainUtils.getMemory(entity, OccultismMemoryTypes.DEPOSIT_POSITION.get());
        double dist = entity.m_20238_(Vec3.m_82512_((Vec3i)depositPos));
        return StorageUtil.getFirstFilledSlot((IItemHandler)((SpiritEntity)entity).itemStackHandler.orElseThrow(ItemHandlerMissingException::new)) != -1 && dist <= DEPOSIT_ITEM_RANGE_SQUARE;
    }

    protected void start(E entity) {
        BlockPos depositPos = (BlockPos)BrainUtils.getMemory(entity, OccultismMemoryTypes.DEPOSIT_POSITION.get());
        Direction depositFacing = (Direction)BrainUtils.getMemory(entity, OccultismMemoryTypes.DEPOSIT_FACING.get());
        BlockEntity blockEntity = entity.m_9236_().m_7702_(depositPos);
        if (blockEntity != null) {
            int firstFilledSlot;
            ItemStackHandler entityItemHandler;
            ItemStack duplicate;
            IItemHandler depositItemHandler;
            ItemStack toInsert;
            BrainUtils.setMemory(entity, (MemoryModuleType)MemoryModuleType.f_26371_, (Object)new BlockPosTracker(depositPos));
            LazyOptional depositItemHandlerCap = blockEntity.getCapability(ForgeCapabilities.ITEM_HANDLER, depositFacing);
            this.toggleContainer(blockEntity, true);
            if (depositItemHandlerCap.isPresent() && (toInsert = ItemHandlerHelper.insertItem((IItemHandler)(depositItemHandler = (IItemHandler)depositItemHandlerCap.orElseThrow(ItemHandlerMissingException::new)), (ItemStack)(duplicate = (entityItemHandler = (ItemStackHandler)((SpiritEntity)entity).itemStackHandler.orElseThrow(ItemHandlerMissingException::new)).getStackInSlot(firstFilledSlot = StorageUtil.getFirstFilledSlot((IItemHandler)entityItemHandler)).m_41777_()), (boolean)true)).m_41613_() != duplicate.m_41613_()) {
                ItemStack leftover = ItemHandlerHelper.insertItem((IItemHandler)depositItemHandler, (ItemStack)duplicate, (boolean)false);
                entityItemHandler.setStackInSlot(firstFilledSlot, leftover);
            }
        }
    }

    protected void stop(E entity) {
        BlockPos depositPos = (BlockPos)BrainUtils.getMemory(entity, OccultismMemoryTypes.DEPOSIT_POSITION.get());
        BlockEntity blockEntity = entity.m_9236_().m_7702_(depositPos);
        if (blockEntity != null) {
            this.toggleContainer(blockEntity, false);
        }
    }

    public void toggleContainer(BlockEntity target, boolean open) {
        if (open) {
            target.m_58904_().m_7696_(target.m_58899_(), target.m_58900_().m_60734_(), 1, 1);
        } else {
            target.m_58904_().m_7696_(target.m_58899_(), target.m_58900_().m_60734_(), 1, 0);
        }
    }

    protected List<Pair<MemoryModuleType<?>, MemoryStatus>> getMemoryRequirements() {
        return MEMORY_REQUIREMENTS;
    }
}

