/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.datagen;

import com.klikli_dev.modonomicon.api.datagen.ModonomiconLanguageProvider;
import com.klikli_dev.occultism.datagen.ItemModelsGenerator;
import com.klikli_dev.occultism.datagen.OccultismAdvancementProvider;
import com.klikli_dev.occultism.datagen.OccultismBookProvider;
import com.klikli_dev.occultism.datagen.PentacleProvider;
import com.klikli_dev.occultism.datagen.StandardBlockStateProvider;
import com.klikli_dev.occultism.datagen.lang.ENUSProvider;
import com.klikli_dev.occultism.datagen.loot.OccultismBlockLoot;
import com.klikli_dev.occultism.datagen.loot.OccultismEntityLoot;
import com.klikli_dev.occultism.datagen.loot.OccultismLootModifiers;
import com.klikli_dev.occultism.datagen.recipes.OccultismRecipeProvider;
import com.klikli_dev.occultism.datagen.tags.OccultismBiomeTagProvider;
import com.klikli_dev.occultism.datagen.tags.OccultismBlockTagProvider;
import com.klikli_dev.occultism.datagen.tags.OccultismEntityTypeTagProvider;
import com.klikli_dev.occultism.datagen.tags.OccultismItemTagProvider;
import com.klikli_dev.occultism.datagen.worldgen.OccultismRegistries;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.ValidationContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraftforge.common.data.DatapackBuiltinEntriesProvider;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class DataGenerators {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        generator.addProvider(event.includeServer(), (DataProvider)new LootTableProvider(generator.getPackOutput(), Set.of(), List.of(new LootTableProvider.SubProviderEntry(OccultismBlockLoot::new, LootContextParamSets.f_81421_), new LootTableProvider.SubProviderEntry(OccultismEntityLoot::new, LootContextParamSets.f_81415_))){

            protected void validate(Map<ResourceLocation, LootTable> map, ValidationContext validationcontext) {
            }
        });
        generator.addProvider(event.includeServer(), (DataProvider)new PentacleProvider(generator));
        generator.addProvider(event.includeServer(), (DataProvider)new OccultismAdvancementProvider(generator));
        generator.addProvider(event.includeServer(), (DataProvider)new OccultismRecipeProvider(generator.getPackOutput()));
        OccultismBlockTagProvider forgeBlockProvider = new OccultismBlockTagProvider(generator.getPackOutput(), event.getLookupProvider(), event.getExistingFileHelper());
        generator.addProvider(event.includeServer(), (DataProvider)forgeBlockProvider);
        generator.addProvider(event.includeServer(), (DataProvider)new OccultismEntityTypeTagProvider(generator.getPackOutput(), event.getLookupProvider(), event.getExistingFileHelper()));
        generator.addProvider(event.includeServer(), (DataProvider)new OccultismItemTagProvider(generator.getPackOutput(), event.getLookupProvider(), forgeBlockProvider.m_274426_(), event.getExistingFileHelper()));
        generator.addProvider(event.includeServer(), (DataProvider)new OccultismBiomeTagProvider(generator.getPackOutput(), event.getLookupProvider(), event.getExistingFileHelper()));
        generator.addProvider(event.includeClient(), (DataProvider)new ItemModelsGenerator(generator.getPackOutput(), event.getExistingFileHelper()));
        generator.addProvider(event.includeClient(), (DataProvider)new StandardBlockStateProvider(generator.getPackOutput(), event.getExistingFileHelper()));
        generator.addProvider(event.includeClient(), (DataProvider)new OccultismLootModifiers(generator.getPackOutput()));
        ENUSProvider enUSProvider = new ENUSProvider(generator.getPackOutput());
        generator.addProvider(event.includeServer(), (DataProvider)new OccultismBookProvider(generator.getPackOutput(), "occultism", (ModonomiconLanguageProvider)enUSProvider));
        generator.addProvider(event.includeClient(), (DataProvider)enUSProvider);
        event.getGenerator().addProvider(event.includeServer(), output -> new DatapackBuiltinEntriesProvider(output, event.getLookupProvider(), OccultismRegistries.BUILDER, Set.of("occultism")));
    }
}

