/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.datagen.recipes;

import com.google.common.collect.Sets;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

public abstract class JsonRecipeProvider
implements DataProvider {
    protected final PackOutput.PathProvider recipePathProvider;
    protected String modid;
    protected BiConsumer<ResourceLocation, JsonObject> recipeConsumer;

    public JsonRecipeProvider(PackOutput packOutput, String modid) {
        this(packOutput, modid, "");
    }

    public JsonRecipeProvider(PackOutput packOutput, String modid, String recipeSubPath) {
        this.recipePathProvider = packOutput.m_245269_(PackOutput.Target.DATA_PACK, "recipes/" + recipeSubPath);
        this.modid = modid;
    }

    protected String name(Item item) {
        return ForgeRegistries.ITEMS.getKey((Object)item).m_135815_();
    }

    protected String name(TagKey<Item> tag) {
        return tag.f_203868_().m_135815_().replace('/', '_');
    }

    protected String name(List<TagKey<Item>> tags) {
        return tags.stream().distinct().map(this::name).reduce("", (a, b) -> a + "_and_" + b).replaceFirst("_and_", "");
    }

    public ResourceLocation locFor(TagKey<Item> tag) {
        return tag.f_203868_();
    }

    public ResourceLocation locFor(ItemLike itemLike) {
        return ForgeRegistries.ITEMS.getKey((Object)itemLike.m_5456_());
    }

    public ResourceLocation locFor(Fluid fluid) {
        return ForgeRegistries.FLUIDS.getKey((Object)fluid);
    }

    public TagKey<Item> tag(String tag) {
        return this.tag(new ResourceLocation(tag));
    }

    public TagKey<Item> tag(ResourceLocation tag) {
        return TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)tag);
    }

    public ResourceLocation modLoc(String name) {
        return new ResourceLocation(this.modid, name);
    }

    public ResourceLocation mcLoc(String name) {
        return new ResourceLocation(name);
    }

    public ResourceLocation forgeLoc(String name) {
        return new ResourceLocation("forge", name);
    }

    public JsonObject makeFluidIngredient(ResourceLocation fluid) {
        JsonObject jsonobject = new JsonObject();
        jsonobject.addProperty("fluid", fluid.toString());
        return jsonobject;
    }

    public JsonObject makeFluidTagIngredient(ResourceLocation tag) {
        JsonObject jsonobject = new JsonObject();
        jsonobject.addProperty("tag", tag.toString());
        return jsonobject;
    }

    public JsonObject makeTagIngredient(ResourceLocation tag) {
        JsonObject jsonobject = new JsonObject();
        jsonobject.addProperty("tag", tag.toString());
        return jsonobject;
    }

    public JsonObject makeTagIngredient(ResourceLocation tag, int count) {
        JsonObject jsonobject = this.makeTagIngredient(tag);
        jsonobject.addProperty("count", (Number)count);
        return jsonobject;
    }

    public JsonObject makeItemIngredient(ResourceLocation item) {
        JsonObject jsonobject = new JsonObject();
        jsonobject.addProperty("item", item.toString());
        return jsonobject;
    }

    public JsonObject makeItemIngredient(ResourceLocation item, int count) {
        JsonObject jsonobject = this.makeItemIngredient(item);
        jsonobject.addProperty("count", (Number)count);
        return jsonobject;
    }

    public JsonObject makeItemResult(ResourceLocation item) {
        return this.makeItemResult(item, 1);
    }

    public JsonObject makeItemResult(ResourceLocation item, int count) {
        return this.makeItemResult(item, count, (JsonObject)null);
    }

    public JsonObject makeItemResult(ResourceLocation item, int count, @Nullable CompoundTag nbt) {
        return this.makeItemResult(item, count, nbt == null ? null : (JsonObject)NbtOps.f_128958_.convertTo((DynamicOps)JsonOps.INSTANCE, (Tag)nbt));
    }

    public JsonObject makeItemResult(ResourceLocation item, int count, @Nullable JsonObject nbt) {
        JsonObject jsonobject = new JsonObject();
        jsonobject.addProperty("item", item.toString());
        jsonobject.addProperty("count", (Number)count);
        if (nbt != null) {
            jsonobject.add("nbt", (JsonElement)nbt);
        }
        return jsonobject;
    }

    public JsonObject makeItemStackCodecResult(ResourceLocation item) {
        return this.makeItemStackCodecResult(item, 1);
    }

    public JsonObject makeItemStackCodecResult(ResourceLocation item, int count) {
        return this.makeItemStackCodecResult(item, count, (JsonObject)null);
    }

    public JsonObject makeItemStackCodecResult(ResourceLocation item, int count, @Nullable CompoundTag nbt) {
        return this.makeItemStackCodecResult(item, count, nbt == null ? null : (JsonObject)NbtOps.f_128958_.convertTo((DynamicOps)JsonOps.INSTANCE, (Tag)nbt));
    }

    public JsonObject makeItemStackCodecResult(ResourceLocation item, int count, @Nullable JsonObject nbt) {
        JsonObject jsonobject = new JsonObject();
        jsonobject.addProperty("id", item.toString());
        jsonobject.addProperty("Count", (Number)count);
        if (nbt != null) {
            jsonobject.add("tag", (JsonElement)nbt);
        }
        return jsonobject;
    }

    public JsonObject makeTagResult(ResourceLocation item) {
        return this.makeTagResult(item, 1);
    }

    public JsonObject makeTagResult(ResourceLocation item, int count) {
        return this.makeTagResult(item, count, (JsonObject)null);
    }

    public JsonObject makeTagResult(ResourceLocation tag, int count, @Nullable CompoundTag nbt) {
        return this.makeTagResult(tag, count, nbt == null ? null : (JsonObject)NbtOps.f_128958_.convertTo((DynamicOps)JsonOps.INSTANCE, (Tag)nbt));
    }

    public JsonObject makeTagResult(ResourceLocation tag, int count, @Nullable JsonObject nbt) {
        JsonObject jsonobject = new JsonObject();
        jsonobject.addProperty("tag", tag.toString());
        jsonobject.addProperty("count", (Number)count);
        if (nbt != null) {
            jsonobject.add("nbt", (JsonElement)nbt);
        }
        return jsonobject;
    }

    public JsonObject makeFluidResult(FluidStack fluidStack) {
        return ((JsonElement)FluidStack.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)fluidStack).getOrThrow(false, s -> {
            throw new IllegalStateException("Failed to encode fluid stack: " + s);
        })).getAsJsonObject();
    }

    public JsonObject makeTagNotEmptyCondition(String tag) {
        JsonObject condition = new JsonObject();
        condition.addProperty("type", "forge:not");
        JsonObject value = new JsonObject();
        value.addProperty("type", "forge:tag_empty");
        value.addProperty("tag", tag);
        condition.add("value", (JsonElement)value);
        return condition;
    }

    public CompletableFuture<?> m_213708_(CachedOutput pOutput) {
        HashSet set = Sets.newHashSet();
        ArrayList futures = new ArrayList();
        this.recipeConsumer = (id, recipe) -> {
            if (!set.add(id)) {
                throw new IllegalStateException("Duplicate recipe " + id);
            }
            futures.add(DataProvider.m_253162_((CachedOutput)pOutput, (JsonElement)recipe, (Path)this.recipePathProvider.m_245731_(id)));
        };
        this.buildRecipes(this.recipeConsumer);
        return CompletableFuture.allOf((CompletableFuture[])futures.toArray(CompletableFuture[]::new));
    }

    public abstract void buildRecipes(BiConsumer<ResourceLocation, JsonObject> var1);
}

