/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.datagen.recipes;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.klikli_dev.occultism.crafting.recipe.SpiritTradeRecipe;
import java.util.function.Consumer;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.RequirementsStrategy;
import net.minecraft.advancements.critereon.RecipeUnlockedTrigger;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpiritTradeRecipeBuilder
implements RecipeBuilder {
    private final Advancement.Builder advancement = Advancement.Builder.m_138353_();
    @Nullable
    private String group;
    private final RecipeSerializer<SpiritTradeRecipe> serializer = SpiritTradeRecipe.SERIALIZER;
    private final Ingredient ingredient;
    private final ItemStack output;

    public SpiritTradeRecipeBuilder(Ingredient ingredient, ItemStack output) {
        this.ingredient = ingredient;
        this.output = output;
    }

    @Contract(value="_, _ -> new")
    @NotNull
    public static SpiritTradeRecipeBuilder spiritTradeRecipe(Ingredient ingredient, ItemStack output) {
        return new SpiritTradeRecipeBuilder(ingredient, output);
    }

    public RecipeBuilder m_126132_(String pCriterionName, CriterionTriggerInstance pCriterionTrigger) {
        this.advancement.m_138386_(pCriterionName, pCriterionTrigger);
        return this;
    }

    public RecipeBuilder m_126145_(@Nullable String pGroupName) {
        this.group = pGroupName;
        return this;
    }

    public Item m_142372_() {
        return this.output.m_41720_();
    }

    public void m_126140_(Consumer<FinishedRecipe> pFinishedRecipeConsumer, ResourceLocation pRecipeId) {
        this.ensureValid(pRecipeId);
        this.advancement.m_138396_(new ResourceLocation("recipes/root")).m_138386_("has_the_recipe", (CriterionTriggerInstance)RecipeUnlockedTrigger.m_63728_((ResourceLocation)pRecipeId)).m_138354_(AdvancementRewards.Builder.m_10009_((ResourceLocation)pRecipeId)).m_138360_(RequirementsStrategy.f_15979_);
        pFinishedRecipeConsumer.accept(new Result(pRecipeId, this.advancement, new ResourceLocation(pRecipeId.m_135827_(), "recipes/spirit_trade/" + pRecipeId.m_135815_()), this.group == null ? "" : this.group, this.serializer, this.ingredient, this.output));
    }

    private void ensureValid(ResourceLocation id) {
        if (this.advancement.m_138405_().isEmpty()) {
            throw new IllegalStateException("No way of obtaining recipe " + id);
        }
    }

    public class Result
    implements FinishedRecipe {
        private final ResourceLocation id;
        private final Advancement.Builder advancement;
        private final ResourceLocation advancementId;
        private final String group;
        private final RecipeSerializer<SpiritTradeRecipe> serializer;
        private final Ingredient ingredient;
        private final ItemStack output;

        public Result(ResourceLocation id, Advancement.Builder advancement, ResourceLocation advancementId, String group, RecipeSerializer<SpiritTradeRecipe> serializer, Ingredient ingredient, ItemStack output) {
            this.id = id;
            this.advancement = advancement;
            this.advancementId = advancementId;
            this.group = group;
            this.serializer = serializer;
            this.ingredient = ingredient;
            this.output = output;
        }

        public void m_7917_(JsonObject pJson) {
            if (!this.group.isEmpty()) {
                pJson.addProperty("group", this.group);
            }
            JsonArray ingredientArray = new JsonArray();
            ingredientArray.add(this.ingredient.m_43942_());
            pJson.add("ingredients", (JsonElement)ingredientArray);
            JsonObject output = new JsonObject();
            output.addProperty("item", this.output.m_41720_().m_204114_().m_205785_().m_135782_().toString());
            if (this.output.m_41613_() > 1) {
                output.addProperty("count", (Number)this.output.m_41613_());
            }
            pJson.add("result", (JsonElement)output);
        }

        public ResourceLocation m_6445_() {
            return this.id;
        }

        public RecipeSerializer<?> m_6637_() {
            return this.serializer;
        }

        @Nullable
        public JsonObject m_5860_() {
            return this.advancement.m_138400_();
        }

        @Nullable
        public ResourceLocation m_6448_() {
            return this.advancementId;
        }
    }
}

