/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.occultism.integration.modonomicon.pages;

import com.klikli_dev.modonomicon.book.page.BookRecipePage;
import com.klikli_dev.modonomicon.client.render.page.BookRecipePageRenderer;
import com.klikli_dev.occultism.crafting.recipe.RitualRecipe;
import com.klikli_dev.occultism.integration.modonomicon.pages.BookRitualRecipePage;
import com.klikli_dev.occultism.registry.OccultismBlocks;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import net.minecraft.Util;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;

public abstract class BookRitualRecipePageRenderer<T extends Recipe<?>>
extends BookRecipePageRenderer<RitualRecipe, BookRecipePage<RitualRecipe>> {
    public static final int RITUAL_DUMMY_OFFSET = 10;
    private final ItemStack sacrificialBowl = new ItemStack((ItemLike)OccultismBlocks.SACRIFICIAL_BOWL.get());
    private final ItemStack goldenSacrificialBowl = new ItemStack((ItemLike)OccultismBlocks.GOLDEN_SACRIFICIAL_BOWL.get());

    public BookRitualRecipePageRenderer(BookRitualRecipePage page) {
        super((BookRecipePage)page);
    }

    protected int getRecipeHeight() {
        return 45;
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float ticks) {
        Style style;
        int recipeX = X;
        int recipeY = Y;
        if (((BookRecipePage)this.page).getRecipe1() != null) {
            this.drawRecipe(guiGraphics, (RitualRecipe)((BookRecipePage)this.page).getRecipe1(), recipeX, recipeY, mouseX, mouseY, false);
        }
        if ((style = this.getClickedComponentStyleAt(mouseX, mouseY)) != null) {
            this.parentScreen.renderComponentHoverEffect(guiGraphics, style, mouseX, mouseY);
        }
    }

    @Nullable
    public Style getClickedComponentStyleAt(double pMouseX, double pMouseY) {
        Style textStyle = super.getClickedComponentStyleAt(pMouseX, pMouseY);
        if (pMouseX > 0.0 && pMouseY > 0.0 && textStyle == null && ((BookRecipePage)this.page).getRecipe1() != null) {
            int recipeX = X;
            int recipeY = Y;
            int pentacleNameX = recipeX + 10;
            int pentacleNameY = recipeY + 8;
            int maxWidth = 100;
            String pentacleName = I18n.m_118938_((String)Util.m_137492_((String)"multiblock", (ResourceLocation)((RitualRecipe)((BookRecipePage)this.page).getRecipe1()).getPentacleId()), (Object[])new Object[0]);
            int nameWidth = this.font.m_92895_(pentacleName);
            float scale = Math.min(1.0f, (float)maxWidth / (float)nameWidth);
            if (scale < 1.0f) {
                nameWidth = (int)((float)nameWidth * scale);
            }
            if (pMouseX > (double)pentacleNameX && pMouseX < (double)(pentacleNameX + nameWidth) && pMouseY > (double)pentacleNameY) {
                Objects.requireNonNull(this.font);
                if (pMouseY < (double)(pentacleNameY + 9)) {
                    String goToText = "book.occultism.dictionary_of_spirits.pentacles." + ((RitualRecipe)((BookRecipePage)this.page).getRecipe1()).getPentacleId().m_135815_() + ".name";
                    MutableComponent hoverComponent = Component.m_237110_((String)"occultism.modonomicon.ritual_recipe.go_to_pentacle", (Object[])new Object[]{Component.m_237115_((String)goToText)});
                    return Style.f_131099_.m_131142_(new ClickEvent(ClickEvent.Action.CHANGE_PAGE, "entry://occultism:dictionary_of_spirits/pentacles/" + ((RitualRecipe)((BookRecipePage)this.page).getRecipe1()).getPentacleId().m_135815_())).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)hoverComponent));
                }
            }
        }
        return textStyle;
    }

    protected void drawRecipe(GuiGraphics guiGraphics, RitualRecipe recipe, int recipeX, int recipeY, int mouseX, int mouseY, boolean second) {
        float scale;
        int maxWidth;
        int x;
        recipeY += 10;
        if (!second && !((BookRecipePage)this.page).getTitle1().isEmpty()) {
            this.renderTitle(guiGraphics, ((BookRecipePage)this.page).getTitle1(), false, 62, 0);
        }
        int ritualCenterX = recipeX + 30;
        int ritualCenterY = recipeY + 70;
        int sacrificialCircleRadius = 30;
        int sacricialBowlPaddingVertical = 20;
        int sacricialBowlPaddingHorizontal = 15;
        List<Vec3i> sacrificialBowlPosition = Stream.of(new Vec3i(ritualCenterX, ritualCenterY - sacrificialCircleRadius, 0), new Vec3i(ritualCenterX + sacrificialCircleRadius, ritualCenterY, 0), new Vec3i(ritualCenterX, ritualCenterY + sacrificialCircleRadius, 0), new Vec3i(ritualCenterX - sacrificialCircleRadius, ritualCenterY, 0), new Vec3i(ritualCenterX + sacricialBowlPaddingHorizontal, ritualCenterY - sacrificialCircleRadius, 0), new Vec3i(ritualCenterX + sacrificialCircleRadius, ritualCenterY - sacricialBowlPaddingVertical, 0), new Vec3i(ritualCenterX - sacricialBowlPaddingHorizontal, ritualCenterY + sacrificialCircleRadius, 0), new Vec3i(ritualCenterX - sacrificialCircleRadius, ritualCenterY + sacricialBowlPaddingVertical, 0), new Vec3i(ritualCenterX - sacricialBowlPaddingHorizontal, ritualCenterY - sacrificialCircleRadius, 0), new Vec3i(ritualCenterX + sacrificialCircleRadius, ritualCenterY + sacricialBowlPaddingVertical, 0), new Vec3i(ritualCenterX + sacricialBowlPaddingHorizontal, ritualCenterY + sacrificialCircleRadius, 0), new Vec3i(ritualCenterX - sacrificialCircleRadius, ritualCenterY - sacricialBowlPaddingVertical, 0)).toList();
        for (int i = 0; i < recipe.m_7527_().size(); ++i) {
            Vec3i pos = sacrificialBowlPosition.get(i);
            this.parentScreen.renderItemStack(guiGraphics, pos.m_123341_(), pos.m_123342_(), mouseX, mouseY, this.sacrificialBowl);
            this.parentScreen.renderIngredient(guiGraphics, pos.m_123341_(), pos.m_123342_() - 5, mouseX, mouseY, (Ingredient)recipe.m_7527_().get(i));
        }
        this.parentScreen.renderItemStack(guiGraphics, recipeX + 85, recipeY + 110, mouseX, mouseY, this.goldenSacrificialBowl);
        this.parentScreen.renderItemStack(guiGraphics, recipeX + 85, recipeY + 105, mouseX, mouseY, recipe.m_8043_(this.parentScreen.getMinecraft().f_91073_.m_9598_()));
        this.parentScreen.renderItemStack(guiGraphics, recipeX - 10, recipeY - 5, mouseX, mouseY, recipe.getRitualDummy());
        if (recipe.getPentacle() != null) {
            guiGraphics.m_280168_().m_85836_();
            String pentacleName = I18n.m_118938_((String)Util.m_137492_((String)"multiblock", (ResourceLocation)recipe.getPentacleId()), (Object[])new Object[0]);
            int y = recipeY - 1;
            x = recipeX;
            maxWidth = 100;
            scale = Math.min(1.0f, (float)maxWidth / (float)this.font.m_92895_(pentacleName));
            if (scale < 1.0f) {
                guiGraphics.m_280168_().m_252880_((float)x - (float)x * scale, (float)y - (float)y * scale, 0.0f);
                guiGraphics.m_280168_().m_85841_(scale, scale, scale);
            }
            this.drawScaledStringNoShadow(guiGraphics, pentacleName, x + 10, y, 0x3366CC, scale);
            guiGraphics.m_280168_().m_85849_();
        }
        if (recipe.requiresItemUse()) {
            this.parentScreen.renderIngredient(guiGraphics, recipeX + 50, recipeY + 21, mouseX, mouseY, recipe.getItemToUse());
            guiGraphics.m_280056_(this.font, I18n.m_118938_((String)"occultism.modonomicon.ritual_recipe.item_to_use", (Object[])new Object[0]), recipeX - 15, recipeY + 25, 0, false);
        }
        this.parentScreen.renderItemStack(guiGraphics, recipeX + 30, recipeY + 70, mouseX, mouseY, this.goldenSacrificialBowl);
        this.parentScreen.renderIngredient(guiGraphics, recipeX + 30, recipeY + 65, mouseX, mouseY, recipe.getActivationItem());
        if (recipe.getEntityToSummon() != null) {
            guiGraphics.m_280168_().m_85836_();
            String text = I18n.m_118938_((String)"occultism.modonomicon.ritual_recipe.summon", (Object[])new Object[]{I18n.m_118938_((String)recipe.getEntityToSummon().m_20675_(), (Object[])new Object[0])});
            int y = recipeY + 120;
            x = recipeX - 15;
            maxWidth = 100;
            scale = Math.min(1.0f, (float)maxWidth / (float)this.font.m_92895_(text));
            if (scale < 1.0f) {
                guiGraphics.m_280168_().m_252880_((float)x - (float)x * scale, (float)y - (float)y * scale, 0.0f);
                guiGraphics.m_280168_().m_85841_(scale, scale, scale);
            }
            this.drawScaledStringNoShadow(guiGraphics, text, x, y, 0, scale);
            guiGraphics.m_280168_().m_85849_();
        }
        if (recipe.getSpiritJobType() != null) {
            guiGraphics.m_280168_().m_85836_();
            String text = I18n.m_118938_((String)"occultism.modonomicon.ritual_recipe.job", (Object[])new Object[]{I18n.m_118938_((String)("job." + recipe.getSpiritJobType().toString().replace(":", ".")), (Object[])new Object[0])});
            int y = recipeY + 130;
            x = recipeX;
            maxWidth = 105;
            scale = Math.min(1.0f, (float)maxWidth / (float)this.font.m_92895_(text));
            if (scale < 1.0f) {
                guiGraphics.m_280168_().m_252880_((float)x - (float)x * scale, (float)y - (float)y * scale, 0.0f);
                guiGraphics.m_280168_().m_85841_(scale, scale, scale);
            }
            this.drawScaledStringNoShadow(guiGraphics, text, x - 15, y, 0x3366CC, scale);
            guiGraphics.m_280168_().m_85849_();
        }
        if (recipe.requiresSacrifice()) {
            guiGraphics.m_280168_().m_85836_();
            String text = I18n.m_118938_((String)"occultism.modonomicon.ritual_recipe.sacrifice", (Object[])new Object[]{I18n.m_118938_((String)recipe.getEntityToSacrificeDisplayName(), (Object[])new Object[0])});
            int y = recipeY + 15;
            x = recipeX - 15;
            maxWidth = 120;
            scale = Math.min(1.0f, (float)maxWidth / (float)this.font.m_92895_(text));
            if (scale < 1.0f) {
                guiGraphics.m_280168_().m_252880_((float)x - (float)x * scale, (float)y - (float)y * scale, 0.0f);
                guiGraphics.m_280168_().m_85841_(scale, scale, scale);
            }
            this.drawScaledStringNoShadow(guiGraphics, text, x, y, 0, scale);
            guiGraphics.m_280168_().m_85849_();
        }
    }

    public void drawScaledStringNoShadow(GuiGraphics guiGraphics, String s, int x, int y, int color, float scale) {
        float f = x;
        float f2 = y;
        Objects.requireNonNull(this.font);
        guiGraphics.drawString(this.font, s, f, f2 + 9.0f * (1.0f - scale), color, false);
    }
}

