/*
 * Decompiled with CFR 0.152.
 */
package com.tom.storagemod.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.tom.storagemod.gui.AbstractFilteredScreen;
import com.tom.storagemod.gui.ButtonExt;
import com.tom.storagemod.gui.GuiButton;
import com.tom.storagemod.gui.TagItemFilterMenu;
import com.tom.storagemod.network.NetworkHandler;
import com.tom.storagemod.util.IDataReceiver;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.lwjgl.glfw.GLFW;

public class TagItemFilterScreen
extends AbstractFilteredScreen<TagItemFilterMenu>
implements IDataReceiver {
    private static final ResourceLocation GUI_TEXTURES = new ResourceLocation("toms_storage", "textures/gui/tag_filter.png");
    private static final int LINES = 4;
    private GuiButton buttonAllowList;
    private GuiButton buttonAdd;
    private GuiButton buttonRemove;
    private List<String> itemTags = new ArrayList<String>();
    private List<String> filterTags = new ArrayList<String>();
    private ListHandler itemTagList;
    private ListHandler filterList;

    public TagItemFilterScreen(TagItemFilterMenu container, Inventory playerInventory, Component textComponent) {
        super(container, playerInventory, textComponent);
    }

    protected void m_7856_() {
        super.m_7856_();
        this.buttonAllowList = (GuiButton)this.m_142416_((GuiEventListener)new GuiButton(this.f_97735_ - 18, this.f_97736_ + 5, 0, b -> this.click(0, this.buttonAllowList.getState() != 1)));
        this.buttonAllowList.tooltipFactory = s -> Tooltip.m_257550_((Component)Component.m_237115_((String)("tooltip.toms_storage.allowList_" + s)));
        this.itemTagList = new ListHandler(this.f_97735_ + 28, this.f_97736_ + 15);
        this.itemTagList.list = () -> this.itemTags;
        this.filterList = new ListHandler(this.f_97735_ + 109, this.f_97736_ + 15);
        this.filterList.list = () -> this.filterTags;
        this.buttonAdd = (GuiButton)this.m_142416_((GuiEventListener)this.makeCompositeButton(this.f_97735_ + 90, this.f_97736_ + 14, 0, b -> {
            if (this.itemTagList.selected != null) {
                if (!this.filterTags.contains(this.itemTagList.selected)) {
                    this.filterTags.add(this.itemTagList.selected);
                }
                this.itemTagList.selected = null;
                this.sync();
            }
        }));
        this.buttonRemove = (GuiButton)this.m_142416_((GuiEventListener)this.makeCompositeButton(this.f_97735_ + 90, this.f_97736_ + 32, 1, b -> {
            if (this.filterList.selected != null) {
                this.filterTags.remove(this.filterList.selected);
                this.filterList.selected = null;
                this.sync();
            }
        }));
    }

    private void sync() {
        ListTag list = new ListTag();
        this.filterTags.forEach(t -> list.add((Object)StringTag.m_129297_((String)t)));
        CompoundTag tag = new CompoundTag();
        tag.m_128365_("l", (Tag)list);
        NetworkHandler.sendDataToServer(tag);
    }

    protected void m_181908_() {
        ItemStack s = ((Slot)((TagItemFilterMenu)this.f_97732_).f_38839_.get(0)).m_7993_();
        List<String> tags = s.m_204131_().map(t -> t.f_203868_().toString()).toList();
        if (!this.itemTags.equals(tags)) {
            this.itemTags.clear();
            this.itemTags.addAll(tags);
            this.itemTagList.selected = null;
            this.itemTagList.currentScroll = 0.0f;
        }
    }

    private void click(int id, boolean val) {
        this.f_96541_.f_91072_.m_105208_(((TagItemFilterMenu)this.f_97732_).f_38840_, id << 1 | (val ? 1 : 0));
    }

    public GuiButton.CompositeButton makeCompositeButton(int x, int y, int tile, Button.OnPress pressable) {
        GuiButton.CompositeButton btn = new GuiButton.CompositeButton(x, y, tile, pressable);
        btn.texX = 176;
        btn.texY = 0;
        btn.texture = GUI_TEXTURES;
        return btn;
    }

    public void m_88315_(GuiGraphics matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.renderBackground(matrixStack, mouseX, mouseY, partialTicks);
        this.buttonAllowList.setState(((TagItemFilterMenu)this.f_97732_).allowList ? 1 : 0);
        this.itemTagList.preRender(mouseX, mouseY);
        this.filterList.preRender(mouseX, mouseY);
        this.buttonAdd.f_93623_ = this.itemTagList.selected != null;
        this.buttonRemove.f_93623_ = this.filterList.selected != null;
        super.m_88315_(matrixStack, mouseX, mouseY, partialTicks);
        this.itemTagList.render(matrixStack);
        this.filterList.render(matrixStack);
        this.m_280072_(matrixStack, mouseX, mouseY);
        this.itemTagList.tooltip(matrixStack, mouseX, mouseY);
        this.filterList.tooltip(matrixStack, mouseX, mouseY);
    }

    protected void m_7286_(GuiGraphics matrixStack, float partialTicks, int x, int y) {
        int i = (this.f_96543_ - this.f_97726_) / 2;
        int j = (this.f_96544_ - this.f_97727_) / 2;
        matrixStack.m_280218_(GUI_TEXTURES, i, j, 0, 0, this.f_97726_, this.f_97727_);
    }

    @Override
    public void receive(CompoundTag tag) {
        ListTag list = tag.m_128437_("l", 8);
        this.filterTags.clear();
        for (int i = 0; i < list.size(); ++i) {
            this.filterTags.add(list.m_128778_(i));
        }
        this.filterList.selected = null;
        this.filterList.currentScroll = 0.0f;
    }

    public boolean m_6050_(double x, double y, double dir) {
        if (this.m_6774_(27, 14, 61, 58, x, y) && this.itemTagList.mouseScrolled(dir)) {
            return true;
        }
        if (this.m_6774_(108, 14, 61, 58, x, y) && this.filterList.mouseScrolled(dir)) {
            return true;
        }
        return super.m_6050_(x, y, dir);
    }

    public class ListHandler {
        protected float currentScroll;
        protected boolean isScrolling;
        protected boolean wasClicking;
        protected Supplier<List<String>> list;
        protected String selected;
        private List<ListEntry> listEntries = new ArrayList<ListEntry>();
        private int x;
        private int y;

        public ListHandler(int x, int y) {
            for (int i = 0; i < 4; ++i) {
                this.listEntries.add(new ListEntry(x, y + i * 14, i));
            }
            this.x = x;
            this.y = y;
        }

        public void tooltip(GuiGraphics matrixStack, int mouseX, int mouseY) {
            this.listEntries.stream().filter(s -> s.m_274382_()).findFirst().ifPresent(le -> {
                String id = le.getId();
                if (id != null) {
                    matrixStack.m_280557_(TagItemFilterScreen.this.f_96547_, (Component)Component.m_237113_((String)id), mouseX, mouseY);
                }
            });
        }

        public boolean needsScrollBars() {
            return this.list.get().size() > 4;
        }

        public void preRender(int mouseX, int mouseY) {
            boolean flag = GLFW.glfwGetMouseButton((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)0) != 0;
            int k = this.x + 56;
            int l = this.y - 1;
            int i1 = k + 14;
            int j1 = l + 58;
            if (!this.wasClicking && flag && mouseX >= k && mouseY >= l && mouseX < i1 && mouseY < j1) {
                this.isScrolling = this.needsScrollBars();
            }
            if (!flag) {
                this.isScrolling = false;
            }
            this.wasClicking = flag;
            if (this.isScrolling) {
                this.currentScroll = ((float)(mouseY - l) - 4.5f) / ((float)(j1 - l) - 9.0f);
                this.currentScroll = Mth.m_14036_((float)this.currentScroll, (float)0.0f, (float)1.0f);
            }
        }

        public void render(GuiGraphics st) {
            int i = this.x + 55;
            int k = this.y + this.list.get().size() * 14;
            st.m_280218_(GUI_TEXTURES, i, this.y - 1 + (int)(49.0f * this.currentScroll), 176 + (this.needsScrollBars() ? 5 : 0), 32, 5, 9);
        }

        public boolean mouseScrolled(double dir) {
            if (!this.needsScrollBars()) {
                return false;
            }
            int i = this.list.get().size() - 4;
            this.currentScroll = (float)((double)this.currentScroll - dir / (double)i);
            this.currentScroll = Mth.m_14036_((float)this.currentScroll, (float)0.0f, (float)1.0f);
            return true;
        }

        public class ListEntry
        extends ButtonExt {
            private int id;

            public ListEntry(int x, int y, int id) {
                super(x, y, 53, 14, null, null);
                this.id = id;
                TagItemFilterScreen.this.m_142416_((GuiEventListener)this);
            }

            public void m_87963_(GuiGraphics st, int mouseX, int mouseY, float pt) {
                String id;
                if (this.f_93624_ && (id = this.getId()) != null) {
                    int x = this.m_252754_();
                    int y = this.m_252907_();
                    st.m_280246_(1.0f, 1.0f, 1.0f, this.f_93625_);
                    RenderSystem.enableBlend();
                    RenderSystem.enableDepthTest();
                    this.f_93622_ = mouseX >= x && mouseY >= y && mouseX < x + this.f_93618_ && mouseY < y + this.f_93619_;
                    int i = this.getYImage(this.m_198029_()) - 1;
                    st.m_280218_(GUI_TEXTURES, x, y, 176, 41 + i * 14 + (id.equals(ListHandler.this.selected) ? 28 : 0), this.f_93618_, this.f_93619_);
                    int c = this.f_93623_ ? 0xFFFFFF : 0xA0A0A0;
                    int v = c | Mth.m_14167_((float)(this.f_93625_ * 255.0f)) << 24;
                    int k = this.m_252754_() + 2;
                    int l = this.m_252754_() + this.m_5711_() - 2;
                    AbstractWidget.m_280138_((GuiGraphics)st, (Font)TagItemFilterScreen.this.f_96547_, (Component)Component.m_237113_((String)id), (int)k, (int)this.m_252907_(), (int)l, (int)(this.m_252907_() + this.m_93694_()), (int)v);
                }
            }

            public void m_5691_() {
                String id = this.getId();
                if (id != null) {
                    ListHandler.this.selected = id;
                }
            }

            private String getId() {
                List<String> l = ListHandler.this.list.get();
                int i = l.size() - 4;
                int j = (int)((double)(ListHandler.this.currentScroll * (float)i) + 0.5);
                if (j < 0) {
                    j = 0;
                }
                if (this.id + j < l.size()) {
                    return l.get(this.id + j);
                }
                return null;
            }
        }
    }
}

