/*
 * Decompiled with CFR 0.152.
 */
package com.tom.storagemod.jei;

import com.tom.storagemod.Content;
import com.tom.storagemod.gui.CraftingTerminalMenu;
import com.tom.storagemod.jei.PlatformRecipeTransferHandler;
import com.tom.storagemod.util.IAutoFillTerminal;
import com.tom.storagemod.util.StoredItemStack;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.ingredient.IRecipeSlotView;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.transfer.IRecipeTransferError;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandlerHelper;
import mezz.jei.api.registration.IRecipeTransferRegistration;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import org.jetbrains.annotations.Nullable;

public class CraftingTerminalTransferHandler<C extends AbstractContainerMenu>
implements PlatformRecipeTransferHandler<C> {
    private final Class<C> containerClass;
    private final IRecipeTransferHandlerHelper helper;
    private static final List<Class<? extends AbstractContainerMenu>> containerClasses = new ArrayList<Class<? extends AbstractContainerMenu>>();
    private static final IRecipeTransferError ERROR_INSTANCE = new IRecipeTransferError(){

        public IRecipeTransferError.Type getType() {
            return IRecipeTransferError.Type.INTERNAL;
        }
    };

    public CraftingTerminalTransferHandler(Class<C> containerClass, IRecipeTransferHandlerHelper helper) {
        this.containerClass = containerClass;
        this.helper = helper;
    }

    public Class<C> getContainerClass() {
        return this.containerClass;
    }

    @Nullable
    public IRecipeTransferError transferRecipe(C container, CraftingRecipe recipe, IRecipeSlotsView recipeSlots, Player player, boolean maxTransfer, boolean doTransfer) {
        if (container instanceof IAutoFillTerminal) {
            ListTag list;
            IAutoFillTerminal term = (IAutoFillTerminal)container;
            ArrayList<IRecipeSlotView> missing = new ArrayList<IRecipeSlotView>();
            List views = recipeSlots.getSlotViews();
            ArrayList<ListTag> inputs = new ArrayList<ListTag>();
            HashSet<StoredItemStack> stored = new HashSet<StoredItemStack>(term.getStoredItems());
            for (IRecipeSlotView view : views) {
                if (view.getRole() != RecipeIngredientRole.INPUT && view.getRole() != RecipeIngredientRole.CATALYST) continue;
                list = (ListTag)view.getIngredients((IIngredientType)VanillaTypes.ITEM_STACK).toArray(ItemStack[]::new);
                if (((ListTag)list).length == 0) {
                    inputs.add(null);
                    continue;
                }
                inputs.add(list);
                boolean found = false;
                for (ListTag stack : list) {
                    if (stack == null || player.m_150109_().m_36030_((ItemStack)stack) == -1) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    for (ListTag stack : list) {
                        StoredItemStack s = new StoredItemStack((ItemStack)stack);
                        if (!stored.contains(s)) continue;
                        found = true;
                        break;
                    }
                }
                if (found) continue;
                missing.add(view);
            }
            if (doTransfer) {
                ItemStack[][] stacks = (ItemStack[][])inputs.toArray((T[])new ItemStack[0][]);
                CompoundTag compound = new CompoundTag();
                list = new ListTag();
                for (int i = 0; i < stacks.length; ++i) {
                    if (stacks[i] == null) continue;
                    CompoundTag CompoundNBT = new CompoundTag();
                    CompoundNBT.m_128344_("s", (byte)i);
                    int k = 0;
                    for (int j = 0; j < stacks[i].length && k < 9; ++j) {
                        StoredItemStack s;
                        if (stacks[i][j] == null || stacks[i][j].m_41619_() || !stored.contains(s = new StoredItemStack(stacks[i][j])) && player.m_150109_().m_36030_(stacks[i][j]) == -1) continue;
                        CompoundTag tag = new CompoundTag();
                        stacks[i][j].m_41739_(tag);
                        CompoundNBT.m_128365_("i" + k++, (Tag)tag);
                    }
                    CompoundNBT.m_128344_("l", (byte)Math.min(9, k));
                    list.add((Object)CompoundNBT);
                }
                compound.m_128365_("i", (Tag)list);
                term.sendMessage(compound);
            }
            if (!missing.isEmpty()) {
                return new TransferWarning(this.helper.createUserErrorForMissingSlots((Component)Component.m_237115_((String)"tooltip.toms_storage.items_missing"), missing));
            }
        } else {
            return ERROR_INSTANCE;
        }
        return null;
    }

    public static void registerTransferHandlers(IRecipeTransferRegistration recipeTransferRegistry) {
        for (int i = 0; i < containerClasses.size(); ++i) {
            recipeTransferRegistry.addRecipeTransferHandler(new CraftingTerminalTransferHandler<AbstractContainerMenu>(containerClasses.get(i), recipeTransferRegistry.getTransferHelper()), RecipeTypes.CRAFTING);
        }
    }

    public Optional<MenuType<C>> getMenuType() {
        return Optional.ofNullable(Content.craftingTerminalCont.get());
    }

    static {
        containerClasses.add(CraftingTerminalMenu.class);
    }

    private static class TransferWarning
    implements IRecipeTransferError {
        private final IRecipeTransferError parent;

        public TransferWarning(IRecipeTransferError parent) {
            this.parent = parent;
        }

        public IRecipeTransferError.Type getType() {
            return IRecipeTransferError.Type.COSMETIC;
        }

        public void showError(GuiGraphics guiGraphics, int mouseX, int mouseY, IRecipeSlotsView recipeSlotsView, int recipeX, int recipeY) {
            this.parent.showError(guiGraphics, mouseX, mouseY, recipeSlotsView, recipeX, recipeY);
        }
    }
}

