/*
 * Decompiled with CFR 0.152.
 */
package com.tom.storagemod.tile;

import com.tom.storagemod.Content;
import com.tom.storagemod.block.InventoryProxyBlock;
import com.tom.storagemod.tile.PaintedBlockEntity;
import com.tom.storagemod.util.IProxy;
import com.tom.storagemod.util.TickerUtil;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.EmptyHandler;

public class InventoryProxyBlockEntity
extends PaintedBlockEntity
implements TickerUtil.TickableServer {
    private LazyOptional<IItemHandler> invHandler;
    private LazyOptional<IItemHandler> pointedAt;
    private boolean calling;

    public InventoryProxyBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)Content.invProxyTile.get(), pos, state);
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        BlockState state;
        Direction facing;
        if (!this.f_58859_ && cap == ForgeCapabilities.ITEM_HANDLER && side != (facing = (Direction)(state = this.f_58857_.m_8055_(this.f_58858_)).m_61143_((Property)InventoryProxyBlock.FACING))) {
            if (this.invHandler == null) {
                this.invHandler = LazyOptional.of(() -> new InvHandler());
            }
            return this.invHandler.cast();
        }
        return super.getCapability(cap, side);
    }

    public <R> R call(Function<IItemHandler, R> func, Predicate<IItemHandler> accessCheck, R def) {
        IItemHandler ih;
        if (this.calling) {
            return def;
        }
        this.calling = true;
        if (this.pointedAt != null && accessCheck.test(ih = (IItemHandler)this.pointedAt.orElse((Object)EmptyHandler.INSTANCE))) {
            R r = func.apply(ih);
            this.calling = false;
            return r;
        }
        this.calling = false;
        return def;
    }

    private int getMaxCountPerStack() {
        return 64;
    }

    public void m_7651_() {
        super.m_7651_();
        if (this.invHandler != null) {
            this.invHandler.invalidate();
        }
    }

    @Override
    public void updateServer() {
        if (this.f_58857_.m_46467_() % 20L == 18L) {
            BlockEntity te;
            BlockState state = this.f_58857_.m_8055_(this.f_58858_);
            Direction facing = (Direction)state.m_61143_((Property)InventoryProxyBlock.FACING);
            if (!(this.pointedAt != null && this.pointedAt.isPresent() || (te = this.f_58857_.m_7702_(this.f_58858_.m_121945_(facing))) == null || te instanceof InventoryProxyBlockEntity)) {
                this.pointedAt = te.getCapability(ForgeCapabilities.ITEM_HANDLER, facing.m_122424_());
            }
            this.f_58857_.m_46717_(this.f_58858_, this.m_58900_().m_60734_());
        }
    }

    private boolean checkFilter(IItemHandler w, int slot, ItemStack stack) {
        return true;
    }

    private class InvHandler
    implements IItemHandler,
    IProxy {
        private InvHandler() {
        }

        public int getSlots() {
            return InventoryProxyBlockEntity.this.call(IItemHandler::getSlots, i -> true, 0);
        }

        public ItemStack getStackInSlot(int slot) {
            return InventoryProxyBlockEntity.this.call(i -> i.getStackInSlot(slot), i -> InventoryProxyBlockEntity.this.checkFilter((IItemHandler)i, slot, null), ItemStack.f_41583_);
        }

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            return InventoryProxyBlockEntity.this.call(i -> i.insertItem(slot, stack, simulate), i -> InventoryProxyBlockEntity.this.checkFilter((IItemHandler)i, slot, stack), stack);
        }

        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            return InventoryProxyBlockEntity.this.call(i -> i.extractItem(slot, amount, simulate), i -> InventoryProxyBlockEntity.this.checkFilter((IItemHandler)i, slot, null), ItemStack.f_41583_);
        }

        public int getSlotLimit(int slot) {
            return InventoryProxyBlockEntity.this.call(i -> Math.min(i.getSlotLimit(slot), InventoryProxyBlockEntity.this.getMaxCountPerStack()), i -> true, 0);
        }

        public boolean isItemValid(int slot, ItemStack stack) {
            return InventoryProxyBlockEntity.this.call(i -> i.isItemValid(slot, stack), i -> InventoryProxyBlockEntity.this.checkFilter((IItemHandler)i, slot, stack), false);
        }

        @Override
        public IItemHandler get() {
            if (InventoryProxyBlockEntity.this.pointedAt != null) {
                return (IItemHandler)InventoryProxyBlockEntity.this.pointedAt.orElse(null);
            }
            return null;
        }
    }
}

