/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.network;

import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;
import net.p3pp3rf1y.sophisticatedcore.common.gui.StorageContainerMenuBase;

public class TransferFullSlotMessage {
    private final int slotId;

    public TransferFullSlotMessage(int slotId) {
        this.slotId = slotId;
    }

    public static void encode(TransferFullSlotMessage msg, FriendlyByteBuf packetBuffer) {
        packetBuffer.writeInt(msg.slotId);
    }

    public static TransferFullSlotMessage decode(FriendlyByteBuf packetBuffer) {
        return new TransferFullSlotMessage(packetBuffer.readInt());
    }

    public static void onMessage(TransferFullSlotMessage msg, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> TransferFullSlotMessage.handleMessage(context.getSender(), msg));
        context.setPacketHandled(true);
    }

    private static void handleMessage(@Nullable ServerPlayer player, TransferFullSlotMessage msg) {
        ItemStack transferResult;
        AbstractContainerMenu abstractContainerMenu;
        if (player == null || !((abstractContainerMenu = player.f_36096_) instanceof StorageContainerMenuBase)) {
            return;
        }
        StorageContainerMenuBase storageContainer = (StorageContainerMenuBase)abstractContainerMenu;
        Slot slot = storageContainer.m_38853_(msg.slotId);
        while (!(transferResult = storageContainer.m_7648_((Player)player, msg.slotId)).m_41619_() && ItemStack.m_41656_((ItemStack)slot.m_7993_(), (ItemStack)transferResult)) {
        }
    }
}

