/*
 * Decompiled with CFR 0.152.
 */
package immersive_aircraft;

import immersive_aircraft.Main;
import immersive_aircraft.entity.VehicleEntity;
import immersive_aircraft.entity.misc.WeaponMount;
import immersive_aircraft.entity.weapons.BombBay;
import immersive_aircraft.entity.weapons.HeavyCrossbow;
import immersive_aircraft.entity.weapons.RotaryCannon;
import immersive_aircraft.entity.weapons.Telescope;
import immersive_aircraft.entity.weapons.Weapon;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;

public class WeaponRegistry {
    public static final Map<ResourceLocation, WeaponConstructor> REGISTRY = new HashMap<ResourceLocation, WeaponConstructor>();

    public static void register(ResourceLocation id, WeaponConstructor constructor) {
        REGISTRY.put(id, constructor);
    }

    public static void bootstrap() {
    }

    public static WeaponConstructor get(ItemStack weapon) {
        return REGISTRY.get(BuiltInRegistries.f_257033_.m_7981_((Object)weapon.m_41720_()));
    }

    static {
        WeaponRegistry.register(Main.locate("rotary_cannon"), RotaryCannon::new);
        WeaponRegistry.register(Main.locate("heavy_crossbow"), HeavyCrossbow::new);
        WeaponRegistry.register(Main.locate("telescope"), Telescope::new);
        WeaponRegistry.register(Main.locate("bomb_bay"), BombBay::new);
    }

    public static interface WeaponConstructor {
        public Weapon create(VehicleEntity var1, ItemStack var2, WeaponMount var3, int var4);
    }
}

