/*
 * Decompiled with CFR 0.152.
 */
package immersive_aircraft.entity;

import immersive_aircraft.WeaponRegistry;
import immersive_aircraft.cobalt.network.NetworkHandler;
import immersive_aircraft.config.Config;
import immersive_aircraft.data.VehicleDataLoader;
import immersive_aircraft.entity.VehicleEntity;
import immersive_aircraft.entity.inventory.SparseSimpleInventory;
import immersive_aircraft.entity.inventory.VehicleInventoryDescription;
import immersive_aircraft.entity.inventory.slots.SlotDescription;
import immersive_aircraft.entity.misc.VehicleProperties;
import immersive_aircraft.entity.misc.WeaponMount;
import immersive_aircraft.entity.weapons.Telescope;
import immersive_aircraft.entity.weapons.Weapon;
import immersive_aircraft.item.WeaponItem;
import immersive_aircraft.item.upgrade.VehicleStat;
import immersive_aircraft.item.upgrade.VehicleUpgrade;
import immersive_aircraft.item.upgrade.VehicleUpgradeRegistry;
import immersive_aircraft.mixin.ServerPlayerEntityMixin;
import immersive_aircraft.network.s2c.OpenGuiRequest;
import immersive_aircraft.screen.VehicleScreenHandler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerListener;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

public abstract class InventoryVehicleEntity
extends VehicleEntity
implements ContainerListener,
MenuProvider,
Container {
    private final VehicleProperties properties;
    private SparseSimpleInventory inventory;
    protected final Map<Integer, List<Weapon>> weapons = new HashMap<Integer, List<Weapon>>();
    private static final List<WeaponMount> EMPTY_WEAPONS = List.of(WeaponMount.EMPTY);
    private static final Map<WeaponMount.Type, List<WeaponMount>> EMPTY_WEAPONS_MAP = Map.of();

    public InventoryVehicleEntity(EntityType<? extends InventoryVehicleEntity> entityType, Level world, boolean canExplodeOnCrash) {
        super(entityType, world, canExplodeOnCrash);
        this.initInventory();
        this.properties = new VehicleProperties(VehicleDataLoader.get(this.identifier).getProperties(), this);
    }

    public VehicleProperties getProperties() {
        return this.properties;
    }

    public VehicleInventoryDescription getInventoryDescription() {
        return VehicleDataLoader.get(this.identifier).getInventoryDescription();
    }

    public List<WeaponMount> getWeaponMounts(int slot) {
        ItemStack stack = this.m_141942_(slot).m_142196_();
        Item item = stack.m_41720_();
        if (item instanceof WeaponItem) {
            WeaponItem weaponItem = (WeaponItem)item;
            return VehicleDataLoader.get(this.identifier).getWeaponMounts().getOrDefault(slot, EMPTY_WEAPONS_MAP).getOrDefault((Object)weaponItem.getMountType(), EMPTY_WEAPONS);
        }
        return EMPTY_WEAPONS;
    }

    public List<ItemStack> getSlots(String slotType) {
        List<SlotDescription> slots = this.getInventoryDescription().getSlots(slotType);
        ArrayList<ItemStack> list = new ArrayList<ItemStack>(slots.size());
        for (SlotDescription slot : slots) {
            list.add(this.getInventory().m_8020_(slot.index()));
        }
        return list;
    }

    public float getTotalUpgrade(VehicleStat stat) {
        float value = 1.0f;
        List<ItemStack> upgrades = this.getSlots(VehicleInventoryDescription.UPGRADE);
        for (int step = 0; step < 2; ++step) {
            for (ItemStack stack : upgrades) {
                VehicleUpgrade upgrade = VehicleUpgradeRegistry.INSTANCE.getUpgrade(stack.m_41720_());
                if (upgrade == null) continue;
                float u = upgrade.get(stat);
                if (u > 0.0f && step == 1) {
                    value += u;
                    continue;
                }
                if (!(u < 0.0f) || step != 0) continue;
                value *= u + 1.0f;
            }
        }
        return Math.max(0.0f, value);
    }

    protected void initInventory() {
        this.inventory = new SparseSimpleInventory(this.getInventoryDescription().getInventorySize());
        this.inventory.m_19164_(this);
    }

    public SparseSimpleInventory getInventory() {
        int inventorySize = this.getInventoryDescription().getInventorySize();
        if (inventorySize != this.inventory.m_6643_()) {
            this.initInventory();
        }
        return this.inventory;
    }

    public void m_5757_(Container sender) {
    }

    @Override
    protected void dropInventory() {
        for (SlotDescription slot : this.getInventoryDescription().getSlots()) {
            ItemStack stack;
            boolean isCargo = slot.type().equals(VehicleInventoryDescription.INVENTORY);
            if ((!isCargo || !Config.getInstance().dropInventory) && (isCargo || !Config.getInstance().dropUpgrades) || (stack = this.m_141942_(slot.index()).m_142196_()).m_41619_()) continue;
            this.m_19983_(stack.m_278832_());
        }
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int i, Inventory playerInventory, Player playerEntity) {
        return new VehicleScreenHandler(i, playerInventory, this);
    }

    public void openInventory(ServerPlayer player) {
        player.m_9217_();
        AbstractContainerMenu screenHandler = this.m_7208_(player.f_8940_, player.m_150109_(), (Player)player);
        if (screenHandler != null) {
            NetworkHandler.sendToPlayer(new OpenGuiRequest(this, screenHandler.f_38840_), player);
            player.f_36096_ = screenHandler;
            ServerPlayerEntityMixin playerAccessor = (ServerPlayerEntityMixin)player;
            screenHandler.m_150416_(playerAccessor.getContainerSynchronizer());
        }
    }

    @Override
    public InteractionResult m_6096_(Player player, InteractionHand hand) {
        if (!player.m_9236_().f_46443_ && player.m_36341_() && !this.m_20365_((Entity)player)) {
            Entity primaryPassenger = this.m_146895_();
            if (primaryPassenger != null) {
                primaryPassenger.m_8127_();
            } else {
                this.openInventory((ServerPlayer)player);
            }
            return InteractionResult.CONSUME;
        }
        if (this.getPassengerSpace() == 0 && player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            this.openInventory(serverPlayer);
        }
        return super.m_6096_(player, hand);
    }

    @Override
    protected void m_7380_(@NotNull CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128365_("Inventory", (Tag)this.getInventory().writeNbt(new ListTag()));
    }

    @Override
    protected void m_7378_(@NotNull CompoundTag tag) {
        super.m_7378_(tag);
        ListTag nbtList = tag.m_128437_("Inventory", 10);
        this.getInventory().readNbt(nbtList);
    }

    @Override
    protected void addItemTag(@NotNull CompoundTag tag) {
        super.addItemTag(tag);
        tag.m_128365_("Inventory", (Tag)this.getInventory().writeNbt(new ListTag()));
    }

    @Override
    protected void readItemTag(@NotNull CompoundTag tag) {
        super.readItemTag(tag);
        ListTag nbtList = tag.m_128437_("Inventory", 10);
        this.getInventory().readNbt(nbtList);
    }

    @Override
    public void boost() {
        int length = this.getSlots(VehicleInventoryDescription.BOOSTER).stream().mapToInt(s -> {
            byte l = s.m_41698_("Fireworks").m_128445_("Flight");
            s.m_41774_(1);
            return l;
        }).sum();
        super.boost(length * 50);
    }

    @Override
    protected void applyBoost() {
        super.applyBoost();
        Vector3f direction = this.getForwardDirection();
        float thrust = 0.05f * (float)this.getBoost() / 100.0f;
        this.m_20256_(this.m_20184_().m_82549_(this.toVec3d(direction.mul(thrust))));
        if (this.f_19797_ % 2 == 0) {
            Vec3 p = this.m_20182_();
            Vec3 velocity = this.m_20184_().m_82546_(this.toVec3d(direction));
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123815_, p.m_7096_(), p.m_7098_(), p.m_7094_(), velocity.f_82479_, velocity.f_82480_, velocity.f_82481_);
        }
    }

    @Override
    public boolean canBoost() {
        return this.getSlots(VehicleInventoryDescription.BOOSTER).stream().anyMatch(v -> !v.m_41619_()) && this.getBoost() <= 0;
    }

    @Override
    public void m_8119_() {
        this.getInventory().tick(this);
        for (SlotDescription slot : this.getInventoryDescription().getSlots(VehicleInventoryDescription.WEAPON)) {
            WeaponRegistry.WeaponConstructor constructor;
            ItemStack weaponItemStack = this.m_141942_(slot.index()).m_142196_();
            List<Weapon> weapon = this.weapons.get(slot.index());
            if (weaponItemStack.m_41619_() && weapon != null) {
                this.weapons.remove(slot.index());
                continue;
            }
            if (weaponItemStack.m_41619_() || weapon != null && weapon.get(0).getStack() == weaponItemStack || (constructor = WeaponRegistry.get(weaponItemStack)) == null) continue;
            List<WeaponMount> weaponMounts = this.getWeaponMounts(slot.index());
            ArrayList<Weapon> weapons = new ArrayList<Weapon>(weaponMounts.size());
            for (WeaponMount weaponMount : weaponMounts) {
                weapons.add(constructor.create(this, weaponItemStack, weaponMount, slot.index()));
            }
            this.weapons.put(slot.index(), weapons);
        }
        int gunnerOffset = this.m_20197_().size();
        for (List<Weapon> weapons : this.getWeapons().values()) {
            --gunnerOffset;
            for (Weapon weapon : weapons) {
                weapon.setGunnerOffset(Math.max(0, gunnerOffset));
            }
        }
        for (List<Weapon> weapons : this.weapons.values()) {
            for (Weapon w : weapons) {
                w.tick();
            }
        }
        super.m_8119_();
    }

    protected float getGroundDecay() {
        return this.getProperties().get(VehicleStat.GROUND_FRICTION);
    }

    protected void applyFriction() {
        float decay = 1.0f - this.getProperties().get(VehicleStat.FRICTION);
        float gravity = this.getGravity();
        if (this.f_19798_) {
            gravity *= 0.25f;
            decay = 0.9f;
        } else if (this.m_20096_()) {
            decay = this.m_20160_() ? this.getGroundDecay() : 0.75f;
        }
        Vec3 velocity = this.m_20184_();
        float hd = this.getProperties().get(VehicleStat.HORIZONTAL_DECAY);
        float vd = this.getProperties().get(VehicleStat.VERTICAL_DECAY);
        this.m_20334_(velocity.f_82479_ * (double)decay * (double)hd, velocity.f_82480_ * (double)decay * (double)vd + (double)gravity, velocity.f_82481_ * (double)decay * (double)hd);
        float rf = decay * this.getProperties().get(VehicleStat.ROTATION_DECAY);
        this.pressingInterpolatedX.decay(0.0f, 1.0f - rf);
        this.pressingInterpolatedZ.decay(0.0f, 1.0f - rf);
    }

    public SlotAccess m_141942_(int slot) {
        return SlotAccess.m_147292_((Container)this.getInventory(), (int)slot);
    }

    public Map<Integer, List<Weapon>> getWeapons() {
        return this.weapons;
    }

    @Override
    public float getDurability() {
        return this.getProperties().get(VehicleStat.DURABILITY);
    }

    public boolean isScoping() {
        Collection<List<Weapon>> values = this.getWeapons().values();
        for (List<Weapon> weapons : values) {
            for (Weapon weapon : weapons) {
                Telescope telescope;
                if (!(weapon instanceof Telescope) || !(telescope = (Telescope)weapon).isScoping().booleanValue()) continue;
                return true;
            }
        }
        return false;
    }

    public int m_6643_() {
        return this.inventory.m_6643_();
    }

    public boolean m_7983_() {
        return this.inventory.m_7983_();
    }

    public ItemStack m_8020_(int slot) {
        return this.inventory.m_8020_(slot);
    }

    public ItemStack m_7407_(int slot, int amount) {
        return this.inventory.m_7407_(slot, amount);
    }

    public ItemStack m_8016_(int slot) {
        return this.inventory.m_8016_(slot);
    }

    public void m_6836_(int slot, ItemStack stack) {
        this.inventory.m_6836_(slot, stack);
    }

    public void m_6596_() {
        this.inventory.m_6596_();
    }

    public boolean m_6542_(Player player) {
        return this.inventory.m_6542_(player);
    }

    public void m_6211_() {
        this.inventory.m_6211_();
    }

    public boolean m_7013_(int index, ItemStack stack) {
        SlotDescription slotType = this.getInventoryDescription().getSlots().get(index);
        Slot slot = slotType.getSlot(this, (Container)this.inventory);
        return slot.m_5857_(stack);
    }

    public boolean m_271862_(Container target, int index, ItemStack stack) {
        SlotDescription slotType = this.getInventoryDescription().getSlots().get(index);
        return slotType.type().equals(VehicleInventoryDescription.INVENTORY);
    }

    public void clientFireWeapons(Entity entity) {
        int gunnerIndex = this.m_20197_().indexOf(entity);
        for (List<Weapon> weapons : this.getWeapons().values()) {
            int index = 0;
            for (Weapon weapon : weapons) {
                if (weapon.getGunnerOffset() != gunnerIndex) continue;
                weapon.clientFire(index++);
            }
        }
    }

    public void fireWeapon(int slot, int index, Vector3f direction) {
        this.getWeapons().get(slot).get(index).fire(direction);
    }
}

