/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsspellbooks.capabilities.magic;

import io.redspace.ironsspellbooks.IronsSpellbooks;
import io.redspace.ironsspellbooks.api.magic.MagicData;
import io.redspace.ironsspellbooks.api.registry.SpellRegistry;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.api.spells.ICastDataSerializable;
import io.redspace.ironsspellbooks.capabilities.magic.PlayerRecasts;
import io.redspace.ironsspellbooks.capabilities.magic.RecastInstance;
import io.redspace.ironsspellbooks.capabilities.magic.RecastResult;
import io.redspace.ironsspellbooks.data.IronsDataStorage;
import io.redspace.ironsspellbooks.entity.spells.portal.PortalData;
import io.redspace.ironsspellbooks.entity.spells.portal.PortalEntity;
import java.util.HashMap;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.util.INBTSerializable;

public class PortalManager
implements INBTSerializable<CompoundTag> {
    public static final PortalManager INSTANCE = new PortalManager();
    private final HashMap<UUID, HashMap<UUID, AtomicInteger>> cooldownLookup = new HashMap();
    private final HashMap<UUID, PortalData> portalLookup = new HashMap();
    private static final int cooldownTicks = 10;

    public PortalData getPortalData(PortalEntity portalEntity) {
        return this.portalLookup.get(portalEntity.m_20148_());
    }

    public void addPortalData(UUID portalEntityUUID, PortalData portalData) {
        this.portalLookup.put(portalEntityUUID, portalData);
        IronsDataStorage.INSTANCE.m_77762_();
    }

    public void addPortalCooldown(Entity entity, UUID portalId) {
        PortalData portalData = this.portalLookup.get(portalId);
        if (portalData == null) {
            return;
        }
        HashMap playerMap = this.cooldownLookup.computeIfAbsent(portalData.getConnectedPortalUUID(portalId), k -> new HashMap());
        playerMap.put(entity.m_20148_(), new AtomicInteger(10));
    }

    public boolean isEntityOnCooldown(Entity entity, UUID portalId) {
        HashMap<UUID, AtomicInteger> playerMap = this.cooldownLookup.get(portalId);
        return playerMap != null && playerMap.containsKey(entity.m_20148_());
    }

    public boolean isPortalConnected(UUID portalID) {
        UUID connectedPortal;
        PortalData portalData = this.portalLookup.get(portalID);
        return portalData != null && (connectedPortal = portalData.getConnectedPortalUUID(portalID)) != null;
    }

    public boolean canUsePortal(PortalEntity portalEntity, Entity entity) {
        if (portalEntity == null || entity == null) {
            return false;
        }
        PortalData portalData = this.portalLookup.get(portalEntity.m_20148_());
        return !entity.m_20159_() && portalData != null && portalData.portalEntityId1 != null && portalData.portalEntityId2 != null && this.portalLookup.containsKey(portalData.portalEntityId1) && this.portalLookup.containsKey(portalData.portalEntityId2) && !this.isEntityOnCooldown(entity, portalEntity.m_20148_());
    }

    public void processCooldownTick(UUID portalUUID, int delta) {
        HashMap<UUID, AtomicInteger> playerCooldownsForPortal = this.cooldownLookup.get(portalUUID);
        if (playerCooldownsForPortal != null) {
            playerCooldownsForPortal.entrySet().stream().filter(item -> ((AtomicInteger)item.getValue()).addAndGet(delta) <= 0).toList().forEach(itemToRemove -> playerCooldownsForPortal.remove(itemToRemove.getKey()));
        }
    }

    public void processDelayCooldown(UUID portalUUID, UUID playerUUID, int delta) {
        AtomicInteger cooldown;
        HashMap<UUID, AtomicInteger> playerCooldownsForPortal = this.cooldownLookup.get(portalUUID);
        if (playerCooldownsForPortal != null && (cooldown = playerCooldownsForPortal.get(playerUUID)) != null) {
            cooldown.addAndGet(delta);
        }
    }

    public void removePortalData(UUID portalUUID) {
        this.portalLookup.remove(portalUUID);
        this.cooldownLookup.remove(portalUUID);
        IronsDataStorage.INSTANCE.m_77762_();
    }

    public void killPortal(UUID portalUUID, UUID ownerUUID) {
        PortalData removedPortalData = this.portalLookup.remove(portalUUID);
        if (removedPortalData != null) {
            if (removedPortalData.portalEntityId2 == null || removedPortalData.globalPos2 == null) {
                this.tryCancelRecast(portalUUID, ownerUUID);
            } else {
                UUID connectedPortalUUID = removedPortalData.getConnectedPortalUUID(portalUUID);
                if (connectedPortalUUID != null) {
                    removedPortalData = this.portalLookup.remove(connectedPortalUUID);
                    removedPortalData.getConnectedPortalPos(portalUUID).ifPresent(globalPos -> {
                        Entity connectedPortalToRemove;
                        ServerLevel level = IronsSpellbooks.MCS.m_129880_(globalPos.dimension());
                        if (level != null && (connectedPortalToRemove = level.m_8791_(connectedPortalUUID)) != null) {
                            connectedPortalToRemove.m_146870_();
                        }
                    });
                    this.cooldownLookup.remove(connectedPortalUUID);
                }
            }
        }
        this.cooldownLookup.remove(portalUUID);
        IronsDataStorage.INSTANCE.m_77762_();
    }

    private void tryCancelRecast(UUID portalUUID, UUID ownerUUID) {
        IronsSpellbooks.MCS.m_129785_().forEach(level -> {
            ICastDataSerializable patt6558$temp;
            String spellId;
            MagicData magicData;
            PlayerRecasts playerRecasts;
            RecastInstance recastInstance;
            Player player = level.m_46003_(ownerUUID);
            if (player != null && (recastInstance = (playerRecasts = (magicData = MagicData.getPlayerMagicData((LivingEntity)player)).getPlayerRecasts()).getRecastInstance(spellId = ((AbstractSpell)SpellRegistry.PORTAL_SPELL.get()).getSpellId())) != null && (patt6558$temp = recastInstance.castData) instanceof PortalData) {
                PortalData portalData = (PortalData)patt6558$temp;
                if (portalData.portalEntityId1 == portalUUID) {
                    playerRecasts.removeRecast(recastInstance, RecastResult.COUNTERSPELL);
                    return;
                }
            }
        });
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        ListTag portalLookupTag = new ListTag();
        if (!this.portalLookup.isEmpty()) {
            portalLookupTag.addAll(this.portalLookup.entrySet().stream().map(entry -> {
                CompoundTag itemTag = new CompoundTag();
                itemTag.m_128362_("key", (UUID)entry.getKey());
                itemTag.m_128365_("value", (Tag)((PortalData)entry.getValue()).serializeNBT());
                return itemTag;
            }).toList());
        }
        tag.m_128365_("portalLookup", (Tag)portalLookupTag);
        return tag;
    }

    public void deserializeNBT(CompoundTag compoundTag) {
        ListTag portalLookupTag;
        if (compoundTag.m_128441_("portalLookup") && (portalLookupTag = (ListTag)compoundTag.m_128423_("portalLookup")) != null) {
            portalLookupTag.forEach(tag -> {
                CompoundTag portalLookupItem = (CompoundTag)tag;
                PortalData portalData = new PortalData();
                portalData.deserializeNBT(portalLookupItem.m_128469_("value"));
                this.portalLookup.put(portalLookupItem.m_128342_("key"), portalData);
            });
        }
    }
}

