/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsspellbooks.player;

import com.google.common.collect.Multimap;
import io.redspace.ironsspellbooks.IronsSpellbooks;
import io.redspace.ironsspellbooks.api.entity.IMagicEntity;
import io.redspace.ironsspellbooks.api.magic.MagicData;
import io.redspace.ironsspellbooks.api.registry.AttributeRegistry;
import io.redspace.ironsspellbooks.api.spells.CastSource;
import io.redspace.ironsspellbooks.api.spells.CastType;
import io.redspace.ironsspellbooks.api.spells.ISpellContainer;
import io.redspace.ironsspellbooks.api.util.CameraShakeManager;
import io.redspace.ironsspellbooks.api.util.Utils;
import io.redspace.ironsspellbooks.block.BloodCauldronBlock;
import io.redspace.ironsspellbooks.capabilities.magic.CooldownInstance;
import io.redspace.ironsspellbooks.capabilities.magic.RecastResult;
import io.redspace.ironsspellbooks.capabilities.magic.SyncedSpellData;
import io.redspace.ironsspellbooks.capabilities.magic.UpgradeData;
import io.redspace.ironsspellbooks.compat.tetra.TetraProxy;
import io.redspace.ironsspellbooks.config.ServerConfigs;
import io.redspace.ironsspellbooks.data.DataFixerStorage;
import io.redspace.ironsspellbooks.data.IronsDataStorage;
import io.redspace.ironsspellbooks.datafix.IronsWorldUpgrader;
import io.redspace.ironsspellbooks.datagen.DamageTypeTagGenerator;
import io.redspace.ironsspellbooks.effect.AbyssalShroudEffect;
import io.redspace.ironsspellbooks.effect.EvasionEffect;
import io.redspace.ironsspellbooks.effect.SummonTimer;
import io.redspace.ironsspellbooks.entity.mobs.MagicSummon;
import io.redspace.ironsspellbooks.entity.spells.root.PreventDismount;
import io.redspace.ironsspellbooks.item.CastingItem;
import io.redspace.ironsspellbooks.item.Scroll;
import io.redspace.ironsspellbooks.item.curios.CurioBaseItem;
import io.redspace.ironsspellbooks.network.ClientboundEquipmentChanged;
import io.redspace.ironsspellbooks.network.ClientboundSyncMana;
import io.redspace.ironsspellbooks.player.ClientMagicData;
import io.redspace.ironsspellbooks.registries.BlockRegistry;
import io.redspace.ironsspellbooks.registries.ItemRegistry;
import io.redspace.ironsspellbooks.registries.MobEffectRegistry;
import io.redspace.ironsspellbooks.setup.Messages;
import io.redspace.ironsspellbooks.util.MinecraftInstanceHelper;
import io.redspace.ironsspellbooks.util.ModTags;
import io.redspace.ironsspellbooks.util.UpgradeUtils;
import java.util.List;
import java.util.Optional;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.LayeredRegistryAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetEntityDataPacket;
import net.minecraft.network.protocol.game.ClientboundUpdateMobEffectPacket;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.RegistryLayer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.event.AnvilUpdateEvent;
import net.minecraftforge.event.ItemAttributeModifierEvent;
import net.minecraftforge.event.entity.EntityMountEvent;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.event.entity.item.ItemTossEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingChangeTargetEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEquipmentChangeEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingExperienceDropEvent;
import net.minecraftforge.event.entity.living.MobSpawnEvent;
import net.minecraftforge.event.entity.player.PlayerContainerEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.event.server.ServerAboutToStartEvent;
import net.minecraftforge.event.server.ServerStartedEvent;
import net.minecraftforge.event.server.ServerStoppedEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.event.CurioAttributeModifierEvent;
import top.theillusivec4.curios.api.event.CurioChangeEvent;

@Mod.EventBusSubscriber
public class ServerPlayerEvents {
    @SubscribeEvent
    public static void onPlayerDropItem(ItemTossEvent event) {
        MagicData magicData;
        ItemStack itemStack = event.getEntity().m_32055_();
        if (itemStack.m_41720_() instanceof Scroll && (magicData = MagicData.getPlayerMagicData((LivingEntity)event.getPlayer())).isCasting() && magicData.getCastSource() == CastSource.SCROLL && magicData.getCastType() == CastType.CONTINUOUS) {
            itemStack.m_41774_(1);
        }
    }

    @SubscribeEvent
    public static void onLevelLoaded(LevelEvent.Load event) {
        ServerLevel serverLevel;
        LevelAccessor levelAccessor = event.getLevel();
        if (levelAccessor instanceof ServerLevel && (serverLevel = (ServerLevel)levelAccessor).m_46472_() == Level.f_46428_) {
            IronsDataStorage.init(serverLevel.m_8895_());
        }
    }

    @SubscribeEvent
    public static void onServerStoppedEvent(ServerStoppedEvent event) {
        IronsSpellbooks.MCS = null;
        IronsSpellbooks.OVERWORLD = null;
    }

    @SubscribeEvent
    public static void onServerStarted(ServerStartedEvent event) {
        IronsSpellbooks.MCS = event.getServer();
        IronsSpellbooks.OVERWORLD = IronsSpellbooks.MCS.m_129783_();
    }

    @SubscribeEvent
    public static void onServerAboutToStart(ServerAboutToStartEvent event) {
        DataFixerStorage.init(event.getServer().f_129744_);
        if (((Boolean)ServerConfigs.RUN_WORLD_UPGRADER.get()).booleanValue()) {
            MinecraftServer server = event.getServer();
            new IronsWorldUpgrader(server.f_129744_, (LayeredRegistryAccess<RegistryLayer>)server.m_247573_()).runUpgrade();
        }
    }

    @SubscribeEvent
    public static void onLivingEquipmentChangeEvent(LivingEquipmentChangeEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)livingEntity;
            MagicData playerMagicData = MagicData.getPlayerMagicData((LivingEntity)serverPlayer);
            if (playerMagicData.isCasting() && (event.getFrom().m_41720_() instanceof CastingItem || event.getTo().m_41720_() instanceof CastingItem)) {
                Utils.serverSideCancelCast(serverPlayer);
                Messages.sendToPlayer(new ClientboundEquipmentChanged(), serverPlayer);
                return;
            }
            boolean isFromSpellContainer = ISpellContainer.isSpellContainer(event.getFrom());
            if (isFromSpellContainer && ISpellContainer.get(event.getFrom()).getIndexForSpell(playerMagicData.getCastingSpell().getSpell()) >= 0) {
                IronsSpellbooks.LOGGER.debug("onLivingEquipmentChangeEvent from:\n{}\n{}", (Object)event.getFrom().toString(), (Object)Integer.toHexString(event.getFrom().hashCode()));
                IronsSpellbooks.LOGGER.debug("onLivingEquipmentChangeEvent to:\n{}\n{}", (Object)event.getTo().toString(), (Object)Integer.toHexString(event.getTo().hashCode()));
                if (playerMagicData.isCasting()) {
                    Utils.serverSideCancelCast(serverPlayer);
                }
                Messages.sendToPlayer(new ClientboundEquipmentChanged(), serverPlayer);
            } else if (isFromSpellContainer || ISpellContainer.isSpellContainer(event.getTo())) {
                Messages.sendToPlayer(new ClientboundEquipmentChanged(), serverPlayer);
            }
        }
    }

    @SubscribeEvent
    public static void onCurioChangeEvent(CurioChangeEvent event) {
        LivingEntity entity = event.getEntity();
        if (entity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)entity;
            if (ISpellContainer.isSpellContainer(event.getFrom()) || ISpellContainer.isSpellContainer(event.getTo())) {
                Messages.sendToPlayer(new ClientboundEquipmentChanged(), serverPlayer);
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerLogOut(PlayerEvent.PlayerLoggedOutEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            Utils.serverSideCancelCast(serverPlayer);
        }
    }

    @SubscribeEvent
    public static void onPlayerOpenContainer(PlayerContainerEvent.Open event) {
        ServerPlayer serverPlayer;
        MagicData playerMagicData;
        if (event.getEntity().f_19853_.f_46443_) {
            return;
        }
        Player player = event.getEntity();
        if (player instanceof ServerPlayer && (playerMagicData = MagicData.getPlayerMagicData((LivingEntity)(serverPlayer = (ServerPlayer)player))).isCasting()) {
            Utils.serverSideCancelCast(serverPlayer);
        }
    }

    @SubscribeEvent
    public static void handleUpgradeModifiers(ItemAttributeModifierEvent event) {
        UpgradeData upgradeData = UpgradeData.getUpgradeData(event.getItemStack());
        if (upgradeData != UpgradeData.NONE && upgradeData.getUpgradedSlot().equals(event.getSlotType().m_20751_())) {
            UpgradeUtils.handleAttributeEvent((Multimap<Attribute, AttributeModifier>)event.getModifiers(), upgradeData, (arg_0, arg_1) -> ((ItemAttributeModifierEvent)event).addModifier(arg_0, arg_1), (arg_0, arg_1) -> ((ItemAttributeModifierEvent)event).removeModifier(arg_0, arg_1), Optional.empty());
        }
    }

    @SubscribeEvent
    public static void handleCurioUpgradeModifiers(CurioAttributeModifierEvent event) {
        UpgradeData upgradeData = UpgradeData.getUpgradeData(event.getItemStack());
        if (upgradeData != UpgradeData.NONE && upgradeData.getUpgradedSlot().equals(event.getSlotContext().identifier())) {
            UpgradeUtils.handleAttributeEvent((Multimap<Attribute, AttributeModifier>)event.getModifiers(), upgradeData, (arg_0, arg_1) -> ((CurioAttributeModifierEvent)event).addModifier(arg_0, arg_1), (arg_0, arg_1) -> ((CurioAttributeModifierEvent)event).removeModifier(arg_0, arg_1), Optional.of(event.getUuid()));
        }
    }

    @SubscribeEvent
    public static void onExperienceDroppedEvent(LivingExperienceDropEvent event) {
        Player player = event.getAttackingPlayer();
        if (player != null) {
            int ringCount = CuriosApi.getCuriosHelper().findCurios((LivingEntity)player, (Item)ItemRegistry.EMERALD_STONEPLATE_RING.get()).size();
            for (int i = 0; i < ringCount; ++i) {
                event.setDroppedExperience((int)((double)event.getDroppedExperience() * 1.25));
            }
        }
    }

    @SubscribeEvent
    public static void onStartTracking(PlayerEvent.StartTracking event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            player = event.getTarget();
            if (player instanceof ServerPlayer) {
                ServerPlayer targetPlayer = (ServerPlayer)player;
                MagicData.getPlayerMagicData((LivingEntity)serverPlayer).getSyncedData().syncToPlayer(targetPlayer);
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            MagicData playerMagicData = MagicData.getPlayerMagicData((LivingEntity)serverPlayer);
            playerMagicData.getPlayerCooldowns().syncToPlayer(serverPlayer);
            playerMagicData.getPlayerRecasts().syncAllToPlayer();
            playerMagicData.getSyncedData().syncToPlayer(serverPlayer);
            Messages.sendToPlayer(new ClientboundSyncMana(playerMagicData), serverPlayer);
            CameraShakeManager.doSync(serverPlayer);
        }
    }

    @SubscribeEvent
    public static void onLivingDeathEvent(LivingDeathEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)livingEntity;
            Utils.serverSideCancelCast(serverPlayer);
            MagicData.getPlayerMagicData((LivingEntity)serverPlayer).getPlayerRecasts().removeAll(RecastResult.DEATH);
        }
    }

    @SubscribeEvent
    public static void onPlayerCloned(PlayerEvent.Clone event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer newServerPlayer = (ServerPlayer)player;
            boolean keepEverything = !event.isWasDeath();
            event.getOriginal().m_21220_().forEach(effect -> {
                if (effect.m_19544_() instanceof SummonTimer) {
                    newServerPlayer.m_147207_(effect, (Entity)newServerPlayer);
                }
            });
            event.getOriginal().reviveCaps();
            MagicData oldMagicData = MagicData.getPlayerMagicData((LivingEntity)event.getOriginal());
            MagicData newMagicData = MagicData.getPlayerMagicData((LivingEntity)event.getEntity());
            newMagicData.setSyncedData(oldMagicData.getSyncedData().getPersistentData());
            newMagicData.getSyncedData().doSync();
            oldMagicData.getPlayerCooldowns().getSpellCooldowns().forEach((spellId, cooldown) -> newMagicData.getPlayerCooldowns().getSpellCooldowns().put((String)spellId, (CooldownInstance)cooldown));
            event.getOriginal().invalidateCaps();
        }
    }

    @SubscribeEvent
    public static void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            Utils.serverSideCancelCast(serverPlayer);
        }
    }

    @SubscribeEvent
    public static void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            serverPlayer.m_20095_();
            serverPlayer.m_146917_(0);
            List data = serverPlayer.m_20088_().m_135378_();
            if (data != null) {
                serverPlayer.f_8906_.m_9829_((Packet)new ClientboundSetEntityDataPacket(serverPlayer.m_19879_(), data));
            }
            Utils.serverSideCancelCast(serverPlayer);
            serverPlayer.m_21220_().forEach(effect -> {
                if (effect.m_19544_() instanceof SummonTimer) {
                    serverPlayer.f_8906_.m_9829_((Packet)new ClientboundUpdateMobEffectPacket(serverPlayer.m_19879_(), effect));
                }
            });
            MagicData.getPlayerMagicData((LivingEntity)serverPlayer).setMana((int)(serverPlayer.m_21133_((Attribute)AttributeRegistry.MAX_MANA.get()) * (Double)ServerConfigs.MANA_SPAWN_PERCENT.get()));
        }
    }

    @SubscribeEvent
    public static void onLivingAttack(LivingAttackEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof ServerPlayer || livingEntity instanceof IMagicEntity) {
            if (((CurioBaseItem)((Object)ItemRegistry.FIREWARD_RING.get())).isEquippedBy(livingEntity) && event.getSource().m_269533_(DamageTypeTags.f_268745_)) {
                event.getEntity().m_20095_();
                event.setCanceled(true);
                return;
            }
            MagicData playerMagicData = MagicData.getPlayerMagicData(livingEntity);
            if (playerMagicData.getSyncedData().hasEffect(2L)) {
                if (EvasionEffect.doEffect(livingEntity, event.getSource())) {
                    event.setCanceled(true);
                }
            } else if (playerMagicData.getSyncedData().hasEffect(8L) && AbyssalShroudEffect.doEffect(livingEntity, event.getSource())) {
                event.setCanceled(true);
            }
        }
        TetraProxy.PROXY.handleLivingAttackEvent(event);
    }

    @SubscribeEvent
    public static void onLivingChangeTarget(LivingChangeTargetEvent event) {
        LivingEntity newTarget = event.getNewTarget();
        LivingEntity entity = event.getEntity();
        if (newTarget != null) {
            if (newTarget.m_6095_().m_204039_(ModTags.VILLAGE_ALLIES) && entity.m_6095_().m_204039_(ModTags.VILLAGE_ALLIES)) {
                event.setCanceled(true);
            }
            if (newTarget instanceof MagicSummon) {
                MagicSummon summon = (MagicSummon)newTarget;
                if (!entity.equals((Object)((Mob)newTarget).m_5448_())) {
                    event.setCanceled(true);
                }
            }
        }
    }

    @SubscribeEvent
    public static void onLivingTakeDamage(LivingDamageEvent event) {
        MagicData playerMagicData;
        Creeper creeper;
        LivingEntity livingEntity;
        if (((Boolean)ServerConfigs.BETTER_CREEPER_THUNDERHIT.get()).booleanValue() && event.getSource().m_269533_(DamageTypeTags.f_268745_) && (livingEntity = event.getEntity()) instanceof Creeper && (creeper = (Creeper)livingEntity).m_7090_()) {
            event.setCanceled(true);
            return;
        }
        Entity attacker = event.getSource().m_7639_();
        if (attacker instanceof LivingEntity) {
            Player player;
            LivingEntity livingAttacker = (LivingEntity)attacker;
            if (livingAttacker.m_21023_((MobEffect)MobEffectRegistry.SPIDER_ASPECT.get()) && event.getEntity().m_21023_(MobEffects.f_19614_)) {
                int lvl = livingAttacker.m_21124_((MobEffect)MobEffectRegistry.SPIDER_ASPECT.get()).m_19564_() + 1;
                float before = event.getAmount();
                float multiplier = 1.0f + 0.05f * (float)lvl;
                event.setAmount(event.getAmount() * multiplier);
            }
            if (livingAttacker.m_20145_() && ((CurioBaseItem)((Object)ItemRegistry.LURKER_RING.get())).isEquippedBy(livingAttacker) && livingAttacker instanceof Player && !(player = (Player)livingAttacker).m_36335_().m_41519_((Item)ItemRegistry.LURKER_RING.get())) {
                event.setAmount(event.getAmount() * 1.5f);
                player.m_36335_().m_41524_((Item)ItemRegistry.LURKER_RING.get(), 300);
            }
        }
        if ((playerMagicData = MagicData.getPlayerMagicData(event.getEntity())).getSyncedData().hasEffect(4L)) {
            playerMagicData.getSyncedData().addHeartstopDamage(event.getAmount() * 0.5f);
            event.setCanceled(true);
            return;
        }
        LivingEntity livingEntity2 = event.getEntity();
        if (livingEntity2 instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)livingEntity2;
            if (playerMagicData.isCasting() && playerMagicData.getCastingSpell().getSpell().canBeInterrupted((Player)serverPlayer) && playerMagicData.getCastDurationRemaining() > 0 && !event.getSource().m_269533_(DamageTypeTagGenerator.LONG_CAST_IGNORE) && !playerMagicData.popMarkedPoison()) {
                Utils.serverSideCancelCast(serverPlayer);
            }
        }
    }

    @SubscribeEvent
    public static void onEntityMountEvent(EntityMountEvent event) {
        ServerPlayer serverPlayer;
        MagicData playerMagicData;
        if (event.getEntity().f_19853_.f_46443_) {
            return;
        }
        Entity entity = event.getEntity();
        if (entity instanceof ServerPlayer && (playerMagicData = MagicData.getPlayerMagicData((LivingEntity)(serverPlayer = (ServerPlayer)entity))).isCasting()) {
            Utils.serverSideCancelCast(serverPlayer);
        }
    }

    @SubscribeEvent
    public static void preventDismount(EntityMountEvent event) {
        if (!event.getEntity().f_19853_.f_46443_ && event.getEntityBeingMounted() instanceof PreventDismount && event.isDismounting() && !event.getEntityBeingMounted().m_213877_()) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onProjectileImpact(ProjectileImpactEvent event) {
        EntityHitResult entityHitResult;
        Entity victim;
        HitResult hitResult = event.getRayTraceResult();
        if (hitResult instanceof EntityHitResult && ((victim = (entityHitResult = (EntityHitResult)hitResult).m_82443_()) instanceof IMagicEntity || victim instanceof Player)) {
            SyncedSpellData syncedSpellData;
            LivingEntity livingEntity = (LivingEntity)victim;
            SyncedSpellData syncedSpellData2 = syncedSpellData = livingEntity.f_19853_.f_46443_ ? ClientMagicData.getSyncedSpellData(livingEntity) : MagicData.getPlayerMagicData(livingEntity).getSyncedData();
            if (syncedSpellData.hasEffect(2L)) {
                if (EvasionEffect.doEffect(livingEntity, victim.m_269291_().m_269104_((Entity)event.getProjectile(), event.getProjectile().m_19749_()))) {
                    event.setCanceled(true);
                }
            } else if (syncedSpellData.hasEffect(8L) && AbyssalShroudEffect.doEffect(livingEntity, victim.m_269291_().m_269104_((Entity)event.getProjectile(), event.getProjectile().m_19749_()))) {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public static void useOnEntityEvent(PlayerInteractEvent.EntityInteractSpecific event) {
        Entity entity = event.getTarget();
        if (entity instanceof Creeper) {
            Creeper creeper = (Creeper)entity;
            Player player = event.getEntity();
            ItemStack useItem = player.m_21120_(event.getHand());
            if (useItem.m_150930_(Items.f_42590_) && creeper.m_7090_()) {
                creeper.m_6469_(creeper.m_269291_().m_269264_(), 5.0f);
                player.f_19853_.m_6263_((Player)null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11771_, SoundSource.NEUTRAL, 1.0f, 1.0f);
                player.m_6674_(event.getHand());
                event.setCancellationResult(InteractionResultHolder.m_19096_((Object)ItemUtils.m_41813_((ItemStack)useItem, (Player)player, (ItemStack)new ItemStack((ItemLike)ItemRegistry.LIGHTNING_BOTTLE.get()))).m_19089_());
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public static void useItemEvent(PlayerInteractEvent.RightClickItem event) {
        Player entity = event.getEntity();
        if (entity.f_19853_.f_46443_) {
            MinecraftInstanceHelper.ifPlayerPresent(localPlayer -> {
                if (ClientMagicData.isCasting() && entity.m_20148_().equals(localPlayer.m_20148_())) {
                    event.setCanceled(true);
                }
            });
        } else {
            MagicData magicData = MagicData.getPlayerMagicData((LivingEntity)entity);
            if (magicData.isCasting() && event.getItemStack() != magicData.getPlayerCastingItem()) {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public static void handleResistanceAttributesOnSpawn(MobSpawnEvent.FinalizeSpawn event) {
        Mob mob = event.getEntity();
        if (mob.m_6336_() == MobType.f_21641_) {
            ServerPlayerEvents.setIfNonNull((LivingEntity)mob, (Attribute)AttributeRegistry.HOLY_MAGIC_RESIST.get(), 0.5);
            ServerPlayerEvents.setIfNonNull((LivingEntity)mob, (Attribute)AttributeRegistry.BLOOD_MAGIC_RESIST.get(), 1.5);
        } else if (mob.m_6336_() == MobType.f_21644_) {
            ServerPlayerEvents.setIfNonNull((LivingEntity)mob, (Attribute)AttributeRegistry.LIGHTNING_MAGIC_RESIST.get(), 0.5);
        }
        if (mob.m_5825_()) {
            ServerPlayerEvents.setIfNonNull((LivingEntity)mob, (Attribute)AttributeRegistry.FIRE_MAGIC_RESIST.get(), 1.5);
        }
        if (mob.m_6095_() == EntityType.f_20551_) {
            ServerPlayerEvents.setIfNonNull((LivingEntity)mob, (Attribute)AttributeRegistry.ICE_MAGIC_RESIST.get(), 0.5);
        }
    }

    private static void setIfNonNull(LivingEntity mob, Attribute attribute, double value) {
        AttributeInstance instance = mob.m_21204_().m_22146_(attribute);
        if (instance != null) {
            instance.m_22100_(value);
        }
    }

    @SubscribeEvent
    public static void onLivingTick(LivingEvent.LivingTickEvent event) {
        BlockPos pos;
        BlockState blockState;
        LivingEntity entity = event.getEntity();
        Level level = entity.f_19853_;
        if (!level.f_46443_ && entity.f_19797_ % 40 == 0 && (blockState = entity.f_19853_.m_8055_(pos = entity.m_20183_())).m_60713_(Blocks.f_50256_)) {
            BloodCauldronBlock.attemptCookEntity(blockState, entity.f_19853_, pos, (Entity)entity, () -> {
                level.m_46597_(pos, ((Block)BlockRegistry.BLOOD_CAULDRON_BLOCK.get()).m_49966_());
                level.m_142346_(null, GameEvent.f_157792_, pos);
            });
        }
    }

    @SubscribeEvent
    public static void onAnvilRecipe(AnvilUpdateEvent event) {
        if (event.getRight().m_150930_((Item)ItemRegistry.SHRIVING_STONE.get())) {
            ItemStack newResult = event.getLeft().m_41777_();
            if (newResult.m_150930_((Item)ItemRegistry.SCROLL.get())) {
                return;
            }
            boolean flag = false;
            if (ISpellContainer.isSpellContainer(newResult)) {
                newResult.m_41749_("ISB_Spells");
                flag = true;
            } else if (UpgradeData.hasUpgradeData(newResult)) {
                newResult.m_41749_("ISBUpgrades");
                flag = true;
            }
            if (flag) {
                String itemName = event.getName();
                if (itemName != null && !Util.m_288217_((String)itemName)) {
                    if (!itemName.equals(newResult.m_41786_().getString())) {
                        newResult.m_41714_((Component)Component.m_237113_((String)itemName));
                    }
                } else if (newResult.m_41788_()) {
                    newResult.m_41787_();
                }
                event.setOutput(newResult);
                event.setCost(1);
                event.setMaterialCost(1);
            }
        }
    }

    @SubscribeEvent
    public static void changeDigSpeed(PlayerEvent.BreakSpeed event) {
        int i;
        Player player = event.getEntity();
        if (player.m_21023_((MobEffect)MobEffectRegistry.HASTENED.get())) {
            i = 1 + player.m_21124_((MobEffect)MobEffectRegistry.HASTENED.get()).m_19564_();
            event.setNewSpeed(event.getNewSpeed() * Utils.intPow(1.2f, i));
        }
        if (player.m_21023_((MobEffect)MobEffectRegistry.SLOWED.get())) {
            i = 1 + player.m_21124_((MobEffect)MobEffectRegistry.SLOWED.get()).m_19564_();
            event.setNewSpeed(event.getNewSpeed() * Utils.intPow(0.8f, i));
        }
    }
}

